/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.tools;

import com.rapidminer.tools.LogService;
import com.rapidminer.tools.MailSender;
import com.rapidminer.tools.MailUtilities;
import java.util.Date;
import java.util.Map;
import javax.mail.Message;
import javax.mail.Session;
import javax.mail.Transport;
import javax.mail.internet.MimeMessage;

public class MailSenderSMTP
implements MailSender {
    @Override
    public void sendEmail(String address, String subject, String content, Map<String, String> headers) throws Exception {
        Session session = MailUtilities.makeSession();
        if (session == null) {
            LogService.getRoot().warning("Unable to create mail session. Not sending mail to " + address + ".");
        }
        MimeMessage msg = new MimeMessage(session);
        msg.setRecipients(Message.RecipientType.TO, address);
        msg.setFrom();
        msg.setSubject(subject);
        msg.setSentDate(new Date());
        msg.setText(content);
        if (headers != null) {
            for (Map.Entry<String, String> header : headers.entrySet()) {
                msg.setHeader(header.getKey(), header.getValue());
            }
        }
        Transport.send((Message)msg);
    }
}

