/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.tools;

import com.rapidminer.gui.tools.LeanFormatter;
import com.rapidminer.tools.WrapperLoggingHandler;
import java.util.logging.ConsoleHandler;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.Logger;

public class LogService
extends WrapperLoggingHandler {
    public static final int UNKNOWN_LEVEL = -1;
    public static final int MINIMUM = 0;
    public static final int IO = 1;
    public static final int STATUS = 2;
    public static final int INIT = 3;
    public static final int NOTE = 4;
    public static final int WARNING = 5;
    public static final int ERROR = 6;
    public static final int FATAL = 7;
    public static final int MAXIMUM = 8;
    public static final int OFF = 9;
    public static final String[] LOG_VERBOSITY_NAMES = new String[]{"all", "io", "status", "init", "notes", "warning", "error", "fatal", "almost_none", "off"};
    public static final String GLOBAL_PREFIX = "$gG^g";
    private static final Logger GLOBAL_LOGGER = Logger.getLogger("com.rapidminer");
    private static final LogService GLOBAL_LOGGING = new LogService(GLOBAL_LOGGER);

    private LogService(Logger logger) {
        super(logger);
        LogService.getRoot().setLevel(Level.CONFIG);
        for (Handler handler : Logger.getLogger("").getHandlers()) {
            handler.setLevel(Level.CONFIG);
            if (!(handler instanceof ConsoleHandler)) continue;
            handler.setFormatter(new LeanFormatter());
        }
    }

    public static LogService getGlobal() {
        return GLOBAL_LOGGING;
    }

    public static Logger getRoot() {
        return GLOBAL_LOGGER;
    }

    public void setVerbosityLevel(int level) {
        LogService.getRoot().setLevel(LEVELS[level]);
    }

    @Deprecated
    public boolean isSufficientLogVerbosity(int level) {
        return GLOBAL_LOGGER.isLoggable(LEVELS[level]);
    }

    @Deprecated
    public static void logMessage(String message, int verbosityLevel) {
        LogService.getGlobal().log(message, verbosityLevel);
    }
}

