/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.tools;

import com.rapidminer.operator.OperatorException;
import com.rapidminer.operator.nio.model.CSVResultSetConfiguration;
import com.rapidminer.tools.CSVParseException;
import com.rapidminer.tools.Tools;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;

public class LineParser {
    public static final String DEFAULT_COMMENT_CHARACTER_STRING = "#";
    public static final String DEFAULT_SPLIT_EXPRESSION = ",\\s*|;\\s*";
    public static final String SPLIT_BY_TAB_EXPRESSION = "\t";
    public static final String SPLIT_BY_SPACE_EXPRESSION = "\\s";
    public static final String SPLIT_BY_COMMA_EXPRESSION = ",";
    public static final String SPLIT_BY_SEMICOLON_EXPRESSION = ";";
    public static final char DEFAULT_QUOTE_CHARACTER = '\"';
    public static final char DEFAULT_QUOTE_ESCAPE_CHARACTER = '\\';
    private static final char NONE = '\u0000';
    private Charset encoding;
    private boolean skipComments = true;
    private String commentCharacterString = "#";
    private Pattern splitPattern = Pattern.compile(",\\s*|;\\s*");
    private boolean useQuotes = true;
    private char quoteCharacter = (char)34;
    private char quoteEscapeCharacter = (char)92;
    private boolean trimLine = true;

    public LineParser() {
    }

    public LineParser(CSVResultSetConfiguration configuration) throws OperatorException {
        this();
        this.configure(configuration);
    }

    public void setEncoding(Charset encoding) {
        this.encoding = encoding;
    }

    public Charset getEncoding() {
        return this.encoding;
    }

    public boolean isTrimLine() {
        return this.trimLine;
    }

    public boolean isSkipComments() {
        return this.skipComments;
    }

    public String getSplitExpression() {
        return this.splitPattern.toString();
    }

    public String getCommentCharacters() {
        return this.commentCharacterString;
    }

    public boolean isUseQuotes() {
        return this.useQuotes;
    }

    public char getQuoteCharacter() {
        return this.quoteCharacter;
    }

    public char getQuoteEscapeCharacter() {
        return this.quoteEscapeCharacter;
    }

    public void setTrimLine(boolean trimLine) {
        this.trimLine = trimLine;
    }

    public void setSkipComments(boolean skipComments) {
        this.skipComments = skipComments;
    }

    public void setCommentCharacters(String commentCharacters) {
        this.commentCharacterString = commentCharacters;
    }

    public void setSplitExpression(String splitExpression) throws OperatorException {
        try {
            this.splitPattern = Pattern.compile(splitExpression);
        }
        catch (PatternSyntaxException e) {
            throw new OperatorException("Malformed split expression: " + splitExpression);
        }
    }

    public void setUseQuotes(boolean useQuotes) {
        this.useQuotes = useQuotes;
    }

    public void setQuoteCharacter(char quoteCharacter) {
        this.quoteCharacter = quoteCharacter;
    }

    public void setQuoteEscapeCharacter(char quoteEscapeCharacter) {
        this.quoteEscapeCharacter = quoteEscapeCharacter;
    }

    public String[] parse(String line) throws CSVParseException {
        if ((line = this.removeComment(line)) == null || "".equals(line.trim())) {
            return null;
        }
        return this.split(line);
    }

    public String removeComment(String line) {
        String resultingLine = line;
        if (this.skipComments) {
            for (int i = 0; i < this.commentCharacterString.length(); ++i) {
                int commentCharacterIndex = line.indexOf(this.commentCharacterString.charAt(i));
                if (commentCharacterIndex < 0) continue;
                resultingLine = line.substring(0, commentCharacterIndex);
                if (line.trim().length() != 0) continue;
                return null;
            }
        }
        return resultingLine;
    }

    public String[] split(String line) throws CSVParseException {
        if (this.splitPattern == null) {
            return new String[]{line};
        }
        if (this.splitPattern.toString().length() > 1) {
            return LineParser.split(line, this.splitPattern, this.trimLine, this.useQuotes ? this.quoteCharacter : (char)'\u0000', this.quoteEscapeCharacter);
        }
        return LineParser.fastSplit(line, this.splitPattern.toString().charAt(0), this.trimLine, this.useQuotes ? this.quoteCharacter : (char)'\u0000', this.quoteEscapeCharacter);
    }

    public static String[] split(String line, Pattern splitPattern, boolean trimLine) throws CSVParseException {
        String[] splittedString = splitPattern.split(trimLine ? line.trim() : line);
        return splittedString;
    }

    public static String[] split(String line, Pattern splitPattern, boolean trimLine, char quoteCharacter, char quoteEscapeCharacter) throws CSVParseException {
        String s = line;
        return Tools.quotedSplit(trimLine ? s.trim() : s, splitPattern, quoteCharacter, quoteEscapeCharacter);
    }

    public static String[] fastSplit(String line, char splitChar, boolean trimLine, char quoteChar, char escapeChar) throws CSVParseException {
        ArrayList<String> resultList = new ArrayList<String>();
        StringBuilder tempString = new StringBuilder();
        String errorMessage = "";
        int errorColumnIndex = 0;
        String errorLastFewReadChars = "";
        SplitMachineState machineState = SplitMachineState.NEW_SPLIT;
        line = trimLine ? line.trim() : line;
        block10: for (int i = 0; i < line.length(); ++i) {
            char currentChar = line.charAt(i);
            char nextChar = i + 1 < line.length() ? line.charAt(i + 1) : (char)'\u0000';
            switch (machineState) {
                case NEW_SPLIT: {
                    tempString.setLength(0);
                    if (currentChar == splitChar) {
                        resultList.add("");
                        continue block10;
                    }
                    if (currentChar == ' ' || currentChar == '\t') {
                        machineState = SplitMachineState.START_WHITESPACE;
                        continue block10;
                    }
                    if (currentChar == quoteChar) {
                        tempString.append(currentChar);
                        machineState = SplitMachineState.QUOTE_OPENED;
                        continue block10;
                    }
                    if (currentChar == escapeChar) {
                        if (nextChar == '\u0000') {
                            resultList.add("");
                            machineState = SplitMachineState.NEW_SPLIT;
                            continue block10;
                        }
                        tempString.append(nextChar);
                        ++i;
                        machineState = SplitMachineState.WRITE_NOT_QUOTE;
                        continue block10;
                    }
                    tempString.append(currentChar);
                    machineState = SplitMachineState.WRITE_NOT_QUOTE;
                    continue block10;
                }
                case START_WHITESPACE: {
                    if (currentChar == splitChar) {
                        resultList.add("");
                        machineState = SplitMachineState.NEW_SPLIT;
                        continue block10;
                    }
                    if (currentChar == ' ' || currentChar == '\t') continue block10;
                    if (currentChar == quoteChar) {
                        tempString.append(currentChar);
                        machineState = SplitMachineState.QUOTE_OPENED;
                        continue block10;
                    }
                    if (currentChar == escapeChar) {
                        if (nextChar == '\u0000') {
                            resultList.add(null);
                            machineState = SplitMachineState.END_OF_LINE;
                            continue block10;
                        }
                        tempString.append(nextChar);
                        ++i;
                        machineState = SplitMachineState.WRITE_NOT_QUOTE;
                        continue block10;
                    }
                    tempString.append(currentChar);
                    machineState = SplitMachineState.WRITE_NOT_QUOTE;
                    continue block10;
                }
                case WRITE_NOT_QUOTE: {
                    int k;
                    int j;
                    StringBuilder errorCharBuf;
                    if (currentChar == splitChar) {
                        resultList.add(tempString.toString());
                        if (nextChar == '\u0000') {
                            resultList.add("");
                            tempString = new StringBuilder();
                            machineState = SplitMachineState.END_OF_LINE;
                            continue block10;
                        }
                        machineState = SplitMachineState.NEW_SPLIT;
                        continue block10;
                    }
                    if (currentChar == escapeChar) {
                        if (nextChar == '\u0000') {
                            resultList.add(tempString.toString().trim());
                            machineState = SplitMachineState.END_OF_LINE;
                            continue block10;
                        }
                        tempString.append(nextChar);
                        ++i;
                        continue block10;
                    }
                    if (currentChar == quoteChar) {
                        errorMessage = "Value quote misplaced";
                        errorColumnIndex = i;
                        if (tempString.length() < 10) {
                            errorCharBuf = new StringBuilder();
                            errorCharBuf.append((CharSequence)tempString);
                            if (errorCharBuf.length() > 0) {
                                errorCharBuf.insert(0, splitChar);
                            }
                            j = errorCharBuf.length();
                            for (k = resultList.size() - 1; j < 20 && k >= 0; ++j, --k) {
                                errorCharBuf.insert(0, (String)resultList.get(k));
                                if (errorCharBuf.length() < 18) {
                                    errorCharBuf.insert(0, splitChar);
                                }
                                j = errorCharBuf.length();
                            }
                            errorCharBuf.reverse();
                            errorCharBuf.setLength(19);
                            errorCharBuf.reverse();
                            errorCharBuf.append(currentChar);
                            errorLastFewReadChars = errorCharBuf.toString();
                        } else {
                            errorLastFewReadChars = tempString.substring(tempString.length() - 9).toString() + currentChar;
                        }
                        machineState = SplitMachineState.ERROR;
                        continue block10;
                    }
                    tempString.append(currentChar);
                    continue block10;
                }
                case END_OF_LINE: {
                    continue block10;
                }
                case QUOTE_OPENED: {
                    int k;
                    int j;
                    StringBuilder errorCharBuf;
                    if (currentChar == quoteChar) {
                        tempString.append(currentChar);
                        machineState = SplitMachineState.QUOTE_CLOSED;
                        continue block10;
                    }
                    if (currentChar == escapeChar) {
                        if (nextChar == '\u0000') {
                            errorMessage = "Value quotes malformed";
                            errorColumnIndex = i;
                            if (tempString.length() < 10) {
                                errorCharBuf = new StringBuilder();
                                errorCharBuf.append((CharSequence)tempString);
                                if (errorCharBuf.length() > 0) {
                                    errorCharBuf.insert(0, splitChar);
                                }
                                j = errorCharBuf.length();
                                for (k = resultList.size() - 1; j < 20 && k >= 0; ++j, --k) {
                                    errorCharBuf.insert(0, (String)resultList.get(k));
                                    if (errorCharBuf.length() < 18) {
                                        errorCharBuf.insert(0, splitChar);
                                    }
                                    j = errorCharBuf.length();
                                }
                                errorCharBuf.reverse();
                                errorCharBuf.setLength(19);
                                errorCharBuf.reverse();
                                errorCharBuf.append(currentChar);
                                errorLastFewReadChars = errorCharBuf.toString();
                            } else {
                                errorLastFewReadChars = tempString.substring(tempString.length() - 9).toString() + currentChar;
                            }
                            machineState = SplitMachineState.ERROR;
                            continue block10;
                        }
                        tempString.append(nextChar);
                        ++i;
                        machineState = SplitMachineState.WRITE_QUOTE;
                        continue block10;
                    }
                    tempString.append(currentChar);
                    machineState = SplitMachineState.WRITE_QUOTE;
                    continue block10;
                }
                case WRITE_QUOTE: {
                    int k;
                    int j;
                    StringBuilder errorCharBuf;
                    if (nextChar != '\u0000' && nextChar == quoteChar && currentChar == quoteChar) {
                        tempString.append(nextChar);
                        ++i;
                        continue block10;
                    }
                    if (currentChar == quoteChar) {
                        tempString.append(currentChar);
                        machineState = SplitMachineState.QUOTE_CLOSED;
                        continue block10;
                    }
                    if (currentChar == escapeChar) {
                        if (nextChar == '\u0000') {
                            errorMessage = "Value quotes malformed";
                            errorColumnIndex = i;
                            if (tempString.length() < 10) {
                                errorCharBuf = new StringBuilder();
                                errorCharBuf.append((CharSequence)tempString);
                                if (errorCharBuf.length() > 0) {
                                    errorCharBuf.insert(0, splitChar);
                                }
                                j = errorCharBuf.length();
                                for (k = resultList.size() - 1; j < 20 && k >= 0; ++j, --k) {
                                    errorCharBuf.insert(0, (String)resultList.get(k));
                                    if (errorCharBuf.length() < 18) {
                                        errorCharBuf.insert(0, splitChar);
                                    }
                                    j = errorCharBuf.length();
                                }
                                errorCharBuf.reverse();
                                errorCharBuf.setLength(19);
                                errorCharBuf.reverse();
                                errorCharBuf.append(currentChar);
                                errorLastFewReadChars = errorCharBuf.toString();
                            } else {
                                errorLastFewReadChars = tempString.substring(tempString.length() - 9).toString() + currentChar;
                            }
                            machineState = SplitMachineState.ERROR;
                            throw new CSVParseException(errorMessage + " at position " + i + ". Last characters read: " + errorLastFewReadChars);
                        }
                        tempString.append(nextChar);
                        ++i;
                        continue block10;
                    }
                    tempString.append(currentChar);
                    continue block10;
                }
                case QUOTE_CLOSED: {
                    int k;
                    int j;
                    StringBuilder errorCharBuf;
                    if (currentChar == splitChar) {
                        if (tempString.charAt(0) == quoteChar && tempString.charAt(tempString.length() - 1) == quoteChar) {
                            resultList.add(tempString.substring(1, tempString.length() - 1).trim());
                        } else {
                            resultList.add(tempString.toString());
                        }
                        if (nextChar == '\u0000') {
                            resultList.add("");
                            tempString = new StringBuilder();
                            machineState = SplitMachineState.END_OF_LINE;
                            continue block10;
                        }
                        machineState = SplitMachineState.NEW_SPLIT;
                        continue block10;
                    }
                    if (currentChar == ' ' || currentChar == '\t') continue block10;
                    errorMessage = "Unexpected character after closed value quote";
                    errorColumnIndex = i;
                    if (tempString.length() < 10) {
                        errorCharBuf = new StringBuilder();
                        errorCharBuf.append((CharSequence)tempString);
                        if (errorCharBuf.length() > 0) {
                            errorCharBuf.insert(0, splitChar);
                        }
                        j = errorCharBuf.length();
                        for (k = resultList.size() - 1; j < 20 && k >= 0; ++j, --k) {
                            errorCharBuf.insert(0, (String)resultList.get(k));
                            if (errorCharBuf.length() < 18) {
                                errorCharBuf.insert(0, splitChar);
                            }
                            j = errorCharBuf.length();
                        }
                        errorCharBuf.reverse();
                        errorCharBuf.setLength(19);
                        errorCharBuf.reverse();
                        errorCharBuf.append(currentChar);
                        errorLastFewReadChars = errorCharBuf.toString();
                    } else {
                        errorLastFewReadChars = tempString.substring(tempString.length() - 9).toString() + currentChar;
                    }
                    throw new CSVParseException(errorMessage + " at position " + i + ". Last characters read: " + errorLastFewReadChars);
                }
                case ERROR: {
                    throw new CSVParseException(errorMessage + " at position " + i + ". Last characters read: " + errorLastFewReadChars);
                }
            }
        }
        if (machineState == SplitMachineState.QUOTE_OPENED || machineState == SplitMachineState.WRITE_QUOTE) {
            errorMessage = "Value quotes not closed";
            errorColumnIndex = line.length() - 1;
            if (tempString.length() < 10) {
                StringBuilder errorCharBuf = new StringBuilder();
                errorCharBuf.append((CharSequence)tempString);
                if (errorCharBuf.length() > 0) {
                    errorCharBuf.insert(0, splitChar);
                }
                int j = errorCharBuf.length();
                for (int k = resultList.size() - 1; j < 20 && k >= 0; ++j, --k) {
                    errorCharBuf.insert(0, (String)resultList.get(k));
                    if (errorCharBuf.length() < 18) {
                        errorCharBuf.insert(0, splitChar);
                    }
                    j = errorCharBuf.length();
                }
                errorCharBuf.reverse();
                errorCharBuf.setLength(20);
                errorCharBuf.reverse();
                errorLastFewReadChars = errorCharBuf.toString();
            } else {
                errorLastFewReadChars = tempString.substring(tempString.length() - 10).toString();
            }
            throw new IllegalArgumentException(errorMessage + " at position " + errorColumnIndex + ". Last characters read: " + errorLastFewReadChars);
        }
        if (tempString.length() > 0) {
            if (machineState == SplitMachineState.QUOTE_CLOSED && tempString.charAt(0) == quoteChar && tempString.charAt(tempString.length() - 1) == quoteChar) {
                resultList.add(tempString.substring(1, tempString.length() - 1).trim());
                tempString = new StringBuilder();
            } else {
                resultList.add(tempString.toString());
                tempString = new StringBuilder();
            }
        }
        String[] resultArray = new String[resultList.size()];
        resultList.toArray(resultArray);
        return resultArray;
    }

    public void configure(CSVResultSetConfiguration configuration) throws OperatorException {
        this.setTrimLine(configuration.isTrimLines());
        this.setSkipComments(configuration.isSkipComments());
        this.setSplitExpression(configuration.getColumnSeparators());
        this.setUseQuotes(configuration.isUseQuotes());
        this.setQuoteCharacter(configuration.getQuoteCharacter());
        this.setQuoteEscapeCharacter(configuration.getEscapeCharacter());
        this.setCommentCharacters(configuration.getCommentCharacters());
        this.setEncoding(configuration.getEncoding());
    }

    private static enum SplitMachineState {
        NEW_SPLIT,
        START_WHITESPACE,
        WRITE_NOT_QUOTE,
        QUOTE_OPENED,
        QUOTE_CLOSED,
        WRITE_QUOTE,
        ERROR,
        END_OF_LINE;

    }
}

