/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.tools;

import com.rapidminer.RapidMiner;
import com.rapidminer.io.process.XMLTools;
import com.rapidminer.tools.LogService;
import com.rapidminer.tools.ParameterService;
import com.rapidminer.tools.XMLException;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.UnknownHostException;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class LaunchListener {
    private static final String FAILED = "<failed/>";
    private static final String UNKNOWN_COMMAND = "<unknown-command/>";
    private static final String REJECTED = "<rejected/>";
    private static final String OK = "<ok/>";
    private static final String HELLO_MESSAGE = "<hi>I am RapidMiner. I understand a bit of XML.</hi>";
    private static final Logger LOGGER = Logger.getLogger(LaunchListener.class.getName());
    private static final LaunchListener INSTANCE = new LaunchListener();
    private RemoteControlHandler handler;

    private LaunchListener() {
    }

    private File getSocketFile() {
        return ParameterService.getUserConfigFile("socket");
    }

    public static LaunchListener getInstance() {
        return INSTANCE;
    }

    private void installListener(final RemoteControlHandler handler) throws IOException {
        final ServerSocket serverSocket = new ServerSocket(0, 1, InetAddress.getLocalHost());
        int port = serverSocket.getLocalPort();
        final File socketFile = this.getSocketFile();
        LOGGER.info("Listening for other instances on port " + port + ". Writing " + socketFile + ".");
        PrintStream socketOut = new PrintStream(socketFile);
        socketOut.println("" + port);
        socketOut.close();
        RapidMiner.addShutdownHook(new Runnable(){

            @Override
            public void run() {
                LOGGER.config("Deleting " + socketFile);
                socketFile.delete();
            }
        });
        Thread listenerThread = new Thread("Launch-Listener"){

            @Override
            public void run() {
                LaunchListener.this.handler = handler;
                while (true) {
                    try {
                        Socket client = serverSocket.accept();
                        LaunchListener.this.talkToSecondClient(client);
                        continue;
                    }
                    catch (IOException e) {
                        LogService.getRoot().log(Level.WARNING, "Error accepting socket connection: " + e, e);
                        continue;
                    }
                    break;
                }
            }
        };
        listenerThread.setDaemon(true);
        listenerThread.start();
    }

    private void talkToSecondClient(Socket client) {
        try {
            block11: {
                LOGGER.info("Second client launched.");
                PrintStream out = new PrintStream(client.getOutputStream());
                out.println(HELLO_MESSAGE);
                Document doc = XMLTools.parse(client.getInputStream());
                LOGGER.config("Read XML document from other client: ");
                String command = doc.getDocumentElement().getTagName();
                if ("args".equals(command)) {
                    NodeList argsElems = doc.getDocumentElement().getElementsByTagName("arg");
                    LinkedList<String> args = new LinkedList<String>();
                    for (int i = 0; i < argsElems.getLength(); ++i) {
                        args.add(argsElems.item(i).getTextContent());
                    }
                    if (this.handler != null) {
                        LOGGER.config("Handling <args> command from other client.");
                        try {
                            if (this.handler.handleArguments(args.toArray(new String[args.size()]))) {
                                out.println(OK);
                                break block11;
                            }
                            out.println(REJECTED);
                        }
                        catch (Exception e) {
                            LOGGER.log(Level.WARNING, "Error executing remote control command: " + e, e);
                            out.println(FAILED);
                        }
                    } else {
                        LOGGER.warning("Other client sent <args> command, but I don't have a handler installed.");
                        out.println(FAILED);
                    }
                } else {
                    out.println(UNKNOWN_COMMAND);
                    LOGGER.warning("Unknown command from second client: <" + command + ">.");
                }
            }
            client.close();
        }
        catch (IOException e) {
            LOGGER.log(Level.WARNING, "Failed to talk to client: " + e, e);
        }
        catch (SAXException e) {
            LOGGER.log(Level.WARNING, "I don't understand what the other client is trying to say: " + e, e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Socket getOtherInstance() {
        int port;
        File socketFile = this.getSocketFile();
        if (!socketFile.exists()) {
            LOGGER.config("Socket file " + socketFile + " does not exist. Assuming I am the first instance.");
            return null;
        }
        BufferedReader in = null;
        try {
            in = new BufferedReader(new FileReader(socketFile));
            String portStr = in.readLine();
            port = Integer.parseInt(portStr);
        }
        catch (Exception e) {
            LOGGER.log(Level.WARNING, "Failed to read socket file '" + socketFile + "': " + e, e);
            Socket socket = null;
            return socket;
        }
        finally {
            try {
                in.close();
            }
            catch (IOException e) {}
        }
        LOGGER.config("Checking for running instance on port " + port + ".");
        try {
            return new Socket("localhost", port);
        }
        catch (UnknownHostException e) {
            LOGGER.config("Name localhost cannot be resolved. Assuming we are the first instance.");
            return null;
        }
        catch (IOException e) {
            LOGGER.config("Got exception " + e + ". Assuming we are the first instance.");
            return null;
        }
    }

    private boolean readHelloMessage(BufferedReader in) throws IOException {
        boolean isRM;
        String line = in.readLine();
        if (HELLO_MESSAGE.equals(line)) {
            LOGGER.config("Found other RapidMiner instance.");
            isRM = true;
        } else {
            LOGGER.config("Read unknown string from other instance: " + line);
            isRM = false;
        }
        return isRM;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean sendToOtherInstanceIfUp(String ... args) {
        boolean bl;
        Socket other = this.getOtherInstance();
        if (other == null) {
            return false;
        }
        try {
            BufferedReader in = new BufferedReader(new InputStreamReader(other.getInputStream()));
            boolean isRM = this.readHelloMessage(in);
            if (!isRM) {
                boolean bl2 = false;
                return bl2;
            }
            LOGGER.config("Sending arguments to other RapidMiner instance: " + Arrays.toString(args));
            Document doc = DocumentBuilderFactory.newInstance().newDocumentBuilder().newDocument();
            Element root = doc.createElement("args");
            doc.appendChild(root);
            for (String arg : args) {
                Element argElem = doc.createElement("arg");
                argElem.setTextContent(arg);
                root.appendChild(argElem);
            }
            XMLTools.stream(doc, other.getOutputStream(), null);
            boolean bl3 = true;
            return bl3;
        }
        catch (IOException e) {
            LOGGER.log(Level.WARNING, "Failed to talk to other instance: " + e, e);
            bl = false;
            return bl;
        }
        catch (ParserConfigurationException e) {
            LOGGER.log(Level.WARNING, "Cannot create XML document: " + e, e);
            bl = false;
            return bl;
        }
        catch (XMLException e) {
            LOGGER.log(Level.WARNING, "Cannot create XML document: " + e, e);
            bl = false;
            return bl;
        }
        finally {
            try {
                other.close();
            }
            catch (IOException e) {
                LOGGER.log(Level.WARNING, "Failed to close socket: " + e, e);
            }
        }
    }

    public static boolean defaultLaunchWithArguments(String[] args, RemoteControlHandler handler) throws IOException {
        ParameterService.init();
        if (!LaunchListener.getInstance().sendToOtherInstanceIfUp(args)) {
            LaunchListener.getInstance().installListener(handler);
            return true;
        }
        return false;
    }

    public static interface RemoteControlHandler {
        public boolean handleArguments(String[] var1);
    }
}

