/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.tools;

import com.rapidminer.tools.ExtensibleResourceBundle;
import com.rapidminer.tools.LogService;
import java.text.MessageFormat;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;

public class I18N {
    private static final ExtensibleResourceBundle USER_ERROR_BUNDLE = new ExtensibleResourceBundle(ResourceBundle.getBundle("com.rapidminer.resources.i18n.UserErrorMessages", Locale.getDefault(), I18N.class.getClassLoader()));
    private static final ExtensibleResourceBundle ERROR_BUNDLE = new ExtensibleResourceBundle(ResourceBundle.getBundle("com.rapidminer.resources.i18n.Errors", Locale.getDefault(), I18N.class.getClassLoader()));
    private static final ExtensibleResourceBundle GUI_BUNDLE = new ExtensibleResourceBundle(ResourceBundle.getBundle("com.rapidminer.resources.i18n.GUI", Locale.getDefault(), I18N.class.getClassLoader()));

    public static ResourceBundle getErrorBundle() {
        return ERROR_BUNDLE;
    }

    public static ResourceBundle getGUIBundle() {
        return GUI_BUNDLE;
    }

    public static ResourceBundle getUserErrorMessagesBundle() {
        return USER_ERROR_BUNDLE;
    }

    public static void registerErrorBundle(ResourceBundle bundle) {
        I18N.registerErrorBundle(bundle, false);
    }

    public static void registerGUIBundle(ResourceBundle bundle) {
        I18N.registerGUIBundle(bundle, false);
    }

    public static void registerUserErrorMessagesBundle(ResourceBundle bundle) {
        I18N.registerUserErrorMessagesBundle(bundle, false);
    }

    public static void registerErrorBundle(ResourceBundle bundle, boolean overwrite) {
        if (!overwrite) {
            ERROR_BUNDLE.addResourceBundle(bundle);
        } else {
            ERROR_BUNDLE.addResourceBundleAndOverwrite(bundle);
        }
    }

    public static void registerGUIBundle(ResourceBundle bundle, boolean overwrite) {
        if (!overwrite) {
            GUI_BUNDLE.addResourceBundle(bundle);
        } else {
            GUI_BUNDLE.addResourceBundleAndOverwrite(bundle);
        }
    }

    public static void registerUserErrorMessagesBundle(ResourceBundle bundle, boolean overwrite) {
        if (!overwrite) {
            USER_ERROR_BUNDLE.addResourceBundle(bundle);
        } else {
            USER_ERROR_BUNDLE.addResourceBundleAndOverwrite(bundle);
        }
    }

    public static String getMessage(ResourceBundle bundle, String key, Object ... arguments) {
        try {
            if (arguments == null || arguments.length == 0) {
                return bundle.getString(key);
            }
            String message = bundle.getString(key);
            if (message != null) {
                return MessageFormat.format(message, arguments);
            }
            return key;
        }
        catch (MissingResourceException e) {
            LogService.getRoot().warning("Missing I18N key: " + key);
            return key;
        }
    }

    public static String getMessageOrNull(ResourceBundle bundle, String key, Object ... arguments) {
        if (bundle.containsKey(key)) {
            return I18N.getMessage(bundle, key, arguments);
        }
        return null;
    }

    public static String getGUILabel(String key, Object ... arguments) {
        String completeKey = "gui.label." + key;
        if (GUI_BUNDLE.containsKey(completeKey)) {
            return I18N.getMessage(GUI_BUNDLE, completeKey, arguments);
        }
        return completeKey;
    }
}

