/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.tools;

import com.rapidminer.gui.tools.SwingTools;
import com.rapidminer.operator.OperatorDescription;
import com.rapidminer.tools.LogService;
import com.rapidminer.tools.documentation.GroupDocumentation;
import com.rapidminer.tools.documentation.OperatorDocBundle;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import javax.swing.ImageIcon;

public class GroupTree
implements Comparable<GroupTree> {
    static final GroupTree ROOT = new GroupTree(null, "", null);
    private static final ImageIcon[] NO_ICONS = new ImageIcon[3];
    private final List<OperatorDescription> operators = new LinkedList<OperatorDescription>();
    private final Map<String, GroupTree> children = new LinkedHashMap<String, GroupTree>();
    private String key = null;
    private GroupTree parent = null;
    private String iconName;
    private ImageIcon[] icons;
    private final GroupDocumentation documentation;

    private GroupTree(GroupTree parent, String key, OperatorDocBundle bundle) {
        this.parent = parent;
        this.key = key;
        if (bundle != null) {
            this.documentation = (GroupDocumentation)bundle.getObject("group." + this.getQName());
        } else {
            LogService.getRoot().fine("No documentation bundle associated with group " + this.getQName());
            this.documentation = new GroupDocumentation(key);
        }
    }

    private GroupTree(GroupTree other) {
        this.key = other.key;
        this.operators.addAll(other.operators);
        this.iconName = other.iconName;
        this.icons = other.icons;
        this.documentation = other.documentation;
        for (GroupTree child : other.getSubGroups()) {
            this.addSubGroup((GroupTree)child.clone());
        }
    }

    public Object clone() {
        return new GroupTree(this);
    }

    public String getName() {
        return this.getDocumentation().getName();
    }

    private GroupDocumentation getDocumentation() {
        return this.documentation;
    }

    public String getMainGroupName() {
        if (this.getParent() == null) {
            return "Root";
        }
        if (this.getParent().getParent() == null) {
            return this.getName();
        }
        return this.getParent().getMainGroupName();
    }

    private void setParent(GroupTree parent) {
        this.parent = parent;
    }

    public GroupTree getParent() {
        return this.parent;
    }

    private void addSubGroup(GroupTree child) {
        this.children.put(child.key, child);
        child.setParent(this);
    }

    public GroupTree getSubGroup(String key) {
        return this.children.get(key);
    }

    public GroupTree getOrCreateSubGroup(String key, OperatorDocBundle bundle) {
        GroupTree child = this.children.get(key);
        if (child == null) {
            child = new GroupTree(this, key, bundle);
            this.addSubGroup(child);
        }
        return child;
    }

    public Collection<GroupTree> getSubGroups() {
        return this.children.values();
    }

    public int getIndexOfSubGroup(GroupTree child) {
        Iterator<GroupTree> i = this.getSubGroups().iterator();
        int index = 0;
        while (i.hasNext()) {
            GroupTree current = i.next();
            if (current.equals(child)) {
                return index;
            }
            ++index;
        }
        return -1;
    }

    public GroupTree getSubGroup(int index) {
        Collection<GroupTree> allChildren = this.getSubGroups();
        if (index >= allChildren.size()) {
            return null;
        }
        Iterator<GroupTree> i = allChildren.iterator();
        int counter = 0;
        while (i.hasNext()) {
            GroupTree current = i.next();
            if (counter == index) {
                return current;
            }
            ++counter;
        }
        return null;
    }

    public void addOperatorDescription(OperatorDescription description) {
        this.operators.add(description);
    }

    public List<OperatorDescription> getOperatorDescriptions() {
        return this.operators;
    }

    public Set<OperatorDescription> getAllOperatorDescriptions() {
        TreeSet<OperatorDescription> result = new TreeSet<OperatorDescription>();
        this.addAllOperatorDescriptions(result);
        return result;
    }

    private void addAllOperatorDescriptions(Set<OperatorDescription> operators) {
        operators.addAll(this.operators);
        for (GroupTree child : this.children.values()) {
            child.addAllOperatorDescriptions(operators);
        }
    }

    public String toString() {
        String result = this.getName();
        if (this.getParent() == null) {
            result = "Root";
        }
        int size = this.countOperators();
        return result + (size > 0 ? " (" + size + ")" : "");
    }

    @Override
    public int compareTo(GroupTree o) {
        return this.getName().compareTo(o.getName());
    }

    public boolean equals(Object o) {
        if (!(o instanceof GroupTree)) {
            return false;
        }
        GroupTree a = (GroupTree)o;
        return this.key.equals(a.key);
    }

    public int hashCode() {
        return this.key.hashCode();
    }

    public String getQName() {
        if (this.parent == null) {
            return this.key;
        }
        String parentKey = this.parent.getQName();
        if (parentKey.length() > 0) {
            return parentKey + "." + this.key;
        }
        return this.key;
    }

    public String getGroupName() {
        String name = this.getName();
        if (this.parent == null) {
            return name;
        }
        String parentName = this.parent.getGroupName();
        if (parentName.length() > 0) {
            return parentName + "." + name;
        }
        return name;
    }

    public static GroupTree findGroup(String qName, OperatorDocBundle bundle) {
        if (qName.isEmpty()) {
            return ROOT;
        }
        return ROOT.findGroup2(qName, bundle);
    }

    private GroupTree findGroup2(String operatorGroup, OperatorDocBundle bundle) {
        String[] splitted = operatorGroup.split("\\.", 2);
        if (splitted.length == 1) {
            return this.getOrCreateSubGroup(splitted[0], bundle);
        }
        return this.getOrCreateSubGroup(splitted[0], bundle).findGroup2(splitted[1], bundle);
    }

    public void setIconName(String icon) {
        this.iconName = icon;
        this.loadIcons();
    }

    public String getIconName() {
        if (this.iconName != null) {
            return this.iconName;
        }
        if (this.parent != null) {
            return this.parent.getIconName();
        }
        return null;
    }

    private void loadIcons() {
        if (this.iconName == null) {
            this.icons = null;
            return;
        }
        this.icons = new ImageIcon[3];
        this.icons[0] = SwingTools.createIcon("16/" + this.iconName);
        this.icons[1] = SwingTools.createIcon("24/" + this.iconName);
        this.icons[2] = SwingTools.createIcon("48/" + this.iconName);
    }

    public ImageIcon[] getIcons() {
        if (this.icons != null) {
            return this.icons;
        }
        if (this.parent != null) {
            return this.parent.getIcons();
        }
        return NO_ICONS;
    }

    public String getDescription() {
        return this.documentation.getHelp();
    }

    public String getKey() {
        return this.key;
    }

    private int countOperators() {
        int count = this.operators.size();
        for (GroupTree tree : this.children.values()) {
            count += tree.countOperators();
        }
        return count;
    }

    public void sort(Comparator<OperatorDescription> comparator) {
        Collections.sort(this.operators, comparator);
        for (GroupTree child : this.children.values()) {
            child.sort(comparator);
        }
    }
}

