/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.tools;

import com.rapidminer.gui.tools.PasswordDialog;
import com.rapidminer.tools.LogService;
import com.rapidminer.tools.Tools;
import java.net.Authenticator;
import java.net.PasswordAuthentication;
import java.net.URL;
import java.util.LinkedList;
import java.util.List;

public class GlobalAuthenticator
extends Authenticator {
    private final List<URLAuthenticator> registeredAuthenticators = new LinkedList<URLAuthenticator>();
    private static final GlobalAuthenticator THE_INSTANCE = new GlobalAuthenticator();

    public static synchronized void register(URLAuthenticator authenticator) {
        GlobalAuthenticator.THE_INSTANCE.registeredAuthenticators.add(authenticator);
    }

    @Override
    protected synchronized PasswordAuthentication getPasswordAuthentication() {
        URL url = this.getRequestingURL();
        LogService.getRoot().info("Authentication requested for: " + url + ". Trying these authenticators: " + this.registeredAuthenticators + ".");
        for (URLAuthenticator a : this.registeredAuthenticators) {
            PasswordAuthentication auth = a.getAuthentication(url);
            if (auth == null) continue;
            return auth;
        }
        if ("http".equals(url.getProtocol())) {
            if (Tools.booleanValue(System.getProperty("http.proxySet"), false)) {
                String username = System.getProperty("http.proxyUsername");
                String password = System.getProperty("http.proxyPassword");
                if (username != null && username.length() > 0 && password != null && password.length() > 0) {
                    LogService.getRoot().info("Authentication requested for unknown URL, trying proxy authentication: " + url);
                    return new ProxyAuthenticator(username, password).getPasswordAuthentication();
                }
                LogService.getRoot().info("Authentication requested for unknown URL: " + url);
                return PasswordDialog.getPasswordAuthentication(url.toString(), false, false);
            }
            LogService.getRoot().info("Authentication requested for unknown URL: " + url);
            return PasswordDialog.getPasswordAuthentication(url.toString(), false, false);
        }
        LogService.getRoot().info("Authentication requested for unknown URL: " + url);
        return PasswordDialog.getPasswordAuthentication(url.toString(), false, false);
    }

    public static void init() {
    }

    static {
        Authenticator.setDefault(THE_INSTANCE);
    }

    private static class ProxyAuthenticator
    extends Authenticator {
        private String username;
        private String password;

        public ProxyAuthenticator(String username, String password) {
            this.username = username;
            this.password = password;
        }

        @Override
        protected PasswordAuthentication getPasswordAuthentication() {
            return new PasswordAuthentication(this.username, this.password.toCharArray());
        }
    }

    public static interface URLAuthenticator {
        public PasswordAuthentication getAuthentication(URL var1);

        public String getName();
    }
}

