/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.tools;

import java.util.Stack;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;

public class GlobCompiler {
    public static Pattern compileGlob(String glob) throws PatternSyntaxException {
        Stack<Commands> currentMode = new Stack<Commands>();
        currentMode.push(Commands.UNBRACED);
        int globLength = glob.length();
        int currentIndex = 0;
        StringBuffer buffer = new StringBuffer();
        while (currentIndex < globLength) {
            char c;
            if ((c = glob.charAt(currentIndex++)) == '\\') {
                if (currentIndex == globLength) {
                    buffer.append(Pattern.quote("\\"));
                    continue;
                }
                String s = glob.charAt(currentIndex) + "";
                if (Commands.UNBRACED == currentMode.peek() && "\\[]{}?*".contains(s) || Commands.SQUARE_BRACKETS == currentMode.peek() && "\\[]{}?*!-".contains(s) || Commands.CURLY_BRACKETS == currentMode.peek() && "\\[]{}?*,".contains(s)) {
                    ++currentIndex;
                    buffer.append(Pattern.quote(s));
                    continue;
                }
                buffer.append(Pattern.quote("\\"));
                continue;
            }
            if (c == '*') {
                buffer.append(".*");
                continue;
            }
            if (c == '?') {
                buffer.append('.');
                continue;
            }
            if (c == '[') {
                buffer.append('[');
                currentMode.push(Commands.SQUARE_BRACKETS);
                if (currentIndex >= globLength || glob.charAt(currentIndex) != '!') continue;
                ++currentIndex;
                buffer.append('^');
                continue;
            }
            if (c == ']' && Commands.SQUARE_BRACKETS == currentMode.peek()) {
                buffer.append(']');
                currentMode.pop();
                continue;
            }
            if (c == '-' && Commands.SQUARE_BRACKETS == currentMode.peek()) {
                buffer.append('-');
                continue;
            }
            if (c == '{') {
                buffer.append("(?:(?:");
                currentMode.push(Commands.CURLY_BRACKETS);
                continue;
            }
            if (c == '}' && Commands.CURLY_BRACKETS == currentMode.peek()) {
                buffer.append("))");
                currentMode.pop();
                continue;
            }
            if (c == ',' && Commands.CURLY_BRACKETS == currentMode.peek()) {
                buffer.append(")|(?:");
                continue;
            }
            buffer.append(Pattern.quote(c + ""));
        }
        if ("[]".equals(currentMode.peek())) {
            throw new PatternSyntaxException("Cannot find matching closing square bracket ] in GLOB expression", glob, -1);
        }
        if ("{}".equals(currentMode.peek())) {
            throw new PatternSyntaxException("Cannot find matching closing curly brace } in GLOB expression", glob, -1);
        }
        return Pattern.compile(buffer.toString());
    }

    private static enum Commands {
        UNBRACED,
        SQUARE_BRACKETS,
        CURLY_BRACKETS;

    }
}

