/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.tools;

import java.util.Enumeration;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ResourceBundle;

public class ExtensibleResourceBundle
extends ResourceBundle {
    private List<ResourceBundle> bundles = new LinkedList<ResourceBundle>();

    public ExtensibleResourceBundle(ResourceBundle parent) {
        this.bundles.add(parent);
    }

    public void addResourceBundle(ResourceBundle bundle) {
        this.bundles.add(bundle);
    }

    public void addResourceBundleAndOverwrite(ResourceBundle bundle) {
        this.bundles.add(0, bundle);
    }

    @Override
    public Enumeration<String> getKeys() {
        return new KeyEnumeration();
    }

    @Override
    protected Object handleGetObject(String key) {
        for (ResourceBundle bundle : this.bundles) {
            if (!bundle.containsKey(key)) continue;
            return bundle.getObject(key);
        }
        return null;
    }

    private class KeyEnumeration
    implements Enumeration<String> {
        private Iterator<ResourceBundle> bundleIterator;
        private Enumeration<String> keyIterator;

        private KeyEnumeration() {
            this.bundleIterator = ExtensibleResourceBundle.this.bundles.iterator();
        }

        @Override
        public boolean hasMoreElements() {
            if (this.keyIterator == null || !this.keyIterator.hasMoreElements()) {
                while (this.bundleIterator.hasNext() && (this.keyIterator == null || !this.keyIterator.hasMoreElements())) {
                    this.keyIterator = this.bundleIterator.next().getKeys();
                }
            }
            return this.keyIterator != null && this.keyIterator.hasMoreElements();
        }

        @Override
        public String nextElement() {
            if (this.keyIterator == null) {
                this.keyIterator = this.bundleIterator.next().getKeys();
            }
            while (!this.keyIterator.hasMoreElements()) {
                this.keyIterator = this.bundleIterator.next().getKeys();
            }
            return this.keyIterator.nextElement();
        }
    }
}

