/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.tools;

import com.rapidminer.tools.LogService;
import com.rapidminer.tools.MailSessionFactory;
import java.util.Properties;
import javax.mail.Authenticator;
import javax.mail.PasswordAuthentication;
import javax.mail.Session;

public class DefaultMailSessionFactory
implements MailSessionFactory {
    @Override
    public Session makeSession() {
        String port;
        String host = System.getProperty("rapidminer.tools.smtp.host");
        if (host == null) {
            LogService.getRoot().warning("Must specify SMTP host in rapidminer.tools.smtp.host to use SMTP.");
            return null;
        }
        Properties props = new Properties();
        props.put("mail.smtp.host", host);
        props.put("mail.from", "no-reply@rapidminer.com");
        final String user = System.getProperty("rapidminer.tools.smtp.user");
        props.put("mail.user", user);
        final String passwd = System.getProperty("rapidminer.tools.smtp.passwd");
        Authenticator authenticator = null;
        if (passwd != null && passwd.length() > 0) {
            props.setProperty("mail.smtp.submitter", user);
            props.setProperty("mail.smtp.auth", "true");
            authenticator = new Authenticator(){

                protected PasswordAuthentication getPasswordAuthentication() {
                    return new PasswordAuthentication(user, passwd);
                }
            };
        }
        if ((port = System.getProperty("rapidminer.tools.smtp.port")) != null) {
            props.setProperty("mail.smtp.port", port);
        }
        return Session.getInstance((Properties)props, authenticator);
    }
}

