/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.tools;

import com.rapidminer.operator.UserError;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;

public class ClassNameMapper {
    Map<String, String> classMap = new LinkedHashMap<String, String>();

    public ClassNameMapper(String[] classNames) {
        for (int i = 0; i < classNames.length; ++i) {
            String completeClassName;
            String simpleClassName = completeClassName = classNames[i];
            int index = completeClassName.lastIndexOf(46);
            if (index > -1) {
                simpleClassName = completeClassName.substring(index + 1);
            }
            if (this.classMap.get(simpleClassName) == null) {
                this.classMap.put(simpleClassName, completeClassName);
                continue;
            }
            this.classMap.put(completeClassName, completeClassName);
        }
    }

    public String getCompleteClassName(String shortName) {
        return this.classMap.get(shortName);
    }

    public Class getClassByShortName(String shortName) throws UserError {
        String completeClassName = this.getCompleteClassName(shortName);
        if (completeClassName == null) {
            completeClassName = shortName;
        }
        if (completeClassName == null) {
            throw new UserError(null, 904, shortName, "No such class.");
        }
        try {
            return Class.forName(completeClassName);
        }
        catch (ClassNotFoundException e) {
            throw new UserError(null, 904, shortName, e.getMessage());
        }
    }

    public String[] getShortClassNames() {
        String[] result = new String[this.classMap.size()];
        Iterator<String> it = this.classMap.keySet().iterator();
        for (int i = 0; i < this.classMap.size(); ++i) {
            result[i] = it.next();
        }
        return result;
    }

    public Object getInstantiation(String shortName) throws UserError {
        Object result = null;
        try {
            result = this.getClassByShortName(shortName).newInstance();
            if (result == null) {
                throw new UserError(null, 904, shortName, "No such class");
            }
        }
        catch (InstantiationException e) {
            throw new UserError(null, 904, shortName, e.getMessage());
        }
        catch (IllegalAccessException e) {
            throw new UserError(null, 904, shortName, e.getMessage());
        }
        return result;
    }
}

