/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.tools;

import com.rapidminer.gui.templates.BuildingBlock;
import com.rapidminer.tools.LogService;
import com.rapidminer.tools.ParameterService;
import com.rapidminer.tools.Tools;
import com.rapidminer.tools.plugin.Plugin;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileFilter;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.logging.Level;

public class BuildingBlockService {
    private static final String RESOURCE_BUILDINGBLOCK_FOLDER = "/com/rapidminer/resources/buildingblocks/";
    private static final String RESOURCE_BUILDINGBLOCK_LIST = "/com/rapidminer/resources/buildingblocks/buildingblocks.txt";

    public static List<BuildingBlock> getBuildingBlocks() {
        List<BuildingBlock> buildingBlocks = BuildingBlockService.getPredefinedBuildingBlocks();
        buildingBlocks.addAll(BuildingBlockService.getPluginBuildingBlocks());
        buildingBlocks.addAll(BuildingBlockService.getUserBuildingBlocks());
        Collections.sort(buildingBlocks);
        return buildingBlocks;
    }

    public static List<BuildingBlock> getUserBuildingBlocks() {
        File[] userDefinedBuildingBlockFiles = ParameterService.getUserRapidMinerDir().listFiles(new FileFilter(){

            @Override
            public boolean accept(File file) {
                return file.getName().endsWith(".buildingblock");
            }
        });
        LinkedList<BuildingBlock> buildingBlocks = new LinkedList<BuildingBlock>();
        for (File file : userDefinedBuildingBlockFiles) {
            try {
                buildingBlocks.add(new BuildingBlock(file, 2));
            }
            catch (InstantiationException e) {
                LogService.getRoot().log(Level.WARNING, "Cannot load building block file '" + file + "': " + e.getMessage(), e);
            }
        }
        return buildingBlocks;
    }

    public static List<BuildingBlock> getPredefinedBuildingBlocks() {
        InputStream bbListIn = BuildingBlockService.class.getResourceAsStream(RESOURCE_BUILDINGBLOCK_LIST);
        if (bbListIn == null) {
            LogService.getRoot().warning("Resource /com/rapidminer/resources/buildingblocks/buildingblocks.txt missing");
            return Collections.emptyList();
        }
        String[] files = null;
        try {
            files = Tools.readTextFile(new InputStreamReader(bbListIn, "UTF-8")).split("[\\r\\n]+");
        }
        catch (Exception e1) {
            LogService.getRoot().log(Level.WARNING, "Cannot read resource /com/rapidminer/resources/buildingblocks/buildingblocks.txt: " + e1, e1);
            return Collections.emptyList();
        }
        LinkedList<BuildingBlock> buildingBlocks = new LinkedList<BuildingBlock>();
        for (String resourceName : files) {
            if (resourceName == null || resourceName.isEmpty()) continue;
            try {
                InputStream in = BuildingBlockService.class.getResourceAsStream(RESOURCE_BUILDINGBLOCK_FOLDER + resourceName);
                buildingBlocks.add(new BuildingBlock(new BufferedReader(new InputStreamReader(in, "UTF-8")), 1));
            }
            catch (Exception e) {
                LogService.getRoot().log(Level.WARNING, "Cannot load building block file '" + resourceName + "': " + e.getMessage(), e);
            }
        }
        return buildingBlocks;
    }

    public static List<BuildingBlock> getPluginBuildingBlocks() {
        LinkedList<BuildingBlock> buildingBlocks = new LinkedList<BuildingBlock>();
        Iterator<Plugin> p = Plugin.getAllPlugins().iterator();
        while (p.hasNext()) {
            buildingBlocks.addAll(p.next().getBuildingBlocks());
        }
        return buildingBlocks;
    }
}

