/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.tools;

import com.rapidminer.Process;
import com.rapidminer.tools.Tools;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.util.Date;
import java.util.Enumeration;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;

public class BugReport {
    private static final int BUFFER_SIZE = 1024;

    private static void getProperties(String prefix, StringBuffer string) {
        string.append(prefix + " properties:" + Tools.getLineSeparator());
        Enumeration<?> keys = System.getProperties().propertyNames();
        while (keys.hasMoreElements()) {
            String key = (String)keys.nextElement();
            if (!key.startsWith(prefix)) continue;
            string.append("  " + key + "\t= " + System.getProperty(key) + Tools.getLineSeparator());
        }
    }

    public static String getProperties() {
        StringBuffer string = new StringBuffer();
        string.append("System properties:" + Tools.getLineSeparator());
        string.append("------------------" + Tools.getLineSeparator() + Tools.getLineSeparator());
        BugReport.getProperties("os", string);
        BugReport.getProperties("java", string);
        BugReport.getProperties("rapidminer", string);
        return string.toString();
    }

    public static String getStackTrace(Throwable throwable) {
        StringBuffer string = new StringBuffer();
        string.append("Stack trace:" + Tools.getLineSeparator());
        string.append("------------" + Tools.getLineSeparator() + Tools.getLineSeparator());
        while (throwable != null) {
            string.append("Exception:\t" + throwable.getClass().getName() + Tools.getLineSeparator());
            string.append("Message:\t" + throwable.getMessage() + Tools.getLineSeparator());
            string.append("Stack trace:" + Tools.getLineSeparator());
            StackTraceElement[] ste = throwable.getStackTrace();
            for (int i = 0; i < ste.length; ++i) {
                string.append("  " + ste[i] + Tools.getLineSeparator());
            }
            string.append(Tools.getLineSeparator());
            if ((throwable = throwable.getCause()) == null) continue;
            string.append("");
            string.append("Cause:");
        }
        return string.toString();
    }

    public static void createBugReport(File reportFile, Throwable exception, String userMessage, Process process, String logMessage, File[] attachments) throws IOException {
        ZipOutputStream zipOut = new ZipOutputStream(new FileOutputStream(reportFile));
        zipOut.setComment("RapidMiner bug report - generated " + new Date());
        BugReport.write("message.txt", "User message", userMessage, zipOut);
        BugReport.write("_process.xml", "Process as in memory.", process.getRootOperator().getXML(false), zipOut);
        if (process.getProcessLocation() != null) {
            try {
                String contents = process.getProcessLocation().getRawXML();
                BugReport.write(process.getProcessLocation().getShortName(), "Raw process file in repository.", contents, zipOut);
            }
            catch (Throwable t) {
                BugReport.write(process.getProcessLocation().getShortName(), "Raw process file in repository.", "could not read: " + t, zipOut);
            }
        }
        BugReport.write("_log.txt", "Log message", logMessage, zipOut);
        BugReport.write("_properties.txt", "System properties, information about java version and operating system", BugReport.getProperties(), zipOut);
        BugReport.write("_exception.txt", "Exception stack trace", BugReport.getStackTrace(exception), zipOut);
        for (int i = 0; i < attachments.length; ++i) {
            BugReport.writeFile(attachments[i], zipOut);
        }
        zipOut.close();
    }

    private static void writeFile(File file, ZipOutputStream out) throws IOException {
        FileInputStream in = null;
        try {
            in = new FileInputStream(file);
            out.putNextEntry(new ZipEntry(file.getName()));
            byte[] buffer = new byte[1024];
            int read = -1;
            do {
                if ((read = ((InputStream)in).read(buffer)) <= -1) continue;
                out.write(buffer, 0, read);
            } while (read > -1);
            out.closeEntry();
        }
        catch (IOException e) {
            throw e;
        }
        finally {
            if (in != null) {
                ((InputStream)in).close();
            }
        }
    }

    private static void write(String name, String comment, String string, ZipOutputStream out) throws IOException {
        ZipEntry entry = new ZipEntry(name);
        entry.setComment(comment);
        out.putNextEntry(entry);
        PrintStream print = new PrintStream(out);
        print.println(string);
        print.flush();
        out.closeEntry();
    }
}

