/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.tools;

import com.rapidminer.tools.Observable;
import com.rapidminer.tools.Observer;
import java.util.LinkedList;
import java.util.List;
import java.util.NoSuchElementException;
import javax.swing.SwingUtilities;

public class AbstractObservable<A>
implements Observable<A> {
    private final LinkedList<Observer<A>> observersRegular = new LinkedList();
    private final LinkedList<Observer<A>> observersEDT = new LinkedList();
    private final Object lock = new Object();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addObserverAsFirst(Observer<A> observer, boolean onEDT) {
        if (observer == null) {
            throw new NullPointerException("Observer is null.");
        }
        if (onEDT) {
            Object object = this.lock;
            synchronized (object) {
                this.observersEDT.addFirst(observer);
            }
        }
        Object object = this.lock;
        synchronized (object) {
            this.observersRegular.addFirst(observer);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addObserver(Observer<A> observer, boolean onEDT) {
        if (observer == null) {
            throw new NullPointerException("Observer is null.");
        }
        if (onEDT) {
            Object object = this.lock;
            synchronized (object) {
                this.observersEDT.add(observer);
            }
        }
        Object object = this.lock;
        synchronized (object) {
            this.observersRegular.add(observer);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeObserver(Observer<A> observer) {
        boolean success = false;
        Object object = this.lock;
        synchronized (object) {
            success |= this.observersRegular.remove(observer);
        }
        if (!(success |= this.observersEDT.remove(observer))) {
            throw new NoSuchElementException("No such observer: " + observer);
        }
    }

    private void fireUpdate(List<Observer<A>> observerList, A argument) {
        for (Observer<A> observer : observerList) {
            observer.update(this, argument);
        }
    }

    protected void fireUpdate() {
        this.fireUpdate(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void fireUpdate(final A argument) {
        LinkedList<Observer<A>> copy;
        Object object = this.lock;
        synchronized (object) {
            copy = new LinkedList<Observer<A>>(this.observersRegular);
        }
        this.fireUpdate(copy, argument);
        if (!this.observersEDT.isEmpty()) {
            LinkedList<Observer<A>> copyEDT;
            Object object2 = this.lock;
            synchronized (object2) {
                copyEDT = new LinkedList<Observer<A>>(this.observersEDT);
            }
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    AbstractObservable.this.fireUpdate(copyEDT, argument);
                }
            });
        }
    }
}

