/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.repository.resource;

import com.rapidminer.repository.Entry;
import com.rapidminer.repository.Folder;
import com.rapidminer.repository.MalformedRepositoryLocationException;
import com.rapidminer.repository.Repository;
import com.rapidminer.repository.RepositoryException;
import com.rapidminer.repository.RepositoryListener;
import com.rapidminer.repository.RepositoryLocation;
import com.rapidminer.repository.RepositoryManager;
import com.rapidminer.repository.gui.RepositoryConfigurationPanel;
import com.rapidminer.repository.resource.ResourceFolder;
import javax.help.UnsupportedOperationException;
import javax.swing.event.EventListenerList;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class ResourceRepository
extends ResourceFolder
implements Repository {
    private final EventListenerList listeners = new EventListenerList();
    private String resourcePrefix;

    public ResourceRepository(String name, String resourcePrefix) {
        super(null, name, "", null);
        this.resourcePrefix = resourcePrefix;
        this.setRepository(this);
    }

    protected String getResourceRooot() {
        return this.resourcePrefix;
    }

    @Override
    public void addRepositoryListener(RepositoryListener l) {
        this.listeners.add(RepositoryListener.class, l);
    }

    @Override
    public void removeRepositoryListener(RepositoryListener l) {
        this.listeners.remove(RepositoryListener.class, l);
    }

    protected void fireRefreshed(Folder folder) {
        for (RepositoryListener l : (RepositoryListener[])this.listeners.getListeners(RepositoryListener.class)) {
            l.folderRefreshed(folder);
        }
    }

    @Override
    public Element createXML(Document doc) {
        return null;
    }

    @Override
    public String getState() {
        return null;
    }

    @Override
    public RepositoryLocation getLocation() {
        try {
            return new RepositoryLocation(this.getName(), new String[0]);
        }
        catch (MalformedRepositoryLocationException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public Entry locate(String entry) throws RepositoryException {
        return RepositoryManager.getInstance(null).locate(this, entry, false);
    }

    @Override
    public boolean shouldSave() {
        return false;
    }

    @Override
    public void postInstall() {
    }

    @Override
    public void preRemove() {
    }

    @Override
    public boolean isConfigurable() {
        return false;
    }

    @Override
    public RepositoryConfigurationPanel makeConfigurationPanel() {
        throw new UnsupportedOperationException("Resource repository cannot be configured.");
    }
}

