/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.repository.resource;

import com.rapidminer.repository.ProcessEntry;
import com.rapidminer.repository.RepositoryException;
import com.rapidminer.repository.resource.ResourceDataEntry;
import com.rapidminer.repository.resource.ResourceFolder;
import com.rapidminer.repository.resource.ResourceRepository;
import com.rapidminer.tools.Tools;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;

public class ResourceProcessEntry
extends ResourceDataEntry
implements ProcessEntry {
    protected ResourceProcessEntry(ResourceFolder parent, String name, String resource, ResourceRepository repository) {
        super(parent, name, resource, repository);
    }

    @Override
    public String retrieveXML() throws RepositoryException {
        InputStream in = ResourceProcessEntry.class.getResourceAsStream(this.getResource() + ".rmp");
        if (in == null) {
            throw new RepositoryException("Missing resource: " + this.getResource() + ".rmp");
        }
        try {
            String string = Tools.readTextFile(new InputStreamReader(in));
            return string;
        }
        catch (IOException e) {
            throw new RepositoryException("IO error reading " + this.getResource() + ": " + e.getMessage());
        }
        finally {
            try {
                in.close();
            }
            catch (IOException e) {}
        }
    }

    @Override
    public void storeXML(String xml) throws RepositoryException {
        throw new RepositoryException("Repository is read only.");
    }

    @Override
    public String getDescription() {
        return null;
    }

    @Override
    public String getType() {
        return "process";
    }
}

