/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.repository.resource;

import com.rapidminer.operator.IOObject;
import com.rapidminer.operator.Operator;
import com.rapidminer.operator.ports.metadata.AttributeMetaData;
import com.rapidminer.operator.ports.metadata.ExampleSetMetaData;
import com.rapidminer.operator.ports.metadata.MetaData;
import com.rapidminer.operator.tools.IOObjectSerializer;
import com.rapidminer.repository.IOObjectEntry;
import com.rapidminer.repository.RepositoryException;
import com.rapidminer.repository.resource.ResourceDataEntry;
import com.rapidminer.repository.resource.ResourceFolder;
import com.rapidminer.repository.resource.ResourceRepository;
import com.rapidminer.tools.ProgressListener;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;

public class ResourceIOObjectEntry
extends ResourceDataEntry
implements IOObjectEntry {
    private MetaData metaData;

    protected ResourceIOObjectEntry(ResourceFolder parent, String name, String resource, ResourceRepository repository) {
        super(parent, name, resource, repository);
    }

    @Override
    public String getDescription() {
        return null;
    }

    @Override
    public String getType() {
        return "data";
    }

    @Override
    public IOObject retrieveData(ProgressListener l) throws RepositoryException {
        InputStream in;
        if (l != null) {
            l.setTotal(100);
            l.setCompleted(10);
        }
        if ((in = ResourceIOObjectEntry.class.getResourceAsStream(this.getResource() + ".ioo")) != null) {
            try {
                return (IOObject)IOObjectSerializer.getInstance().deserialize(in);
            }
            catch (Exception e) {
                throw new RepositoryException("Cannot load data from '" + this.getResource() + ".ioo': " + e, e);
            }
        }
        throw new RepositoryException("Resource '" + this.getResource() + ".ioo does not exist'.");
    }

    @Override
    public MetaData retrieveMetaData() throws RepositoryException {
        if (this.metaData == null) {
            String mdResource = this.getResource() + ".md";
            InputStream in = ResourceIOObjectEntry.class.getResourceAsStream(mdResource);
            if (in != null) {
                ObjectInputStream objectIn = null;
                try {
                    objectIn = new ObjectInputStream(in);
                    this.metaData = (MetaData)objectIn.readObject();
                    if (this.metaData instanceof ExampleSetMetaData) {
                        for (AttributeMetaData amd : ((ExampleSetMetaData)this.metaData).getAllAttributes()) {
                            if (!amd.isNominal()) continue;
                            amd.shrinkValueSet();
                        }
                    }
                    objectIn.close();
                }
                catch (Exception e) {
                    throw new RepositoryException("Cannot load meta data from '" + mdResource + "': " + e, e);
                }
                finally {
                    if (objectIn != null) {
                        try {
                            objectIn.close();
                        }
                        catch (IOException e) {}
                    }
                }
            }
            throw new RepositoryException("Meta data resource '" + mdResource + " does not exist'.");
        }
        return this.metaData;
    }

    @Override
    public void storeData(IOObject data, Operator callingOperator, ProgressListener l) throws RepositoryException {
        throw new RepositoryException("Repository is read only.");
    }

    @Override
    public boolean willBlock() {
        return this.metaData == null;
    }

    @Override
    public Class<? extends IOObject> getObjectClass() {
        try {
            return this.retrieveMetaData().getObjectClass();
        }
        catch (RepositoryException e) {
            return null;
        }
    }
}

