/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.repository.resource;

import com.rapidminer.operator.IOObject;
import com.rapidminer.operator.Operator;
import com.rapidminer.repository.BlobEntry;
import com.rapidminer.repository.DataEntry;
import com.rapidminer.repository.Folder;
import com.rapidminer.repository.IOObjectEntry;
import com.rapidminer.repository.ProcessEntry;
import com.rapidminer.repository.RepositoryException;
import com.rapidminer.repository.resource.ResourceEntry;
import com.rapidminer.repository.resource.ResourceIOObjectEntry;
import com.rapidminer.repository.resource.ResourceProcessEntry;
import com.rapidminer.repository.resource.ResourceRepository;
import com.rapidminer.tools.ProgressListener;
import com.rapidminer.tools.Tools;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.LinkedList;
import java.util.List;

public class ResourceFolder
extends ResourceEntry
implements Folder {
    private List<Folder> folders;
    private List<DataEntry> data;

    protected ResourceFolder(ResourceFolder parent, String name, String resource, ResourceRepository repository) {
        super(parent, name, resource, repository);
    }

    @Override
    public boolean containsEntry(String name) throws RepositoryException {
        this.ensureLoaded();
        for (DataEntry dataEntry : this.data) {
            if (!dataEntry.getName().equals(name)) continue;
            return true;
        }
        for (Folder folder : this.folders) {
            if (!folder.getName().equals(name)) continue;
            return true;
        }
        return false;
    }

    @Override
    public BlobEntry createBlobEntry(String name) throws RepositoryException {
        throw new RepositoryException("Repository is read only.");
    }

    @Override
    public Folder createFolder(String name) throws RepositoryException {
        throw new RepositoryException("Repository is read only.");
    }

    @Override
    public IOObjectEntry createIOObjectEntry(String name, IOObject ioobject, Operator callingOperator, ProgressListener newParam) throws RepositoryException {
        throw new RepositoryException("Repository is read only.");
    }

    @Override
    public ProcessEntry createProcessEntry(String name, String processXML) throws RepositoryException {
        throw new RepositoryException("Repository is read only.");
    }

    @Override
    public List<DataEntry> getDataEntries() throws RepositoryException {
        this.ensureLoaded();
        return this.data;
    }

    private void ensureLoaded() throws RepositoryException {
        if (this.folders != null && this.data != null) {
            return;
        }
        InputStream in = ResourceFolder.class.getResourceAsStream(this.getResource() + "/CONTENTS");
        if (in == null) {
            throw new RepositoryException("Cannot find contents of folder " + this.getResource());
        }
        this.folders = new LinkedList<Folder>();
        this.data = new LinkedList<DataEntry>();
        try {
            String[] lines;
            for (String line : lines = Tools.readTextFile(new InputStreamReader(in, "UTF-8")).split("\n")) {
                String name;
                if ((line = line.trim()).isEmpty()) continue;
                int space = line.indexOf(" ");
                String string = name = space != -1 ? line.substring(space + 1).trim() : null;
                if (line.startsWith("FOLDER ")) {
                    this.folders.add(new ResourceFolder(this, name, this.getPath() + "/" + name, this.getRepository()));
                    continue;
                }
                if (line.startsWith("ENTRY")) {
                    String nameWOExt = name.substring(0, name.length() - 4);
                    if (name.endsWith(".rmp")) {
                        this.data.add(new ResourceProcessEntry(this, nameWOExt, this.getPath() + "/" + nameWOExt, this.getRepository()));
                        continue;
                    }
                    if (name.endsWith(".ioo")) {
                        this.data.add(new ResourceIOObjectEntry(this, nameWOExt, this.getPath() + "/" + nameWOExt, this.getRepository()));
                        continue;
                    }
                    throw new RepositoryException("Unknown entry type infolder '" + this.getName() + "': " + name);
                }
                throw new RepositoryException("Illegal entry type in folder '" + this.getName() + "': " + line);
            }
        }
        catch (Exception e) {
            throw new RepositoryException("Error reading contents of folder " + this.getName() + ": " + e, e);
        }
        finally {
            try {
                in.close();
            }
            catch (IOException e) {}
        }
    }

    @Override
    public List<Folder> getSubfolders() throws RepositoryException {
        this.ensureLoaded();
        return this.folders;
    }

    @Override
    public void refresh() throws RepositoryException {
        this.folders = null;
        this.data = null;
        this.getRepository().fireRefreshed(this);
    }

    @Override
    public String getDescription() {
        return this.getResource();
    }

    @Override
    public String getType() {
        return "folder";
    }
}

