/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.repository.resource;

import com.rapidminer.repository.Entry;
import com.rapidminer.repository.Folder;
import com.rapidminer.repository.MalformedRepositoryLocationException;
import com.rapidminer.repository.RepositoryException;
import com.rapidminer.repository.RepositoryLocation;
import com.rapidminer.repository.resource.ResourceFolder;
import com.rapidminer.repository.resource.ResourceRepository;
import java.util.Collection;
import javax.swing.Action;

public abstract class ResourceEntry
implements Entry {
    private ResourceFolder container;
    private String name;
    private String path;
    private ResourceRepository repository;

    protected ResourceEntry(ResourceFolder parent, String name, String path, ResourceRepository repository) {
        this.container = parent;
        this.name = name;
        this.path = path;
        this.repository = repository;
    }

    @Override
    public void delete() throws RepositoryException {
        throw new RepositoryException("Repository is read only.");
    }

    @Override
    public Folder getContainingFolder() {
        return this.container;
    }

    @Override
    public RepositoryLocation getLocation() {
        try {
            return new RepositoryLocation(this.getRepository().getLocation().toString() + this.getPath());
        }
        catch (MalformedRepositoryLocationException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getOwner() {
        return "none";
    }

    @Override
    public boolean isReadOnly() {
        return true;
    }

    @Override
    public boolean move(Folder newParent) throws RepositoryException {
        throw new RepositoryException("Repository is read only.");
    }

    @Override
    public boolean rename(String newName) throws RepositoryException {
        throw new RepositoryException("Repository is read only.");
    }

    @Override
    public boolean willBlock() {
        return false;
    }

    protected String getResource() {
        return this.getRepository().getResourceRooot() + this.getPath();
    }

    protected String getPath() {
        return this.path;
    }

    protected ResourceRepository getRepository() {
        return this.repository;
    }

    protected void setRepository(ResourceRepository resourceRepository) {
        this.repository = resourceRepository;
    }

    @Override
    public Collection<Action> getCustomActions() {
        return null;
    }
}

