/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.repository.remote;

import com.rapid_i.repository.wsimport.EntryResponse;
import com.rapid_i.repository.wsimport.ProcessService;
import com.rapid_i.repository.wsimport.ProcessService_Service;
import com.rapid_i.repository.wsimport.RepositoryService;
import com.rapid_i.repository.wsimport.RepositoryService_Service;
import com.rapidminer.gui.actions.BrowseAction;
import com.rapidminer.gui.tools.PasswordDialog;
import com.rapidminer.gui.tools.SwingTools;
import com.rapidminer.io.process.XMLTools;
import com.rapidminer.repository.Entry;
import com.rapidminer.repository.Folder;
import com.rapidminer.repository.Repository;
import com.rapidminer.repository.RepositoryException;
import com.rapidminer.repository.RepositoryListener;
import com.rapidminer.repository.RepositoryManager;
import com.rapidminer.repository.gui.RemoteRepositoryPanel;
import com.rapidminer.repository.gui.RepositoryConfigurationPanel;
import com.rapidminer.repository.remote.RemoteBlobEntry;
import com.rapidminer.repository.remote.RemoteEntry;
import com.rapidminer.repository.remote.RemoteFolder;
import com.rapidminer.repository.remote.RemoteIOObjectEntry;
import com.rapidminer.repository.remote.RemoteProcessEntry;
import com.rapidminer.tools.GlobalAuthenticator;
import com.rapidminer.tools.LogService;
import com.rapidminer.tools.XMLException;
import com.rapidminer.tools.cipher.CipherException;
import com.rapidminer.tools.jdbc.connection.DatabaseConnectionService;
import com.rapidminer.tools.jdbc.connection.FieldConnectionEntry;
import java.awt.Desktop;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.PasswordAuthentication;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLEncoder;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import javax.swing.Action;
import javax.swing.event.EventListenerList;
import javax.xml.namespace.QName;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.SAXException;

public class RemoteRepository
extends RemoteFolder
implements Repository {
    private URL baseUrl;
    private String alias;
    private String username;
    private char[] password;
    private RepositoryService repositoryService;
    private ProcessService processService;
    private final EventListenerList listeners = new EventListenerList();
    private static final Map<URI, WeakReference<RemoteRepository>> ALL_REPOSITORIES = new HashMap<URI, WeakReference<RemoteRepository>>();
    private static final Object MAP_LOCK = new Object();
    private boolean offline = true;
    private boolean isHome;
    private Map<String, RemoteEntry> cachedEntries = new HashMap<String, RemoteEntry>();
    private Collection<FieldConnectionEntry> connectionEntries;
    private boolean cachedPasswordUsed = false;

    public RemoteRepository(URL baseUrl, String alias, String username, char[] password, boolean isHome) {
        super("/");
        this.setRepository(this);
        this.setAlias(alias);
        this.baseUrl = baseUrl;
        this.setUsername(username);
        this.isHome = isHome;
        if (password != null && password.length > 0) {
            this.setPassword(password);
        } else {
            this.setPassword(null);
        }
        RemoteRepository.register(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void register(RemoteRepository remoteRepository) {
        Object object = MAP_LOCK;
        synchronized (object) {
            try {
                ALL_REPOSITORIES.put(remoteRepository.getBaseUrl().toURI(), new WeakReference<RemoteRepository>(remoteRepository));
            }
            catch (URISyntaxException e) {
                LogService.getRoot().log(Level.SEVERE, "Could not add repository URI: " + remoteRepository.getBaseUrl().toExternalForm(), e);
            }
        }
    }

    private URL getRepositoryServiceWSDLUrl() {
        try {
            return new URL(this.getBaseUrl(), "RAWS/RepositoryService?wsdl");
        }
        catch (MalformedURLException e) {
            LogService.getRoot().log(Level.WARNING, "Cannot create Web service url: " + e, e);
            return null;
        }
    }

    private URL getProcessServiceWSDLUrl() {
        try {
            return new URL(this.getBaseUrl(), "RAWS/ProcessService?wsdl");
        }
        catch (MalformedURLException e) {
            LogService.getRoot().log(Level.WARNING, "Cannot create Web service url: " + e, e);
            return null;
        }
    }

    @Override
    public void addRepositoryListener(RepositoryListener l) {
        this.listeners.add(RepositoryListener.class, l);
    }

    @Override
    public void removeRepositoryListener(RepositoryListener l) {
        this.listeners.remove(RepositoryListener.class, l);
    }

    @Override
    public boolean rename(String newName) {
        this.setAlias(newName);
        this.fireEntryRenamed(this);
        return true;
    }

    protected void fireEntryRenamed(Entry entry) {
        for (RepositoryListener l : (RepositoryListener[])this.listeners.getListeners(RepositoryListener.class)) {
            l.entryRenamed(entry);
        }
    }

    protected void fireEntryAdded(Entry newEntry, Folder parent) {
        for (RepositoryListener l : (RepositoryListener[])this.listeners.getListeners(RepositoryListener.class)) {
            l.entryAdded(newEntry, parent);
        }
    }

    protected void fireEntryRemoved(Entry removedEntry, Folder parent, int index) {
        for (RepositoryListener l : (RepositoryListener[])this.listeners.getListeners(RepositoryListener.class)) {
            l.entryRemoved(removedEntry, parent, index);
        }
    }

    protected void fireRefreshed(Folder folder) {
        for (RepositoryListener l : (RepositoryListener[])this.listeners.getListeners(RepositoryListener.class)) {
            l.folderRefreshed(folder);
        }
    }

    protected void register(RemoteEntry entry) {
        this.cachedEntries.put(entry.getPath(), entry);
    }

    @Override
    public Entry locate(String string) throws RepositoryException {
        EntryResponse response;
        Entry cached = this.cachedEntries.get(string);
        if (cached != null) {
            return cached;
        }
        Entry firstTry = RepositoryManager.getInstance(null).locate(this, string, true);
        if (firstTry != null) {
            return firstTry;
        }
        if (!string.startsWith("/")) {
            string = "/" + string;
        }
        if ((response = this.getRepositoryService().getEntry(string)).getStatus() != 0) {
            if (response.getStatus() == -2) {
                return null;
            }
            throw new RepositoryException(response.getErrorMessage());
        }
        if (response.getType().equals("folder")) {
            return new RemoteFolder(response, null, this);
        }
        if (response.getType().equals("process")) {
            return new RemoteProcessEntry(response, null, this);
        }
        if (response.getType().equals("data")) {
            return new RemoteIOObjectEntry(response, null, this);
        }
        if (response.getType().equals("blob")) {
            return new RemoteBlobEntry(response, null, this);
        }
        throw new RepositoryException("Unknown entry type: " + response.getType());
    }

    @Override
    public String getName() {
        return this.getAlias();
    }

    @Override
    public String getState() {
        return this.offline ? "offline" : (this.repositoryService != null ? "connected" : "disconnected");
    }

    public String toString() {
        return "<html>" + this.getAlias() + "<br/><small style=\"color:gray\">(" + this.getBaseUrl() + ")</small></html>";
    }

    private PasswordAuthentication getAuthentiaction() {
        if (this.password == null) {
            PasswordAuthentication passwordAuthentication;
            LogService.getRoot().info("Authentication requested for URL: " + this.getBaseUrl());
            if (this.cachedPasswordUsed) {
                passwordAuthentication = PasswordDialog.getPasswordAuthentication(this.getBaseUrl().toString(), false, false);
                this.cachedPasswordUsed = false;
            } else {
                passwordAuthentication = PasswordDialog.getPasswordAuthentication(this.getBaseUrl().toString(), false, true);
                this.cachedPasswordUsed = true;
            }
            if (passwordAuthentication != null) {
                this.setPassword(passwordAuthentication.getPassword());
                this.setUsername(passwordAuthentication.getUserName());
                RepositoryManager.getInstance(null).save();
            }
            return passwordAuthentication;
        }
        return new PasswordAuthentication(this.getUsername(), this.password);
    }

    public RepositoryService getRepositoryService() throws RepositoryException {
        this.installJDBCConnectionEntries();
        if (this.repositoryService == null) {
            try {
                RepositoryService_Service serviceService = new RepositoryService_Service(this.getRepositoryServiceWSDLUrl(), new QName("http://service.web.rapidanalytics.de/", "RepositoryService"));
                this.repositoryService = serviceService.getRepositoryServicePort();
                this.offline = false;
            }
            catch (Exception e) {
                this.offline = true;
                this.setPassword(null);
                this.repositoryService = null;
                throw new RepositoryException("Cannot connect to " + this.getBaseUrl() + ": " + e, e);
            }
        }
        return this.repositoryService;
    }

    public ProcessService getProcessService() throws RepositoryException {
        if (this.processService == null) {
            try {
                ProcessService_Service serviceService = new ProcessService_Service(this.getProcessServiceWSDLUrl(), new QName("http://service.web.rapidanalytics.de/", "ProcessService"));
                this.processService = serviceService.getProcessServicePort();
                this.offline = false;
            }
            catch (Exception e) {
                this.offline = true;
                this.setPassword(null);
                this.processService = null;
                throw new RepositoryException("Cannot connect to " + this.getBaseUrl() + ": " + e, e);
            }
        }
        return this.processService;
    }

    @Override
    public String getDescription() {
        return "Remote repository at " + this.getBaseUrl();
    }

    @Override
    public void refresh() throws RepositoryException {
        this.offline = false;
        this.cachedEntries.clear();
        super.refresh();
        this.removeJDBCConnectionEntries();
        this.installJDBCConnectionEntries();
    }

    protected HttpURLConnection getHTTPConnection(String location, EntryStreamType type) throws IOException {
        String[] split = location.split("/");
        StringBuilder encoded = new StringBuilder();
        encoded.append("RAWS/resources");
        for (String fraction : split) {
            if (fraction.isEmpty()) continue;
            encoded.append('/');
            encoded.append(URLEncoder.encode(fraction, "UTF-8"));
        }
        if (type == EntryStreamType.METADATA) {
            encoded.append("?format=binmeta");
        }
        HttpURLConnection conn = (HttpURLConnection)new URL(this.getBaseUrl(), encoded.toString()).openConnection();
        return conn;
    }

    @Override
    public Element createXML(Document doc) {
        Element repositoryElement = doc.createElement("remoteRepository");
        Element url = doc.createElement("url");
        url.appendChild(doc.createTextNode(this.getBaseUrl().toString()));
        repositoryElement.appendChild(url);
        Element alias = doc.createElement("alias");
        alias.appendChild(doc.createTextNode(this.getAlias()));
        repositoryElement.appendChild(alias);
        Element user = doc.createElement("user");
        user.appendChild(doc.createTextNode(this.getUsername()));
        repositoryElement.appendChild(user);
        return repositoryElement;
    }

    public static RemoteRepository fromXML(Element element) throws XMLException {
        String url = XMLTools.getTagContents(element, "url", true);
        try {
            return new RemoteRepository(new URL(url), XMLTools.getTagContents(element, "alias", true), XMLTools.getTagContents(element, "user", true), null, false);
        }
        catch (MalformedURLException e) {
            throw new XMLException("Illegal url '" + url + "': " + e, e);
        }
    }

    @Override
    public void delete() {
        RepositoryManager.getInstance(null).removeRepository(this);
    }

    public static List<RemoteRepository> getAll() {
        LinkedList<RemoteRepository> result = new LinkedList<RemoteRepository>();
        for (WeakReference<RemoteRepository> ref : ALL_REPOSITORIES.values()) {
            RemoteRepository rep = (RemoteRepository)ref.get();
            if (ref == null) continue;
            result.add(rep);
        }
        return result;
    }

    public boolean isConnected() {
        return !this.offline;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.getAlias() == null ? 0 : this.getAlias().hashCode());
        int uriModificator = 0;
        try {
            uriModificator = this.getBaseUrl() == null ? 0 : this.getBaseUrl().toURI().hashCode();
        }
        catch (URISyntaxException e) {
            // empty catch block
        }
        result = 31 * result + uriModificator;
        result = 31 * result + (this.getUsername() == null ? 0 : this.getUsername().hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        RemoteRepository other = (RemoteRepository)obj;
        if (this.getAlias() == null ? other.getAlias() != null : !this.getAlias().equals(other.getAlias())) {
            return false;
        }
        if (this.getBaseUrl() == null) {
            if (other.getBaseUrl() != null) {
                return false;
            }
        } else {
            try {
                if (!this.getBaseUrl().toURI().equals(other.getBaseUrl().toURI())) {
                    return false;
                }
            }
            catch (URISyntaxException e) {
                return false;
            }
        }
        return !(this.getUsername() == null ? other.getUsername() != null : !this.getUsername().equals(other.getUsername()));
    }

    public URI getURIForResource(String path) {
        try {
            return this.getBaseUrl().toURI().resolve("RA/faces/restricted/browse.xhtml?location=" + URLEncoder.encode(path, "UTF-8"));
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e);
        }
    }

    private URI getURIWebInterfaceURI() {
        try {
            return this.getBaseUrl().toURI().resolve("RA/faces/restricted/index.xhtml");
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e);
        }
    }

    public void browse(String location) {
        try {
            Desktop.getDesktop().browse(this.getURIForResource(location));
        }
        catch (Exception e) {
            SwingTools.showSimpleErrorMessage("cannot_open_browser", (Throwable)e, new Object[0]);
        }
    }

    public void showLog(int id) {
        try {
            Desktop.getDesktop().browse(this.getProcessLogURI(id));
        }
        catch (Exception e) {
            SwingTools.showSimpleErrorMessage("cannot_open_browser", (Throwable)e, new Object[0]);
        }
    }

    public URI getProcessLogURI(int id) {
        try {
            return this.getBaseUrl().toURI().resolve("/RA/processlog?id=" + id);
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public Collection<Action> getCustomActions() {
        Collection<Action> actions = super.getCustomActions();
        actions.add(new BrowseAction("remoterepository.administer", this.getRepository().getURIWebInterfaceURI()));
        return actions;
    }

    @Override
    public boolean shouldSave() {
        return !this.isHome;
    }

    private Collection<FieldConnectionEntry> fetchJDBCEntries() throws XMLException, CipherException, SAXException, IOException {
        URL xmlURL = new URL(this.getBaseUrl(), "RAWS/jdbc_connections.xml");
        Document doc = XMLTools.parse(xmlURL.openStream());
        Collection<FieldConnectionEntry> result = DatabaseConnectionService.parseEntries(doc.getDocumentElement());
        for (FieldConnectionEntry entry : result) {
            entry.setDynamic(true);
        }
        return result;
    }

    @Override
    public void postInstall() {
    }

    private void installJDBCConnectionEntries() {
        if (this.connectionEntries != null) {
            return;
        }
        try {
            this.connectionEntries = this.fetchJDBCEntries();
            for (FieldConnectionEntry entry : this.connectionEntries) {
                DatabaseConnectionService.addConnectionEntry(entry);
            }
            LogService.getRoot().config("Added " + this.connectionEntries.size() + " jdbc connections exported by " + this.getName() + ".");
        }
        catch (Exception e) {
            LogService.getRoot().log(Level.WARNING, "Failed to fetch JDBC connection entries from server " + this.getName() + ".", e);
        }
    }

    private void removeJDBCConnectionEntries() {
        if (this.connectionEntries != null) {
            for (FieldConnectionEntry entry : this.connectionEntries) {
                DatabaseConnectionService.deleteConnectionEntry(entry);
            }
            this.connectionEntries = null;
        }
    }

    @Override
    public void preRemove() {
    }

    public URL getBaseUrl() {
        return this.baseUrl;
    }

    public void setBaseUrl(URL url) {
        this.baseUrl = url;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public String getUsername() {
        return this.username;
    }

    public void setPassword(char[] password) {
        this.password = password;
    }

    @Override
    public boolean isConfigurable() {
        return true;
    }

    @Override
    public RepositoryConfigurationPanel makeConfigurationPanel() {
        return new RemoteRepositoryPanel();
    }

    public void setAlias(String alias) {
        this.alias = alias;
    }

    public String getAlias() {
        return this.alias;
    }

    static {
        GlobalAuthenticator.register(new GlobalAuthenticator.URLAuthenticator(){

            @Override
            public PasswordAuthentication getAuthentication(URL url) {
                Reference reposRef = null;
                for (Map.Entry entry : ALL_REPOSITORIES.entrySet()) {
                    if (!url.toString().startsWith(((URI)entry.getKey()).toString()) && !url.toString().replace("127\\.0\\.0\\.1", "localhost").startsWith(((URI)entry.getKey()).toString())) continue;
                    reposRef = (WeakReference)entry.getValue();
                    break;
                }
                if (reposRef == null) {
                    return null;
                }
                RemoteRepository repository = (RemoteRepository)reposRef.get();
                if (repository != null) {
                    return repository.getAuthentiaction();
                }
                return null;
            }

            @Override
            public String getName() {
                return "Repository authenticator.";
            }
        });
    }

    public static enum EntryStreamType {
        METADATA,
        IOOBJECT,
        PROCESS,
        BLOB;

    }
}

