/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.repository.remote;

import com.rapid_i.repository.wsimport.EntryResponse;
import com.rapid_i.repository.wsimport.ProcessContentsResponse;
import com.rapid_i.repository.wsimport.Response;
import com.rapidminer.io.process.XMLTools;
import com.rapidminer.repository.ProcessEntry;
import com.rapidminer.repository.RepositoryException;
import com.rapidminer.repository.remote.NewRevisionAction;
import com.rapidminer.repository.remote.RemoteDataEntry;
import com.rapidminer.repository.remote.RemoteFolder;
import com.rapidminer.repository.remote.RemoteRepository;
import java.util.Collection;
import java.util.Date;
import javax.swing.Action;

public class RemoteProcessEntry
extends RemoteDataEntry
implements ProcessEntry {
    private String xml;
    private final Object lock = new Object();

    public RemoteProcessEntry(EntryResponse response, RemoteFolder container, RemoteRepository repository) {
        super(response, container, repository);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void ensureLoaded() throws RepositoryException {
        Object object = this.lock;
        synchronized (object) {
            if (this.xml == null) {
                ProcessContentsResponse response = this.getRepository().getRepositoryService().getProcessContents(this.getPath(), 0);
                if (response.getStatus() != 0) {
                    this.xml = "Cannot fetch process: " + response.getErrorMessage();
                    RemoteProcessEntry.getLogger().warning("Cannot fetch process: " + response.getErrorMessage());
                    throw new RepositoryException("Cannot fetch process: " + response.getErrorMessage());
                }
                this.xml = response.getContents();
            }
        }
    }

    @Override
    public String retrieveXML() throws RepositoryException {
        this.ensureLoaded();
        return this.xml;
    }

    @Override
    public void storeXML(String xml) throws RepositoryException {
        Response response = this.getRepository().getRepositoryService().storeProcess(this.getPath(), xml, XMLTools.getXMLGregorianCalendar(new Date(this.getDate())));
        if (response.getStatus() != 0) {
            throw new RepositoryException(response.getErrorMessage());
        }
        this.setDate(this.getRepository().getRepositoryService().getEntry(this.getPath()).getDate());
        this.xml = null;
    }

    @Override
    public boolean willBlock() {
        return this.xml == null;
    }

    @Override
    public Collection<Action> getCustomActions() {
        Collection<Action> actions = super.getCustomActions();
        actions.add(new NewRevisionAction(this));
        return actions;
    }
}

