/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.repository.remote;

import com.rapid_i.repository.wsimport.EntryResponse;
import com.rapidminer.operator.IOObject;
import com.rapidminer.operator.Operator;
import com.rapidminer.operator.ports.metadata.MetaData;
import com.rapidminer.operator.tools.IOObjectSerializer;
import com.rapidminer.repository.IOObjectEntry;
import com.rapidminer.repository.RepositoryException;
import com.rapidminer.repository.remote.RMContentType;
import com.rapidminer.repository.remote.RemoteDataEntry;
import com.rapidminer.repository.remote.RemoteFolder;
import com.rapidminer.repository.remote.RemoteRepository;
import com.rapidminer.tools.LogService;
import com.rapidminer.tools.ProgressListener;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.lang.ref.SoftReference;
import java.net.HttpURLConnection;

public class RemoteIOObjectEntry
extends RemoteDataEntry
implements IOObjectEntry {
    private SoftReference<MetaData> metaData;
    private final Object metaDatalLock = new Object();
    private String ioObjectClassName;

    RemoteIOObjectEntry(EntryResponse response, RemoteFolder container, RemoteRepository repository) {
        super(response, container, repository);
        this.ioObjectClassName = response.getIoObjectClassName();
    }

    @Override
    public IOObject retrieveData(ProgressListener l) throws RepositoryException {
        if (l != null) {
            l.setTotal(100);
        }
        try {
            InputStream in;
            HttpURLConnection connection = this.getRepository().getHTTPConnection(this.getLocation().getPath(), RemoteRepository.EntryStreamType.IOOBJECT);
            connection.setDoInput(true);
            connection.setDoOutput(false);
            connection.setRequestMethod("GET");
            try {
                in = connection.getInputStream();
            }
            catch (IOException e) {
                throw new RepositoryException("Cannot download IOObject: " + connection.getResponseCode() + ": " + connection.getResponseMessage(), e);
            }
            Object result = IOObjectSerializer.getInstance().deserialize(in);
            if (result instanceof IOObject) {
                IOObject iOObject = (IOObject)result;
                return iOObject;
            }
            try {
                throw new RepositoryException("Server did not send I/O-Object, but instance of " + result.getClass());
            }
            catch (Exception e) {
                throw new RepositoryException("Cannot parse I/O-Object: " + e, e);
            }
        }
        finally {
            if (l != null) {
                l.complete();
            }
        }
    }

    @Override
    public MetaData retrieveMetaData() throws RepositoryException {
        Object object = this.metaDatalLock;
        synchronized (object) {
            MetaData storedData;
            if (this.metaData != null && (storedData = this.metaData.get()) != null) {
                return storedData;
            }
            try {
                InputStream in;
                HttpURLConnection connection = this.getRepository().getHTTPConnection(this.getLocation().getPath(), RemoteRepository.EntryStreamType.METADATA);
                connection.setRequestMethod("GET");
                try {
                    in = connection.getInputStream();
                }
                catch (IOException e) {
                    throw new RepositoryException("Cannot download meta data: " + connection.getResponseCode() + ": " + connection.getResponseMessage(), e);
                }
                Object result = IOObjectSerializer.getInstance().deserialize(in);
                if (result instanceof MetaData) {
                    this.metaData = new SoftReference<MetaData>((MetaData)result);
                    return (MetaData)result;
                }
                throw new RepositoryException("Server did not send MetaData, but instance of " + result.getClass());
            }
            catch (IOException e) {
                throw new RepositoryException("Cannot parse I/O-Object: " + e, e);
            }
        }
    }

    @Override
    public void storeData(IOObject ioobject, Operator callingOperator, ProgressListener l) throws RepositoryException {
        RemoteIOObjectEntry.storeData(ioobject, this.getPath(), this.getRepository(), l);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static void storeData(IOObject ioobject, String location, RemoteRepository repository, ProgressListener l) throws RepositoryException {
        HttpURLConnection conn;
        if (l != null) {
            l.setTotal(100);
            l.setCompleted(0);
        }
        try {
            conn = repository.getHTTPConnection(location, RemoteRepository.EntryStreamType.IOOBJECT);
        }
        catch (IOException e1) {
            throw new RepositoryException("Cannot store object at " + location + ": " + e1, e1);
        }
        OutputStream out = null;
        try {
            conn.setRequestProperty("Content-Type", RMContentType.IOOBJECT.getContentTypeString());
            conn.setRequestMethod("POST");
            conn.setDoOutput(true);
            conn.setDoInput(true);
            try {
                out = conn.getOutputStream();
            }
            catch (IOException e) {
                throw new RepositoryException("Cannot upload object: " + conn.getResponseCode() + ": " + conn.getResponseMessage(), e);
            }
            IOObjectSerializer.getInstance().serialize(out, ioobject);
            out.close();
            BufferedReader in = null;
            try {
                try {
                    String line;
                    in = new BufferedReader(new InputStreamReader(conn.getInputStream()));
                    LogService.getRoot().fine("BEGIN Reply of server:");
                    while ((line = in.readLine()) != null) {
                        LogService.getRoot().fine(line);
                    }
                    LogService.getRoot().fine("END Reply of server.");
                }
                catch (IOException e) {
                    // empty catch block
                }
            }
            finally {
                try {
                    if (in != null) {
                        in.close();
                    }
                }
                catch (IOException e) {}
            }
        }
        catch (IOException e) {
            try {
                throw new RepositoryException("Cannot store object at " + location + ": " + conn.getResponseCode() + ": " + conn.getResponseMessage(), e);
            }
            catch (IOException e1) {
                throw new RepositoryException("Cannot store object at " + location + ": " + e, e);
            }
        }
        finally {
            if (out != null) {
                try {
                    out.close();
                }
                catch (IOException e) {}
            }
        }
        if (l != null) {
            l.setCompleted(100);
            l.complete();
        }
    }

    @Override
    public boolean willBlock() {
        return this.metaData == null || this.metaData.get() == null;
    }

    @Override
    public Class<? extends IOObject> getObjectClass() {
        try {
            return Class.forName(this.ioObjectClassName);
        }
        catch (Exception e) {
            return null;
        }
    }
}

