/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.repository.remote;

import com.rapid_i.repository.wsimport.EntryResponse;
import com.rapid_i.repository.wsimport.FolderContentsResponse;
import com.rapid_i.repository.wsimport.Response;
import com.rapidminer.operator.IOObject;
import com.rapidminer.operator.Operator;
import com.rapidminer.repository.BlobEntry;
import com.rapidminer.repository.DataEntry;
import com.rapidminer.repository.Entry;
import com.rapidminer.repository.Folder;
import com.rapidminer.repository.IOObjectEntry;
import com.rapidminer.repository.MalformedRepositoryLocationException;
import com.rapidminer.repository.ProcessEntry;
import com.rapidminer.repository.RepositoryException;
import com.rapidminer.repository.RepositoryLocation;
import com.rapidminer.repository.remote.RemoteBlobEntry;
import com.rapidminer.repository.remote.RemoteEntry;
import com.rapidminer.repository.remote.RemoteIOObjectEntry;
import com.rapidminer.repository.remote.RemoteProcessEntry;
import com.rapidminer.repository.remote.RemoteRepository;
import com.rapidminer.tools.ProgressListener;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.List;

public class RemoteFolder
extends RemoteEntry
implements Folder {
    private final Comparator<Entry> nameComparator = new Comparator<Entry>(){

        @Override
        public int compare(Entry o1, Entry o2) {
            return o1.getName().compareTo(o2.getName());
        }
    };
    private List<Folder> folders;
    private List<DataEntry> entries;
    private final Object lock = new Object();
    private boolean readOnly = false;
    private boolean forbidden = false;

    RemoteFolder(String location) {
        super(location);
    }

    RemoteFolder(EntryResponse response, RemoteFolder container, RemoteRepository repository) {
        super(response, container, repository);
    }

    @Override
    public Folder createFolder(String name) throws RepositoryException {
        EntryResponse response = this.getRepository().getRepositoryService().makeFolder(this.getPath(), name);
        if (response.getStatus() != 0) {
            throw new RepositoryException(response.getErrorMessage());
        }
        RemoteFolder newFolder = new RemoteFolder(response, this, this.getRepository());
        if (this.folders != null) {
            this.folders.add(newFolder);
            Collections.sort(this.folders, this.nameComparator);
            this.getRepository().fireEntryAdded(newFolder, this);
        }
        return newFolder;
    }

    @Override
    public BlobEntry createBlobEntry(String name) throws RepositoryException {
        EntryResponse response = this.getRepository().getRepositoryService().createBlob(this.getPath(), name);
        RemoteBlobEntry newBlob = new RemoteBlobEntry(response, this, this.getRepository());
        if (this.entries != null) {
            this.entries.add(newBlob);
            Collections.sort(this.entries, this.nameComparator);
            this.getRepository().fireEntryAdded(newBlob, this);
        }
        return newBlob;
    }

    @Override
    public List<DataEntry> getDataEntries() throws RepositoryException {
        this.ensureLoaded();
        return this.entries;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void ensureLoaded() throws RepositoryException {
        Object object = this.lock;
        synchronized (object) {
            if (this.forbidden) {
                return;
            }
            if (this.entries == null || this.folders == null) {
                String path = this.getPath();
                FolderContentsResponse response = this.getRepository().getRepositoryService().getFolderContents(path);
                this.entries = new LinkedList<DataEntry>();
                this.folders = new LinkedList<Folder>();
                if (response.getStatus() != 0) {
                    if (response.getStatus() == -12) {
                        this.readOnly = true;
                        this.forbidden = true;
                    } else {
                        RemoteFolder.getLogger().warning("Cannot get folder: " + response.getErrorMessage());
                    }
                    return;
                }
                for (EntryResponse entry : response.getEntries()) {
                    if (entry.getType().equals("folder")) {
                        this.folders.add(new RemoteFolder(entry, this, this.getRepository()));
                        continue;
                    }
                    if (entry.getType().equals("process")) {
                        this.entries.add(new RemoteProcessEntry(entry, this, this.getRepository()));
                        continue;
                    }
                    if (entry.getType().equals("data")) {
                        this.entries.add(new RemoteIOObjectEntry(entry, this, this.getRepository()));
                        continue;
                    }
                    if (entry.getType().equals("blob")) {
                        this.entries.add(new RemoteBlobEntry(entry, this, this.getRepository()));
                        continue;
                    }
                    RemoteFolder.getLogger().warning("Unknown entry type: " + entry.getType());
                }
            }
        }
    }

    @Override
    public List<Folder> getSubfolders() throws RepositoryException {
        this.ensureLoaded();
        return this.folders;
    }

    @Override
    public String getType() {
        return "folder";
    }

    @Override
    public boolean willBlock() {
        return this.folders == null || this.entries == null;
    }

    @Override
    public void refresh() throws RepositoryException {
        this.folders = null;
        this.entries = null;
        this.readOnly = false;
        this.forbidden = false;
        this.ensureLoaded();
        this.getRepository().fireRefreshed(this);
    }

    @Override
    public boolean containsEntry(String name) throws RepositoryException {
        this.ensureLoaded();
        for (Folder folder : this.folders) {
            if (!folder.getName().equals(name)) continue;
            return true;
        }
        for (DataEntry entry : this.entries) {
            if (!entry.getName().equals(name)) continue;
            return true;
        }
        return false;
    }

    @Override
    public IOObjectEntry createIOObjectEntry(String name, IOObject ioobject, Operator callingOperator, ProgressListener l) throws RepositoryException {
        RepositoryLocation loc;
        try {
            loc = new RepositoryLocation(this.getLocation(), name);
        }
        catch (MalformedRepositoryLocationException e) {
            throw new RepositoryException(e);
        }
        RemoteIOObjectEntry.storeData(ioobject, loc.getPath(), this.getRepository(), l);
        EntryResponse response = this.getRepository().getRepositoryService().getEntry(loc.getPath());
        if (response.getStatus() != 0) {
            throw new RepositoryException(response.getErrorMessage());
        }
        RemoteIOObjectEntry entry = new RemoteIOObjectEntry(response, this, this.getRepository());
        if (this.entries != null) {
            this.entries.add(entry);
            this.getRepository().fireEntryAdded(entry, this);
        }
        return entry;
    }

    @Override
    public ProcessEntry createProcessEntry(String name, String processXML) throws RepositoryException {
        RepositoryLocation loc;
        try {
            loc = new RepositoryLocation(this.getLocation(), name);
        }
        catch (MalformedRepositoryLocationException e) {
            throw new RepositoryException(e);
        }
        Response response = this.getRepository().getRepositoryService().storeProcess(loc.getPath(), processXML, null);
        if (response.getStatus() != 0) {
            throw new RepositoryException(response.getErrorMessage());
        }
        EntryResponse entryResponse = this.getRepository().getRepositoryService().getEntry(loc.getPath());
        if (entryResponse.getStatus() != 0) {
            throw new RepositoryException(entryResponse.getErrorMessage());
        }
        RemoteProcessEntry entry = new RemoteProcessEntry(entryResponse, this, this.getRepository());
        if (this.entries != null) {
            this.entries.add(entry);
        }
        this.getRepository().fireEntryAdded(entry, this);
        return entry;
    }

    void removeChild(RemoteEntry remoteEntry) {
        if (remoteEntry instanceof Folder) {
            int index = this.folders.indexOf(remoteEntry);
            this.folders.remove(remoteEntry);
            this.getRepository().fireEntryRemoved(remoteEntry, this, index);
        } else {
            int index = this.entries.indexOf(remoteEntry) + this.folders.size();
            this.entries.remove(remoteEntry);
            this.getRepository().fireEntryRemoved(remoteEntry, this, index);
        }
    }

    @Override
    public boolean isReadOnly() {
        return this.readOnly;
    }
}

