/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.repository.remote;

import com.rapid_i.repository.wsimport.AccessRights;
import com.rapid_i.repository.wsimport.EntryResponse;
import com.rapid_i.repository.wsimport.Response;
import com.rapidminer.gui.actions.BrowseAction;
import com.rapidminer.repository.DataEntry;
import com.rapidminer.repository.Entry;
import com.rapidminer.repository.Folder;
import com.rapidminer.repository.MalformedRepositoryLocationException;
import com.rapidminer.repository.RepositoryException;
import com.rapidminer.repository.RepositoryLocation;
import com.rapidminer.repository.remote.AccessRightsAction;
import com.rapidminer.repository.remote.RemoteFolder;
import com.rapidminer.repository.remote.RemoteRepository;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.logging.Logger;
import javax.swing.Action;

public abstract class RemoteEntry
implements Entry {
    private static final Logger LOGGER = Logger.getLogger(RemoteEntry.class.getName());
    private RemoteRepository repository;
    private RemoteFolder containingFolder;
    private final String owner;
    private String location;
    private String name;

    RemoteEntry(String location) {
        if (location == null) {
            throw new NullPointerException("Location cannot be null");
        }
        this.location = location;
        int lastSlash = location.lastIndexOf(47);
        this.name = lastSlash == -1 ? location : location.substring(lastSlash + 1);
        this.owner = "none";
    }

    RemoteEntry(EntryResponse response, RemoteFolder container, RemoteRepository repository) {
        this.location = response.getLocation();
        this.owner = response.getUser();
        this.containingFolder = container;
        this.repository = repository;
        int lastSlash = this.location.lastIndexOf(47);
        this.name = lastSlash == -1 ? this.location : this.location.substring(lastSlash + 1);
        if (this.location == null) {
            throw new NullPointerException("Location cannot be null");
        }
        if (repository != null) {
            repository.register(this);
        }
    }

    void setRepository(RemoteRepository repository) {
        this.repository = repository;
    }

    @Override
    public Folder getContainingFolder() {
        return this.containingFolder;
    }

    @Override
    public String getDescription() {
        return "Remote entry at " + this.location;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getOwner() {
        return this.owner;
    }

    @Override
    public boolean isReadOnly() {
        return false;
    }

    @Override
    public boolean rename(String newName) throws RepositoryException {
        EntryResponse response = this.getRepository().getRepositoryService().rename(this.getPath(), newName);
        if (response.getStatus() == 0) {
            this.location = response.getLocation();
            int lastSlash = this.location.lastIndexOf(47);
            this.name = lastSlash == -1 ? this.location : this.location.substring(lastSlash + 1);
            this.getRepository().fireEntryRenamed(this);
            return true;
        }
        throw new RepositoryException(response.getErrorMessage());
    }

    public final RemoteRepository getRepository() {
        return this.repository;
    }

    final String getPath() {
        return this.location;
    }

    protected static Logger getLogger() {
        return LOGGER;
    }

    @Override
    public RepositoryLocation getLocation() {
        try {
            return new RepositoryLocation("//" + this.getRepository().getName() + this.location);
        }
        catch (MalformedRepositoryLocationException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void delete() throws RepositoryException {
        Response response = this.getRepository().getRepositoryService().deleteEntry(this.getLocation().getPath());
        if (response.getStatus() != 0) {
            throw new RepositoryException(response.getErrorMessage());
        }
        ((RemoteFolder)this.getContainingFolder()).removeChild(this);
    }

    @Override
    public boolean move(Folder newParent) throws RepositoryException {
        EntryResponse response = this.getRepository().getRepositoryService().move(this.getPath(), ((RemoteFolder)newParent).getPath());
        if (response.getStatus() != 0) {
            throw new RepositoryException(response.getErrorMessage());
        }
        this.containingFolder.removeChild(this);
        if (this instanceof Folder) {
            ((RemoteFolder)newParent).getSubfolders().add((Folder)((Object)this));
        } else {
            ((RemoteFolder)newParent).getDataEntries().add((DataEntry)((Object)this));
        }
        this.containingFolder = (RemoteFolder)newParent;
        this.getRepository().fireEntryAdded(this, newParent);
        return true;
    }

    @Override
    public Collection<Action> getCustomActions() {
        LinkedList<Action> actions = new LinkedList<Action>();
        actions.add(new AccessRightsAction(this));
        actions.add(new BrowseAction("remoteprocessviewer.browse", this.getRepository().getURIForResource(this.location)));
        return actions;
    }

    public List<AccessRights> getAccessRights() throws RepositoryException {
        return this.getRepository().getRepositoryService().getAccessRights(this.location);
    }

    public void setAccessRights(List<AccessRights> accessRights) throws RepositoryException {
        this.getRepository().getRepositoryService().setAccessRights(this.getPath(), accessRights);
    }
}

