/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.repository.remote;

import com.rapid_i.repository.wsimport.EntryResponse;
import com.rapidminer.repository.BlobEntry;
import com.rapidminer.repository.RepositoryException;
import com.rapidminer.repository.remote.RemoteDataEntry;
import com.rapidminer.repository.remote.RemoteFolder;
import com.rapidminer.repository.remote.RemoteRepository;
import com.rapidminer.tools.LogService;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;

public class RemoteBlobEntry
extends RemoteDataEntry
implements BlobEntry {
    private String mimeType;

    RemoteBlobEntry(EntryResponse response, RemoteFolder container, RemoteRepository repository) {
        super(response, container, repository);
    }

    @Override
    public String getMimeType() {
        return this.mimeType;
    }

    @Override
    public InputStream openInputStream() throws RepositoryException {
        try {
            HttpURLConnection conn = this.getRepository().getHTTPConnection(this.getLocation().getPath(), RemoteRepository.EntryStreamType.BLOB);
            conn.setDoOutput(false);
            conn.setDoInput(true);
            try {
                return conn.getInputStream();
            }
            catch (IOException e) {
                throw new RepositoryException("Cannot download object: " + conn.getResponseCode() + ": " + conn.getResponseMessage(), e);
            }
        }
        catch (IOException e) {
            throw new RepositoryException("Cannot open connection to '" + this.getLocation() + "': " + e, e);
        }
    }

    @Override
    public OutputStream openOutputStream(String mimeType) throws RepositoryException {
        this.mimeType = mimeType;
        try {
            OutputStream out;
            final HttpURLConnection conn = this.getRepository().getHTTPConnection(this.getLocation().getPath(), RemoteRepository.EntryStreamType.BLOB);
            conn.setDoOutput(true);
            conn.setDoInput(true);
            conn.setRequestProperty("Content-Type", mimeType);
            try {
                out = conn.getOutputStream();
            }
            catch (IOException e) {
                throw new RepositoryException("Cannot upload object: " + conn.getResponseCode() + ": " + conn.getResponseMessage(), e);
            }
            return new OutputStream(){

                @Override
                public void flush() throws IOException {
                    out.flush();
                }

                @Override
                public void write(byte[] b) throws IOException {
                    out.write(b);
                }

                @Override
                public void write(byte[] b, int off, int len) throws IOException {
                    out.write(b, off, len);
                }

                @Override
                public void write(int b) throws IOException {
                    out.write(b);
                }

                @Override
                public void close() throws IOException {
                    super.close();
                    out.close();
                    int code = conn.getResponseCode();
                    String error = conn.getResponseMessage();
                    if (code < 200 || code >= 300) {
                        throw new IOException("Upload failed. Server responded with code " + code + ": " + error);
                    }
                    LogService.getRoot().info("Uploaded blob. (" + code + ": " + error + ")");
                }
            };
        }
        catch (IOException e) {
            throw new RepositoryException("Cannot open connection to '" + this.getLocation() + "': " + e, e);
        }
    }

    @Override
    public boolean willBlock() {
        return false;
    }
}

