/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.repository.remote;

import com.rapid_i.repository.wsimport.ExecutionResponse;
import com.rapid_i.repository.wsimport.ProcessResponse;
import com.rapid_i.repository.wsimport.ProcessService;
import com.rapid_i.repository.wsimport.ProcessStackTrace;
import com.rapid_i.repository.wsimport.ProcessStackTraceElement;
import com.rapidminer.repository.RemoteProcessState;
import com.rapidminer.repository.RepositoryException;
import com.rapidminer.repository.RepositoryManager;
import com.rapidminer.repository.remote.RemoteRepository;
import com.rapidminer.tools.Tools;
import java.io.PrintStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class RapidAnalyticsCLTool {
    private Map<String, String> argsMap = new HashMap<String, String>();
    private long delay = 1000L;
    private boolean dumpStatus = false;
    private boolean watch = false;

    private RapidAnalyticsCLTool(String[] args) {
        this.extractArguments(args);
    }

    private void extractArguments(String[] args) {
        for (int i = 0; i < args.length; ++i) {
            if (args[i].startsWith("--")) {
                String[] split;
                args[i] = args[i].substring(2);
                if (args[i].equals("help")) {
                    this.printUsage();
                    System.exit(0);
                }
                if ((split = args[i].split("=", 2)).length != 2) {
                    System.err.println("Arguments must be of the form \"--key=value\".");
                    System.exit(1);
                    continue;
                }
                this.argsMap.put(split[0], split[1]);
                continue;
            }
            System.err.println("Arguments must be of the form \"--key=value\".");
            System.exit(1);
        }
    }

    private void printUsage() {
        System.out.println(RapidAnalyticsCLTool.class.getName() + " [OPTIONS]");
        System.out.println("   --url=URL ");
        System.out.println("       Base URL of the RapidAnalytics installation.");
        System.out.println("   --user=USER ");
        System.out.println("       User name to use for logging in.");
        System.out.println("   --password=PASSWORD");
        System.out.println("       Password to use for logging in.");
        System.out.println("   --execute-process=/PATH/TO/PROCESS");
        System.out.println("       Process location to execute.");
        System.out.println("   --watch={true|false}");
        System.out.println("       Watch process until completed.");
        System.out.println("   --process-id=ID");
        System.out.println("       Manually specify process ID (for --watch). Unnecessary for --execute process.");
        System.out.println("   --delay=MILLIS");
        System.out.println("       Loop delay in milliseconds when --watch is enabled.");
    }

    private String getArgument(String argName, String defaultValue) {
        String value = this.argsMap.get(argName);
        if (value != null) {
            return value;
        }
        if (defaultValue != null) {
            System.err.println("No value specified for --" + argName + ", using default (" + defaultValue + ").");
        }
        return defaultValue;
    }

    private int getArgumentInt(String argName, int defaultValue) {
        String value = this.argsMap.get(argName);
        if (value != null) {
            try {
                return Integer.parseInt(value);
            }
            catch (NumberFormatException e) {
                throw new IllegalArgumentException("Parameter " + argName + " must be a number.");
            }
        }
        return defaultValue;
    }

    public void run() throws IllegalArgumentException, MalformedURLException, RepositoryException {
        String url = this.getArgument("url", "http://localhost:8080");
        String user = this.getArgument("user", "admin");
        String password = this.getArgument("password", "changeit");
        System.err.println("Using RapidAnalytics server at " + url + "...");
        RemoteRepository repository = new RemoteRepository(new URL(url), "Temp", user, password.toCharArray(), true);
        RepositoryManager.getInstance(null).addRepository(repository);
        this.delay = this.getArgumentInt("delay", 1000);
        if ("true".equals(this.getArgument("watch", "false"))) {
            this.watch = true;
            this.dumpStatus = true;
        }
        int processId = -1;
        String executeProcess = this.getArgument("execute-process", null);
        if (executeProcess != null) {
            System.err.println("Scheduling process execution for process " + executeProcess);
            ExecutionResponse result = repository.getProcessService().executeProcessSimple(executeProcess, null, null);
            if (result.getStatus() != 0) {
                System.err.println("ERROR. Server responded with code " + result.getStatus() + ": " + result.getErrorMessage());
                System.exit(result.getStatus());
            } else {
                System.out.println("Process scheduled for " + result.getFirstExecution());
                int jobId = result.getJobId();
                processId = this.dumpStatus ? this.getJobId(jobId, repository.getProcessService()) : -1;
            }
        } else {
            processId = this.getArgumentInt("process-id", -1);
            if (processId != -1) {
                this.dumpStatus = true;
            }
        }
        if (this.dumpStatus) {
            RemoteProcessState state;
            if (processId == -1) {
                throw new IllegalArgumentException("You must use --process-id or --execute-service if --watch=true.");
            }
            do {
                ProcessResponse pInfo;
                if ((pInfo = repository.getProcessService().getRunningProcessesInfo(processId)) == null) {
                    throw new IllegalArgumentException("Process with id " + processId + " does not exist.");
                }
                this.dump(pInfo, System.out);
                if (this.watch) {
                    try {
                        Thread.sleep(this.delay);
                    }
                    catch (InterruptedException e) {
                        // empty catch block
                    }
                }
                state = RemoteProcessState.valueOf(pInfo.getState());
            } while (this.watch && !state.isTerminated());
            if (!state.isSuccessful()) {
                System.exit(1);
            } else {
                System.exit(0);
            }
        }
    }

    private int getJobId(int jobId, ProcessService processService) {
        List<Integer> result;
        while (true) {
            System.err.println("Waiting for server to assign process id to scheduled job id " + jobId + "...");
            result = processService.getProcessIdsForJobId(jobId);
            if (result != null && !result.isEmpty()) break;
            try {
                Thread.sleep(this.delay);
            }
            catch (InterruptedException e) {}
        }
        if (result.size() == 1) {
            Integer id = result.get(0);
            System.err.println("Process id is " + id + ".");
            return id;
        }
        throw new RuntimeException("Server delivered non-unique process id: " + result);
    }

    private void dump(ProcessResponse pInfo, PrintStream out) {
        ProcessStackTrace trace;
        out.println("State of process " + pInfo.getProcessLocation() + " (id=" + pInfo.getId() + ")");
        out.println("  Started:   " + pInfo.getStartTime());
        if (pInfo.getCompletionTime() != null) {
            out.println("  Completed: " + pInfo.getCompletionTime());
        }
        out.println("  State:     " + pInfo.getState());
        if (pInfo.getException() != null) {
            out.println("  Exception: " + pInfo.getException());
        }
        if ((trace = pInfo.getTrace()) != null) {
            out.println("  Trace:");
            for (ProcessStackTraceElement ste : trace.getElements()) {
                System.out.println("     " + ste.getOperatorName() + " (" + ste.getApplyCount() + ", " + Tools.formatDuration(ste.getExecutionTime()) + ")");
            }
        }
    }

    public static void main(String[] args) {
        try {
            new RapidAnalyticsCLTool(args).run();
        }
        catch (IllegalArgumentException e) {
            System.err.println(e.getMessage());
            System.exit(1);
        }
        catch (MalformedURLException e) {
            System.err.println(e.getMessage());
            System.exit(1);
        }
        catch (RepositoryException e) {
            System.err.println(e.getMessage());
            System.exit(1);
        }
    }
}

