/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.repository.remote;

import com.rapid_i.repository.wsimport.AccessRights;
import com.rapidminer.gui.tools.ExtendedJScrollPane;
import com.rapidminer.gui.tools.ExtendedJTable;
import com.rapidminer.gui.tools.ProgressThread;
import com.rapidminer.gui.tools.ResourceAction;
import com.rapidminer.gui.tools.SwingTools;
import com.rapidminer.gui.tools.dialogs.ButtonDialog;
import com.rapidminer.repository.AccessFlag;
import com.rapidminer.repository.AccessType;
import com.rapidminer.repository.RepositoryException;
import com.rapidminer.repository.remote.RemoteEntry;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.Collections;
import java.util.List;
import javax.swing.DefaultCellEditor;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableCellEditor;

public class AccessRightsDialog
extends ButtonDialog {
    private TableCellEditor accessRightsCellEditor = new DefaultCellEditor(new JComboBox<AccessFlag>(AccessFlag.values())){
        private static final long serialVersionUID = 1L;

        @Override
        public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
            JComboBox c = (JComboBox)super.getTableCellEditorComponent(table, value, isSelected, row, column);
            c.setSelectedItem(value);
            return c;
        }
    };
    private TableCellEditor groupsCellEditor;
    private static final long serialVersionUID = 1L;
    private RemoteEntry entry;
    private List<AccessRights> accessRights;
    private AccessRightsTableModel accessRightsTableModel;

    public AccessRightsDialog(RemoteEntry entry, List<AccessRights> accessRights, final List<String> groupNames) {
        super("repository.edit_access_rights", entry.getLocation());
        this.entry = entry;
        this.accessRights = accessRights;
        Collections.sort(groupNames);
        this.groupsCellEditor = new DefaultCellEditor(new JComboBox<Object>(groupNames.toArray())){
            private static final long serialVersionUID = 1L;

            @Override
            public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
                JComboBox c = (JComboBox)super.getTableCellEditorComponent(table, value, isSelected, row, column);
                c.setSelectedItem(value);
                return c;
            }
        };
        this.accessRightsTableModel = new AccessRightsTableModel();
        final ExtendedJTable table = new ExtendedJTable(this.accessRightsTableModel, false){
            private static final long serialVersionUID = 1L;

            @Override
            public TableCellEditor getCellEditor(int row, int column) {
                if (column == 0) {
                    return AccessRightsDialog.this.groupsCellEditor;
                }
                return AccessRightsDialog.this.accessRightsCellEditor;
            }
        };
        JButton addRowButton = new JButton(new ResourceAction("accessrights.add_row", new Object[0]){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent e) {
                AccessRights newRights = new AccessRights();
                newRights.setGroup((String)groupNames.get(0));
                newRights.setRead(AccessFlag.IGNORE.toString());
                newRights.setWrite(AccessFlag.IGNORE.toString());
                newRights.setExecute(AccessFlag.IGNORE.toString());
                if (table.getSelectedRow() == -1) {
                    AccessRightsDialog.this.accessRights.add(newRights);
                } else {
                    AccessRightsDialog.this.accessRights.add(table.getSelectedRow() + 1, newRights);
                }
                AccessRightsDialog.this.accessRightsTableModel.fireTableStructureChanged();
            }
        });
        JButton removeRowButton = new JButton(new ResourceAction("accessrights.remove_row", new Object[0]){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent e) {
                if (table.getSelectedRow() == -1) {
                    return;
                }
                AccessRightsDialog.this.accessRights.remove(table.getSelectedRow());
                AccessRightsDialog.this.accessRightsTableModel.fireTableStructureChanged();
            }
        });
        ExtendedJScrollPane tablePane = new ExtendedJScrollPane(table);
        tablePane.setBorder(AccessRightsDialog.createBorder());
        this.layoutDefault((JComponent)tablePane, 1, addRowButton, removeRowButton, this.makeOkButton(), this.makeCancelButton());
    }

    @Override
    protected void ok() {
        new ProgressThread("connect_to_repository"){

            @Override
            public void run() {
                try {
                    AccessRightsDialog.this.entry.setAccessRights(AccessRightsDialog.this.accessRights);
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            AccessRightsDialog.this.dispose();
                        }
                    });
                }
                catch (RepositoryException e) {
                    SwingTools.showSimpleErrorMessage("error_contacting_repository", (Throwable)e, e.getMessage());
                }
            }
        }.start();
    }

    private class AccessRightsTableModel
    extends AbstractTableModel {
        private static final long serialVersionUID = 1L;

        private AccessRightsTableModel() {
        }

        @Override
        public int getColumnCount() {
            return 4;
        }

        @Override
        public int getRowCount() {
            return AccessRightsDialog.this.accessRights.size();
        }

        @Override
        public Object getValueAt(int rowIndex, int columnIndex) {
            AccessRights ar = (AccessRights)AccessRightsDialog.this.accessRights.get(rowIndex);
            switch (columnIndex) {
                case 0: {
                    return ar.getGroup();
                }
                case 1: {
                    return ar.getRead();
                }
                case 2: {
                    return ar.getWrite();
                }
                case 3: {
                    return ar.getExecute();
                }
            }
            throw new IndexOutOfBoundsException(columnIndex + "");
        }

        @Override
        public String getColumnName(int column) {
            switch (column) {
                case 0: {
                    return "Group";
                }
                case 1: {
                    return AccessType.READ.toString();
                }
                case 2: {
                    return AccessType.WRITE.toString();
                }
                case 3: {
                    return AccessType.EXECUTE.toString();
                }
            }
            throw new IndexOutOfBoundsException(column + "");
        }

        @Override
        public boolean isCellEditable(int rowIndex, int columnIndex) {
            return true;
        }

        @Override
        public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
            AccessRights ar = (AccessRights)AccessRightsDialog.this.accessRights.get(rowIndex);
            switch (columnIndex) {
                case 0: {
                    ar.setGroup((String)aValue);
                    break;
                }
                case 1: {
                    ar.setRead(aValue.toString());
                    break;
                }
                case 2: {
                    ar.setWrite(aValue.toString());
                    break;
                }
                case 3: {
                    ar.setExecute(aValue.toString());
                    break;
                }
                default: {
                    throw new IndexOutOfBoundsException(columnIndex + "");
                }
            }
        }
    }
}

