/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.repository.remote;

import com.rapid_i.repository.wsimport.AccessRights;
import com.rapidminer.gui.tools.ProgressThread;
import com.rapidminer.gui.tools.ResourceAction;
import com.rapidminer.gui.tools.SwingTools;
import com.rapidminer.repository.RepositoryException;
import com.rapidminer.repository.remote.AccessRightsDialog;
import com.rapidminer.repository.remote.RemoteEntry;
import java.awt.event.ActionEvent;
import java.util.List;
import javax.swing.SwingUtilities;

public class AccessRightsAction
extends ResourceAction {
    private static final long serialVersionUID = 1L;
    private RemoteEntry entry;

    public AccessRightsAction(RemoteEntry entry) {
        super("repository.edit_access_rights", new Object[0]);
        this.entry = entry;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        new ProgressThread("download_from_repository"){

            @Override
            public void run() {
                try {
                    final List<String> groupNames = AccessRightsAction.this.entry.getRepository().getRepositoryService().getAllGroupNames();
                    final List<AccessRights> accessRights = AccessRightsAction.this.entry.getAccessRights();
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            new AccessRightsDialog(AccessRightsAction.this.entry, accessRights, groupNames).setVisible(true);
                        }
                    });
                }
                catch (RepositoryException e) {
                    SwingTools.showSimpleErrorMessage("error_contacting_repository", (Throwable)e, e.getMessage());
                }
            }
        }.start();
    }
}

