/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.repository.local;

import com.rapidminer.repository.Folder;
import com.rapidminer.repository.ProcessEntry;
import com.rapidminer.repository.RepositoryException;
import com.rapidminer.repository.local.LocalRepository;
import com.rapidminer.repository.local.SimpleDataEntry;
import com.rapidminer.repository.local.SimpleFolder;
import com.rapidminer.tools.Tools;
import java.io.File;
import java.io.IOException;

public class SimpleProcessEntry
extends SimpleDataEntry
implements ProcessEntry {
    SimpleProcessEntry(String name, SimpleFolder containingFolder, LocalRepository repository) {
        super(name, containingFolder, repository);
    }

    @Override
    public String retrieveXML() throws RepositoryException {
        try {
            return Tools.readTextFile(this.getFile());
        }
        catch (IOException e) {
            throw new RepositoryException("Cannot read " + this.getFile() + ": " + e, e);
        }
    }

    @Override
    public void storeXML(String xml) throws RepositoryException {
        try {
            Tools.writeTextFile(this.getFile(), xml);
        }
        catch (IOException e) {
            throw new RepositoryException("Cannot write " + this.getFile() + ": " + e, e);
        }
    }

    private File getFile() {
        return new File(((SimpleFolder)this.getContainingFolder()).getFile(), this.getName() + ".rmp");
    }

    @Override
    public int getRevision() {
        return 1;
    }

    @Override
    public long getSize() {
        return this.getFile().length();
    }

    @Override
    public void delete() throws RepositoryException {
        this.getFile().delete();
        super.delete();
    }

    @Override
    public String getDescription() {
        return "Local process";
    }

    @Override
    public String getType() {
        return "process";
    }

    @Override
    public boolean rename(String newName) {
        this.renameFile(this.getFile(), newName);
        return super.rename(newName);
    }

    @Override
    public boolean move(Folder newParent) {
        this.moveFile(this.getFile(), ((SimpleFolder)newParent).getFile());
        return super.move(newParent);
    }

    @Override
    public long getDate() {
        return this.getFile().lastModified();
    }
}

