/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.repository.local;

import com.rapidminer.operator.IOObject;
import com.rapidminer.operator.Operator;
import com.rapidminer.operator.ports.metadata.AttributeMetaData;
import com.rapidminer.operator.ports.metadata.ExampleSetMetaData;
import com.rapidminer.operator.ports.metadata.MetaData;
import com.rapidminer.operator.tools.IOObjectSerializer;
import com.rapidminer.operator.tools.RMObjectInputStream;
import com.rapidminer.repository.Folder;
import com.rapidminer.repository.IOObjectEntry;
import com.rapidminer.repository.RepositoryException;
import com.rapidminer.repository.local.LocalRepository;
import com.rapidminer.repository.local.SimpleDataEntry;
import com.rapidminer.repository.local.SimpleFolder;
import com.rapidminer.tools.ProgressListener;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.lang.ref.SoftReference;

public class SimpleIOObjectEntry
extends SimpleDataEntry
implements IOObjectEntry {
    private static final String PROPERTY_IOOBJECT_CLASS = "ioobject-class";
    private SoftReference<MetaData> metaData = null;
    private Class<? extends IOObject> dataObjectClass = null;

    SimpleIOObjectEntry(String name, SimpleFolder containingFolder, LocalRepository repository) {
        super(name, containingFolder, repository);
    }

    private File getDataFile() {
        return new File(((SimpleFolder)this.getContainingFolder()).getFile(), this.getName() + ".ioo");
    }

    protected File getMetaDataFile() {
        return new File(((SimpleFolder)this.getContainingFolder()).getFile(), this.getName() + ".md");
    }

    @Override
    public IOObject retrieveData(ProgressListener l) throws RepositoryException {
        File dataFile;
        if (l != null) {
            l.setTotal(100);
            l.setCompleted(10);
        }
        if ((dataFile = this.getDataFile()).exists()) {
            try {
                return (IOObject)IOObjectSerializer.getInstance().deserialize(new BufferedInputStream(new FileInputStream(dataFile)));
            }
            catch (Exception e) {
                throw new RepositoryException("Cannot load data from '" + dataFile + "': " + e, e);
            }
        }
        throw new RepositoryException("File '" + dataFile + " does not exist'.");
    }

    @Override
    public MetaData retrieveMetaData() throws RepositoryException {
        MetaData readObject;
        MetaData storedData;
        if (this.metaData != null && (storedData = this.metaData.get()) != null) {
            return storedData;
        }
        File metaDataFile = this.getMetaDataFile();
        if (metaDataFile.exists()) {
            ObjectInputStream objectIn = null;
            try {
                objectIn = new RMObjectInputStream(new FileInputStream(metaDataFile));
                readObject = (MetaData)objectIn.readObject();
                this.metaData = new SoftReference<MetaData>(readObject);
                if (readObject instanceof ExampleSetMetaData) {
                    for (AttributeMetaData amd : ((ExampleSetMetaData)readObject).getAllAttributes()) {
                        if (!amd.isNominal()) continue;
                        amd.shrinkValueSet();
                    }
                }
                objectIn.close();
            }
            catch (Exception e) {
                throw new RepositoryException("Cannot load meta data from '" + metaDataFile + "': " + e, e);
            }
            finally {
                if (objectIn != null) {
                    try {
                        objectIn.close();
                    }
                    catch (IOException e) {}
                }
            }
        }
        throw new RepositoryException("Meta data file '" + metaDataFile + " does not exist'.");
        return readObject;
    }

    @Override
    public void storeData(IOObject data, Operator callingOperator, ProgressListener l) throws RepositoryException {
        if (l != null) {
            l.setTotal(100);
            l.setCompleted(10);
        }
        MetaData md = MetaData.forIOObject(data);
        OutputStream out = null;
        try {
            out = new BufferedOutputStream(new FileOutputStream(this.getDataFile()));
            IOObjectSerializer.getInstance().serialize(out, data);
            if (l != null) {
                l.setCompleted(75);
            }
        }
        catch (Exception e) {
            throw new RepositoryException("Cannot store data at '" + this.getDataFile() + "': " + e, e);
        }
        finally {
            if (out != null) {
                try {
                    out.close();
                }
                catch (IOException e) {}
            }
        }
        ObjectOutputStream mdOut = null;
        try {
            mdOut = new ObjectOutputStream(new FileOutputStream(this.getMetaDataFile()));
            mdOut.writeObject(md);
            mdOut.close();
            if (l != null) {
                l.setCompleted(90);
            }
        }
        catch (Exception e) {
            throw new RepositoryException("Cannot store data at '" + this.getMetaDataFile() + "': " + e, e);
        }
        finally {
            if (mdOut != null) {
                try {
                    mdOut.close();
                }
                catch (IOException e) {}
            }
            if (l != null) {
                l.setCompleted(100);
                l.complete();
            }
        }
        this.metaData = new SoftReference<MetaData>(md);
        this.putProperty(PROPERTY_IOOBJECT_CLASS, data.getClass().getName());
    }

    @Override
    public String getType() {
        return "data";
    }

    @Override
    public String getDescription() {
        if (this.metaData != null) {
            MetaData md = this.metaData.get();
            if (md != null) {
                return md.getDescription();
            }
            return "Simple entry.";
        }
        return "Simple entry.";
    }

    @Override
    public long getSize() {
        if (this.getDataFile().exists()) {
            return this.getDataFile().length();
        }
        return 0L;
    }

    @Override
    public void delete() throws RepositoryException {
        if (this.getDataFile().exists()) {
            this.getDataFile().delete();
        }
        if (this.getMetaDataFile().exists()) {
            this.getMetaDataFile().delete();
        }
        super.delete();
    }

    @Override
    public boolean rename(String newName) {
        this.renameFile(this.getDataFile(), newName);
        this.renameFile(this.getMetaDataFile(), newName);
        return super.rename(newName);
    }

    @Override
    public boolean move(Folder newParent) {
        this.moveFile(this.getDataFile(), ((SimpleFolder)newParent).getFile());
        this.moveFile(this.getMetaDataFile(), ((SimpleFolder)newParent).getFile());
        return super.move(newParent);
    }

    @Override
    public long getDate() {
        return this.getDataFile().lastModified();
    }

    @Override
    public boolean willBlock() {
        return this.metaData == null || this.metaData.get() == null;
    }

    @Override
    public Class<? extends IOObject> getObjectClass() {
        if (this.dataObjectClass == null) {
            String className = this.getProperty(PROPERTY_IOOBJECT_CLASS);
            if (className != null) {
                try {
                    this.dataObjectClass = Class.forName(className);
                    return this.dataObjectClass;
                }
                catch (ClassNotFoundException e) {
                    return null;
                }
            }
            try {
                this.dataObjectClass = this.retrieveMetaData().getObjectClass();
                if (this.dataObjectClass != null) {
                    this.putProperty(PROPERTY_IOOBJECT_CLASS, this.dataObjectClass.getName());
                }
                return this.dataObjectClass;
            }
            catch (RepositoryException e) {
                return null;
            }
        }
        return this.dataObjectClass;
    }
}

