/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.repository.local;

import com.rapidminer.operator.IOObject;
import com.rapidminer.operator.Operator;
import com.rapidminer.repository.BlobEntry;
import com.rapidminer.repository.DataEntry;
import com.rapidminer.repository.Entry;
import com.rapidminer.repository.Folder;
import com.rapidminer.repository.IOObjectEntry;
import com.rapidminer.repository.ProcessEntry;
import com.rapidminer.repository.RepositoryException;
import com.rapidminer.repository.local.LocalRepository;
import com.rapidminer.repository.local.SimpleBlobEntry;
import com.rapidminer.repository.local.SimpleEntry;
import com.rapidminer.repository.local.SimpleIOObjectEntry;
import com.rapidminer.repository.local.SimpleProcessEntry;
import com.rapidminer.tools.ProgressListener;
import com.rapidminer.tools.Tools;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;

public class SimpleFolder
extends SimpleEntry
implements Folder {
    private static final Comparator<Entry> NAME_COMPARATOR = new Comparator<Entry>(){

        @Override
        public int compare(Entry o1, Entry o2) {
            return o1.getName().compareTo(o2.getName());
        }
    };
    private List<DataEntry> data;
    private List<Folder> folders;

    SimpleFolder(String name, SimpleFolder parent, LocalRepository repository) throws RepositoryException {
        super(name, parent, repository);
    }

    protected void mkdir() throws RepositoryException {
        File file = this.getFile();
        if (!file.exists() && !file.mkdir()) {
            throw new RepositoryException("Cannot create repository folder at '" + file + "'.");
        }
    }

    @Override
    public boolean rename(String newName) {
        this.renameFile(this.getFile(), newName);
        return super.rename(newName);
    }

    @Override
    public boolean move(Folder newParent) {
        this.moveFile(this.getFile(), ((SimpleFolder)newParent).getFile());
        return super.move(newParent);
    }

    protected File getFile() {
        return new File(((SimpleFolder)this.getContainingFolder()).getFile(), this.getName());
    }

    @Override
    public List<DataEntry> getDataEntries() throws RepositoryException {
        this.ensureLoaded();
        return Collections.unmodifiableList(this.data);
    }

    @Override
    public List<Folder> getSubfolders() throws RepositoryException {
        this.ensureLoaded();
        return Collections.unmodifiableList(this.folders);
    }

    private void ensureLoaded() throws RepositoryException {
        if (this.data != null && this.folders != null) {
            return;
        }
        this.data = new ArrayList<DataEntry>();
        this.folders = new ArrayList<Folder>();
        File fileFolder = this.getFile();
        if (fileFolder != null && fileFolder.exists()) {
            File[] listFiles;
            for (File file : listFiles = fileFolder.listFiles()) {
                if (file.isHidden()) continue;
                if (file.isDirectory()) {
                    this.folders.add(new SimpleFolder(file.getName(), this, this.getRepository()));
                    continue;
                }
                if (file.getName().endsWith(".ioo")) {
                    this.data.add(new SimpleIOObjectEntry(file.getName().substring(0, file.getName().length() - 4), this, this.getRepository()));
                    continue;
                }
                if (file.getName().endsWith(".rmp")) {
                    this.data.add(new SimpleProcessEntry(file.getName().substring(0, file.getName().length() - 4), this, this.getRepository()));
                    continue;
                }
                if (!file.getName().endsWith(".blob")) continue;
                this.data.add(new SimpleBlobEntry(file.getName().substring(0, file.getName().length() - 5), this, this.getRepository()));
            }
            Collections.sort(this.data, NAME_COMPARATOR);
            Collections.sort(this.folders, NAME_COMPARATOR);
        }
    }

    @Override
    public IOObjectEntry createIOObjectEntry(String name, IOObject ioobject, Operator callingOperator, ProgressListener l) throws RepositoryException {
        this.ensureLoaded();
        SimpleIOObjectEntry entry = new SimpleIOObjectEntry(name, this, this.getRepository());
        this.data.add(entry);
        if (ioobject != null) {
            entry.storeData(ioobject, null, l);
        }
        this.getRepository().fireEntryAdded(entry, this);
        return entry;
    }

    @Override
    public Folder createFolder(String name) throws RepositoryException {
        this.ensureLoaded();
        for (Folder folder : this.folders) {
            if (!folder.getName().equals(name)) continue;
            return folder;
        }
        for (DataEntry entry : this.data) {
            if (!entry.getName().equals(name)) continue;
            throw new RepositoryException("Entry '" + name + "' exists but is not a folder.");
        }
        SimpleFolder folder = new SimpleFolder(name, this, this.getRepository());
        this.folders.add(folder);
        folder.mkdir();
        this.getRepository().fireEntryAdded(folder, this);
        return folder;
    }

    @Override
    public String getDescription() {
        return "Folder '" + this.getName() + "'";
    }

    @Override
    public boolean isReadOnly() {
        return false;
    }

    @Override
    public String getType() {
        return "folder";
    }

    @Override
    public void refresh() {
        this.data = null;
        this.folders = null;
        this.getRepository().fireRefreshed(this);
    }

    @Override
    public boolean containsEntry(String name) throws RepositoryException {
        this.ensureLoaded();
        for (Folder folder : this.folders) {
            if (!folder.getName().equals(name)) continue;
            return true;
        }
        for (DataEntry entry : this.data) {
            if (!entry.getName().equals(name)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void delete() throws RepositoryException {
        if (!Tools.delete(this.getFile())) {
            throw new RepositoryException("Cannot delete directory");
        }
        super.delete();
    }

    void removeChild(SimpleEntry child) {
        int index;
        if (child instanceof SimpleFolder) {
            index = this.folders.indexOf(child);
            this.folders.remove(child);
        } else {
            index = this.data.indexOf(child) + this.folders.size();
            this.data.remove(child);
        }
        this.getRepository().fireEntryRemoved(child, this, index);
    }

    void addChild(SimpleEntry child) {
        if (child instanceof SimpleFolder) {
            this.folders.add((Folder)((Object)child));
        } else {
            this.data.add((DataEntry)((Object)child));
        }
        this.getRepository().fireEntryAdded(child, this);
    }

    @Override
    public ProcessEntry createProcessEntry(String name, String processXML) throws RepositoryException {
        SimpleProcessEntry entry = new SimpleProcessEntry(name, this, this.getRepository());
        if (this.data != null) {
            this.data.add(entry);
        }
        this.getRepository().fireEntryAdded(entry, this);
        entry.storeXML(processXML);
        return entry;
    }

    @Override
    public BlobEntry createBlobEntry(String name) throws RepositoryException {
        SimpleBlobEntry entry = new SimpleBlobEntry(name, this, this.getRepository());
        if (this.data != null) {
            this.data.add(entry);
        }
        this.getRepository().fireEntryAdded(entry, this);
        return entry;
    }
}

