/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.repository.local;

import com.rapidminer.repository.Entry;
import com.rapidminer.repository.Folder;
import com.rapidminer.repository.MalformedRepositoryLocationException;
import com.rapidminer.repository.RepositoryException;
import com.rapidminer.repository.RepositoryLocation;
import com.rapidminer.repository.local.LocalRepository;
import com.rapidminer.repository.local.SimpleFolder;
import com.rapidminer.tools.LogService;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import java.util.Properties;
import java.util.logging.Level;
import javax.swing.Action;

public abstract class SimpleEntry
implements Entry {
    private Properties properties;
    private String name;
    private LocalRepository repository;
    private SimpleFolder containingFolder;

    SimpleEntry(String name, SimpleFolder containingFolder, LocalRepository repository) {
        this.name = name;
        this.repository = repository;
        this.containingFolder = containingFolder;
    }

    protected LocalRepository getRepository() {
        return this.repository;
    }

    protected void setRepository(LocalRepository repository) {
        this.repository = repository;
    }

    void setName(String name) {
        this.name = name;
    }

    @Override
    public Folder getContainingFolder() {
        return this.containingFolder;
    }

    @Override
    public boolean isReadOnly() {
        return false;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public boolean rename(String newName) {
        this.renameFile(this.getPropertiesFile(), newName);
        this.name = newName;
        this.getRepository().fireEntryRenamed(this);
        return true;
    }

    public String toString() {
        return this.getName();
    }

    @Override
    public boolean willBlock() {
        return false;
    }

    @Override
    public String getOwner() {
        return this.getProperty("owner");
    }

    @Override
    public RepositoryLocation getLocation() {
        try {
            if (this.getContainingFolder() != null) {
                return new RepositoryLocation(this.getContainingFolder().getLocation(), this.getName());
            }
            return new RepositoryLocation(this.getRepository().getName(), new String[]{this.getName()});
        }
        catch (MalformedRepositoryLocationException e) {
            throw new RuntimeException(e);
        }
    }

    void renameFile(File file2, String newBaseName) {
        if (!file2.exists()) {
            LogService.getRoot().warning("Cannot rename " + file2 + ": does not exist.");
            return;
        }
        String name = file2.getName();
        int dot = name.lastIndexOf(46);
        if (dot == -1) {
            file2.renameTo(new File(file2.getParentFile(), newBaseName));
        } else {
            String extension = name.substring(dot + 1);
            file2.renameTo(new File(file2.getParentFile(), newBaseName + "." + extension));
        }
    }

    boolean moveFile(File file, File targetDirectory) {
        return file.renameTo(new File(targetDirectory, file.getName()));
    }

    @Override
    public boolean move(Folder newParent) {
        this.containingFolder.removeChild(this);
        this.containingFolder = (SimpleFolder)newParent;
        this.containingFolder.addChild(this);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadProperties() {
        File propertiesFile = this.getPropertiesFile();
        if (propertiesFile != null && propertiesFile.exists()) {
            FileInputStream in;
            try {
                in = new FileInputStream(propertiesFile);
            }
            catch (FileNotFoundException e) {
                LogService.getRoot().log(Level.WARNING, "Error loading repository entry properties from " + propertiesFile + ": " + e, e);
                return;
            }
            try {
                this.properties.loadFromXML(in);
            }
            catch (Exception e) {
                LogService.getRoot().log(Level.WARNING, "Error loading repository entry properties from " + propertiesFile + ": " + e, e);
            }
            finally {
                try {
                    ((InputStream)in).close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void storeProperties() {
        File propertiesFile = this.getPropertiesFile();
        if (propertiesFile != null) {
            FileOutputStream os;
            try {
                os = new FileOutputStream(propertiesFile);
            }
            catch (FileNotFoundException e1) {
                LogService.getRoot().log(Level.WARNING, "Error storing repository entry properties to " + propertiesFile + ": " + e1, e1);
                return;
            }
            try {
                this.properties.storeToXML(os, "Properties of repository entry " + this.getName());
            }
            catch (IOException e) {
                LogService.getRoot().log(Level.WARNING, "Error storing repository entry properties to " + propertiesFile + ": " + e, e);
            }
            finally {
                try {
                    os.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    private synchronized Properties getProperties() {
        if (this.properties == null) {
            this.properties = new Properties();
            this.loadProperties();
            if (this.properties.getProperty("owner") == null) {
                this.putProperty("owner", System.getProperty("user.name"));
            }
        }
        return this.properties;
    }

    protected void putProperty(String key, String value) {
        if (value != null) {
            this.getProperties().setProperty(key, value);
            this.storeProperties();
        }
    }

    protected String getProperty(String key) {
        return this.getProperties().getProperty(key);
    }

    private File getPropertiesFile() {
        if (this.getContainingFolder() != null) {
            return new File(((SimpleFolder)this.getContainingFolder()).getFile(), this.getName() + ".properties");
        }
        return new File(this.getRepository().getRoot(), this.getName() + ".properties");
    }

    @Override
    public void delete() throws RepositoryException {
        SimpleFolder parent;
        File propFile = this.getPropertiesFile();
        if (propFile.exists()) {
            propFile.delete();
        }
        if ((parent = (SimpleFolder)this.getContainingFolder()) != null) {
            parent.removeChild(this);
        }
    }

    @Override
    public Collection<Action> getCustomActions() {
        return null;
    }
}

