/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.repository.local;

import com.rapidminer.repository.BlobEntry;
import com.rapidminer.repository.RepositoryException;
import com.rapidminer.repository.local.LocalRepository;
import com.rapidminer.repository.local.SimpleDataEntry;
import com.rapidminer.repository.local.SimpleFolder;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class SimpleBlobEntry
extends SimpleDataEntry
implements BlobEntry {
    SimpleBlobEntry(String name, SimpleFolder containingFolder, LocalRepository localRepository) {
        super(name, containingFolder, localRepository);
    }

    private File getFile() {
        return new File(((SimpleFolder)this.getContainingFolder()).getFile(), this.getName() + ".blob");
    }

    @Override
    public long getDate() {
        return this.getFile().lastModified();
    }

    @Override
    public long getSize() {
        return this.getFile().length();
    }

    @Override
    public void delete() throws RepositoryException {
        this.getFile().delete();
        super.delete();
    }

    @Override
    public boolean rename(String newName) {
        this.renameFile(this.getFile(), newName);
        return super.rename(newName);
    }

    @Override
    public String getType() {
        return "blob";
    }

    @Override
    public String getMimeType() {
        return this.getProperty("mimetype");
    }

    @Override
    public InputStream openInputStream() throws RepositoryException {
        try {
            return new FileInputStream(this.getFile());
        }
        catch (FileNotFoundException e) {
            throw new RepositoryException("Cannot open stream from '" + this.getFile() + "': " + e, e);
        }
    }

    @Override
    public OutputStream openOutputStream(String mimeType) throws RepositoryException {
        this.putProperty("mimetype", mimeType);
        try {
            return new FileOutputStream(this.getFile());
        }
        catch (IOException e) {
            throw new RepositoryException("Cannot open stream from '" + this.getFile() + "': " + e, e);
        }
    }
}

