/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.repository.gui.process;

import com.rapid_i.repository.wsimport.ProcessResponse;
import com.rapid_i.repository.wsimport.ProcessStackTrace;
import com.rapid_i.repository.wsimport.ProcessStackTraceElement;
import com.rapidminer.io.process.XMLTools;
import com.rapidminer.repository.RemoteProcessState;
import com.rapidminer.repository.gui.process.ExceptionWrapper;
import com.rapidminer.repository.gui.process.OutputLocation;
import com.rapidminer.repository.remote.RemoteRepository;
import com.rapidminer.tools.LogService;
import java.lang.reflect.InvocationTargetException;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;
import java.util.logging.Level;
import javax.swing.SwingUtilities;
import javax.swing.event.EventListenerList;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;
import javax.xml.datatype.XMLGregorianCalendar;

public class RemoteProcessesTreeModel
implements TreeModel {
    private static final long serialVersionUID = 1L;
    private static final long UPDATE_PERIOD = 2500L;
    private Map<RemoteRepository, ProcessList> processes = new HashMap<RemoteRepository, ProcessList>();
    private List<RemoteRepository> repositories = new LinkedList<RemoteRepository>();
    private Set<RemoteRepository> observedRepositories = new HashSet<RemoteRepository>();
    private Object root = new Object();
    private Timer updateTimer = new Timer("RemoteProcess-Updater", true);
    private XMLGregorianCalendar since;
    private EventListenerList listeners = new EventListenerList();

    public RemoteProcessesTreeModel() {
        this.updateTimer.schedule((TimerTask)new UpdateTask(), 2500L, 2500L);
    }

    @Override
    public void addTreeModelListener(TreeModelListener l) {
        this.listeners.add(TreeModelListener.class, l);
    }

    @Override
    public void removeTreeModelListener(TreeModelListener l) {
        this.listeners.remove(TreeModelListener.class, l);
    }

    @Override
    public Object getChild(Object parent, int index) {
        if (parent == this.root) {
            return this.repositories.get(index);
        }
        if (parent instanceof RemoteRepository) {
            return this.processes.get(parent).getByIndex(index);
        }
        if (parent instanceof ProcessResponse) {
            ProcessResponse proResponse = (ProcessResponse)parent;
            if (proResponse.getException() != null) {
                if (index == 0) {
                    return new ExceptionWrapper(proResponse.getException());
                }
                return null;
            }
            ProcessStackTrace trace = proResponse.getTrace();
            int elementsSize = 0;
            if (trace != null && trace.getElements() != null) {
                elementsSize = trace.getElements().size();
            }
            if (index < elementsSize) {
                return trace.getElements().get(index);
            }
            return new OutputLocation(proResponse.getOutputLocations().get(index - elementsSize));
        }
        return null;
    }

    @Override
    public int getChildCount(Object parent) {
        if (parent == this.root) {
            return this.repositories.size();
        }
        if (parent instanceof RemoteRepository) {
            ProcessList list = this.processes.get(parent);
            if (list == null) {
                return 0;
            }
            return list.size();
        }
        if (parent instanceof ProcessResponse) {
            ProcessResponse proResponse = (ProcessResponse)parent;
            if (proResponse.getException() != null) {
                return 1;
            }
            int size = 0;
            ProcessStackTrace trace = proResponse.getTrace();
            if (trace != null && trace.getElements() != null) {
                size += trace.getElements().size();
            }
            if (proResponse.getOutputLocations() != null) {
                size += proResponse.getOutputLocations().size();
            }
            return size;
        }
        return 0;
    }

    @Override
    public int getIndexOfChild(Object parent, Object child) {
        if (parent == this.root) {
            return this.repositories.indexOf(child);
        }
        if (parent instanceof RemoteRepository) {
            return this.processes.get(parent).indexOf((ProcessResponse)child);
        }
        if (parent instanceof ProcessResponse) {
            ProcessResponse proResponse = (ProcessResponse)parent;
            if (child instanceof ProcessStackTraceElement) {
                ProcessStackTrace trace = proResponse.getTrace();
                if (trace != null && trace.getElements() != null) {
                    return trace.getElements().indexOf(child);
                }
                return -1;
            }
            if (child instanceof OutputLocation) {
                if (proResponse.getOutputLocations() != null) {
                    return proResponse.getOutputLocations().indexOf(((OutputLocation)child).getLocation());
                }
                return -1;
            }
            if (child instanceof ExceptionWrapper) {
                return 0;
            }
            return -1;
        }
        return -1;
    }

    @Override
    public Object getRoot() {
        return this.root;
    }

    @Override
    public boolean isLeaf(Object node) {
        return node != this.root && !(node instanceof ProcessResponse) && !(node instanceof RemoteRepository);
    }

    @Override
    public void valueForPathChanged(TreePath path, Object newValue) {
    }

    private void fireAdd(TreeModelEvent e) {
        for (TreeModelListener l : (TreeModelListener[])this.listeners.getListeners(TreeModelListener.class)) {
            l.treeNodesInserted(e);
        }
    }

    private void fireDelete(TreeModelEvent event) {
        for (TreeModelListener l : (TreeModelListener[])this.listeners.getListeners(TreeModelListener.class)) {
            l.treeNodesRemoved(event);
        }
    }

    private void fireStructureChanged(TreeModelEvent e) {
        for (TreeModelListener l : (TreeModelListener[])this.listeners.getListeners(TreeModelListener.class)) {
            l.treeStructureChanged(e);
        }
    }

    public void setSince(Date since) {
        this.since = since == null ? null : XMLTools.getXMLGregorianCalendar(since);
    }

    public void observe(RemoteRepository rep) {
        this.observedRepositories.add(rep);
    }

    public void ignore(RemoteRepository rep) {
        this.observedRepositories.remove(rep);
    }

    private final class UpdateTask
    extends TimerTask {
        private UpdateTask() {
        }

        @Override
        public void run() {
            final List<RemoteRepository> newRepositories = RemoteRepository.getAll();
            if (!((Object)newRepositories).equals(RemoteProcessesTreeModel.this.repositories)) {
                try {
                    SwingUtilities.invokeAndWait(new Runnable(){

                        @Override
                        public void run() {
                            RemoteProcessesTreeModel.this.repositories = newRepositories;
                            RemoteProcessesTreeModel.this.processes.clear();
                            for (RemoteRepository repos : RemoteProcessesTreeModel.this.repositories) {
                                RemoteProcessesTreeModel.this.processes.put(repos, new ProcessList());
                            }
                            RemoteProcessesTreeModel.this.fireStructureChanged(new TreeModelEvent((Object)this, new Object[]{RemoteProcessesTreeModel.this.root}));
                        }
                    });
                }
                catch (InterruptedException e) {
                    LogService.getRoot().log(Level.WARNING, e.toString(), e);
                }
                catch (InvocationTargetException e) {
                    LogService.getRoot().log(Level.WARNING, e.toString(), e);
                }
            }
            for (final RemoteRepository repos : RemoteProcessesTreeModel.this.repositories) {
                if (!RemoteProcessesTreeModel.this.observedRepositories.contains(repos)) continue;
                final ProcessList processList = (ProcessList)RemoteProcessesTreeModel.this.processes.get(repos);
                try {
                    final List<Integer> processIds = repos.getProcessService().getRunningProcesses(RemoteProcessesTreeModel.this.since);
                    SwingUtilities.invokeAndWait(new Runnable(){

                        @Override
                        public void run() {
                            TreeModelEvent deleteEvent = processList.trim(new HashSet(processIds), repos);
                            if (deleteEvent != null) {
                                RemoteProcessesTreeModel.this.fireDelete(deleteEvent);
                            }
                        }
                    });
                    for (Integer processId : processIds) {
                        ProcessResponse oldProcess = processList.getById(processId);
                        if (oldProcess == null) {
                            final ProcessResponse newResponse = repos.getProcessService().getRunningProcessesInfo(processId);
                            SwingUtilities.invokeAndWait(new Runnable(){

                                @Override
                                public void run() {
                                    int newIndex = processList.add(newResponse);
                                    RemoteProcessesTreeModel.this.fireAdd(new TreeModelEvent((Object)this, new Object[]{RemoteProcessesTreeModel.this.root, repos}, new int[]{newIndex}, new Object[]{newResponse}));
                                }
                            });
                            continue;
                        }
                        if (RemoteProcessState.valueOf(oldProcess.getState()).isTerminated()) continue;
                        final ProcessResponse updatedResponse = repos.getProcessService().getRunningProcessesInfo(processId);
                        SwingUtilities.invokeAndWait(new Runnable(){

                            @Override
                            public void run() {
                                processList.add(updatedResponse);
                                RemoteProcessesTreeModel.this.fireStructureChanged(new TreeModelEvent((Object)this, new Object[]{RemoteProcessesTreeModel.this.root, repos, updatedResponse}));
                            }
                        });
                    }
                }
                catch (Exception ex) {
                    LogService.getRoot().log(Level.WARNING, "Error fetching remote process list: " + ex, ex);
                    RemoteProcessesTreeModel.this.fireStructureChanged(new TreeModelEvent((Object)this, new TreePath(new Object[]{RemoteProcessesTreeModel.this.root, repos})));
                }
            }
        }
    }

    private class ProcessList {
        private List<Integer> knownIds = new LinkedList<Integer>();
        private Map<Integer, ProcessResponse> processResponses = new HashMap<Integer, ProcessResponse>();

        private ProcessList() {
        }

        public int add(ProcessResponse pr) {
            int newIndex = -1;
            if (!this.processResponses.containsKey(pr.getId())) {
                newIndex = this.knownIds.size();
                this.knownIds.add(pr.getId());
            }
            this.processResponses.put(pr.getId(), pr);
            return newIndex;
        }

        public ProcessResponse getByIndex(int index) {
            return this.processResponses.get(this.knownIds.get(index));
        }

        public ProcessResponse getById(int id) {
            return this.processResponses.get(id);
        }

        public int size() {
            return this.knownIds.size();
        }

        public int indexOf(ProcessResponse child) {
            int index = 0;
            for (Integer id : this.knownIds) {
                ProcessResponse pr = this.processResponses.get(id);
                if (pr != null && pr.getId() == child.getId()) {
                    return index;
                }
                ++index;
            }
            return -1;
        }

        private TreeModelEvent trim(Set<Integer> processIds, RemoteRepository repos) {
            LinkedList<Integer> removedIndices = new LinkedList<Integer>();
            LinkedList<ProcessResponse> removedObjects = new LinkedList<ProcessResponse>();
            Iterator<Integer> i = this.knownIds.iterator();
            int index = 0;
            while (i.hasNext()) {
                Integer id = i.next();
                if (!processIds.contains(id)) {
                    i.remove();
                    ProcessResponse process = this.processResponses.remove(id);
                    removedIndices.add(index);
                    removedObjects.add(process);
                }
                ++index;
            }
            if (!removedIndices.isEmpty()) {
                int[] indices = new int[removedIndices.size()];
                for (int j = 0; j < removedIndices.size(); ++j) {
                    indices[j] = (Integer)removedIndices.get(j);
                }
                return new TreeModelEvent((Object)this, new Object[]{RemoteProcessesTreeModel.this.root, repos}, indices, removedObjects.toArray());
            }
            return null;
        }
    }
}

