/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.repository.gui.process;

import com.rapid_i.repository.wsimport.ProcessResponse;
import com.rapid_i.repository.wsimport.Response;
import com.rapidminer.RepositoryProcessLocation;
import com.rapidminer.gui.MainFrame;
import com.rapidminer.gui.actions.OpenAction;
import com.rapidminer.gui.actions.RunRemoteAction;
import com.rapidminer.gui.tools.ExtendedJScrollPane;
import com.rapidminer.gui.tools.ResourceAction;
import com.rapidminer.gui.tools.ResourceDockKey;
import com.rapidminer.gui.tools.ResourceLabel;
import com.rapidminer.gui.tools.SwingTools;
import com.rapidminer.gui.tools.ViewToolBar;
import com.rapidminer.gui.tools.components.ToolTipWindow;
import com.rapidminer.repository.IOObjectEntry;
import com.rapidminer.repository.MalformedRepositoryLocationException;
import com.rapidminer.repository.RemoteProcessState;
import com.rapidminer.repository.Repository;
import com.rapidminer.repository.RepositoryException;
import com.rapidminer.repository.RepositoryLocation;
import com.rapidminer.repository.gui.RepositoryTree;
import com.rapidminer.repository.gui.ToolTipProviderHelper;
import com.rapidminer.repository.gui.process.OutputLocation;
import com.rapidminer.repository.gui.process.RemoteProcessTreeCellRenderer;
import com.rapidminer.repository.gui.process.RemoteProcessesTreeModel;
import com.rapidminer.repository.remote.RemoteRepository;
import com.rapidminer.tools.I18N;
import com.rapidminer.tools.LogService;
import com.vlsolutions.swing.docking.DockKey;
import com.vlsolutions.swing.docking.Dockable;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.DateFormat;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.logging.Level;
import javax.swing.Action;
import javax.swing.JComboBox;
import javax.swing.JPanel;
import javax.swing.JToolBar;
import javax.swing.JTree;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeExpansionListener;
import javax.swing.tree.TreePath;

public class RemoteProcessViewer
extends JPanel
implements Dockable {
    private static final long serialVersionUID = 1L;
    private JTree tree;
    private RemoteProcessesTreeModel treeModel;
    private Action STOP_ACTION = new ResourceAction(true, "remoteprocessviewer.stop", new Object[0]){
        private static final long serialVersionUID = 1L;

        @Override
        public void actionPerformed(ActionEvent e) {
            ProcessResponse processResponse;
            Object selection;
            TreePath selectionPath = RemoteProcessViewer.this.tree.getSelectionPath();
            if (selectionPath != null && (selection = selectionPath.getLastPathComponent()) instanceof ProcessResponse && !RemoteProcessState.valueOf((processResponse = (ProcessResponse)selection).getState()).isTerminated() && selectionPath.getLastPathComponent() instanceof ProcessResponse) {
                RemoteRepository repository = (RemoteRepository)selectionPath.getPath()[1];
                try {
                    Response stopResponse = repository.getProcessService().stopProcess(processResponse.getId());
                    if (stopResponse.getStatus() != 0) {
                        SwingTools.showVerySimpleErrorMessage("remoteprocessviewer.stop_failed", stopResponse.getErrorMessage());
                    }
                }
                catch (RepositoryException e1) {
                    SwingTools.showSimpleErrorMessage("remoteprocessviewer.stop_failed", (Throwable)e1, new Object[0]);
                }
            }
        }
    };
    private Action SHOW_LOG_ACTION = new ResourceAction(true, "remoteprocessviewer.show_log", new Object[0]){
        private static final long serialVersionUID = 1L;

        @Override
        public void actionPerformed(ActionEvent e) {
            Object selection;
            TreePath selectionPath = RemoteProcessViewer.this.tree.getSelectionPath();
            if (selectionPath != null && (selection = selectionPath.getLastPathComponent()) instanceof ProcessResponse) {
                ProcessResponse processResponse = (ProcessResponse)selection;
                if (selection instanceof ProcessResponse) {
                    RemoteRepository repository = (RemoteRepository)selectionPath.getPath()[1];
                    repository.showLog(processResponse.getId());
                }
            }
        }
    };
    private Action OPEN_ACTION = new ResourceAction(true, "remoteprocessviewer.open", new Object[0]){
        private static final long serialVersionUID = 1L;

        @Override
        public void actionPerformed(ActionEvent e) {
            TreePath selectionPath = RemoteProcessViewer.this.tree.getSelectionPath();
            if (selectionPath != null) {
                Object selection = selectionPath.getLastPathComponent();
                if (selection instanceof ProcessResponse) {
                    RepositoryLocation loc;
                    Repository repository = (Repository)selectionPath.getPath()[1];
                    String locStr = "//" + repository.getName() + ((ProcessResponse)selection).getProcessLocation();
                    try {
                        loc = new RepositoryLocation(locStr);
                    }
                    catch (MalformedRepositoryLocationException e1) {
                        SwingTools.showSimpleErrorMessage("while_loading", (Throwable)e1, locStr, e1.getMessage());
                        return;
                    }
                    OpenAction.open(new RepositoryProcessLocation(loc), true);
                } else if (selection instanceof OutputLocation) {
                    try {
                        Repository repository = (Repository)selectionPath.getPath()[1];
                        ProcessResponse proResponse = (ProcessResponse)selectionPath.getPath()[2];
                        RepositoryLocation procLoc = new RepositoryLocation("//" + repository.getName() + proResponse.getProcessLocation());
                        RepositoryLocation ioLoc = new RepositoryLocation(procLoc.parent(), ((OutputLocation)selection).getLocation());
                        RepositoryTree.showAsResult((IOObjectEntry)ioLoc.locateEntry());
                    }
                    catch (Exception e1) {
                        SwingTools.showSimpleErrorMessage("cannot_fetch_data_from_repository", (Throwable)e1, new Object[0]);
                    }
                }
            }
        }
    };
    private Action BROWSE_ACTION = new ResourceAction(true, "remoteprocessviewer.browse", new Object[0]){
        private static final long serialVersionUID = 1L;

        @Override
        public void actionPerformed(ActionEvent e) {
            TreePath selectionPath = RemoteProcessViewer.this.tree.getSelectionPath();
            if (selectionPath != null) {
                Object selection = selectionPath.getLastPathComponent();
                if (selection instanceof ProcessResponse) {
                    RemoteRepository repository = (RemoteRepository)selectionPath.getPath()[1];
                    repository.browse(((ProcessResponse)selection).getProcessLocation());
                } else if (selection instanceof OutputLocation) {
                    try {
                        RemoteRepository repository = (RemoteRepository)selectionPath.getPath()[1];
                        ProcessResponse proResponse = (ProcessResponse)selectionPath.getPath()[2];
                        RepositoryLocation procLoc = new RepositoryLocation("//" + repository.getName() + proResponse.getProcessLocation());
                        RepositoryLocation ioLoc = new RepositoryLocation(procLoc.parent(), ((OutputLocation)selection).getLocation());
                        repository.browse(ioLoc.getPath());
                    }
                    catch (Exception e1) {
                        SwingTools.showSimpleErrorMessage("cannot_fetch_data_from_repository", (Throwable)e1, new Object[0]);
                    }
                }
            }
        }
    };
    private Date sessionStartDate = new Date();
    private JComboBox sinceWhenCombo = new JComboBox<Object>(new Object[]{I18N.getMessage(I18N.getGUIBundle(), "gui.combo.remoteprocessviewer.since_session_start", new Object[0]), I18N.getMessage(I18N.getGUIBundle(), "gui.combo.remoteprocessviewer.for_today", new Object[0]), I18N.getMessage(I18N.getGUIBundle(), "gui.combo.remoteprocessviewer.all", new Object[0])});
    public static final String PROCESS_PANEL_DOCK_KEY = "remote_process_viewer";
    private final DockKey DOCK_KEY = new ResourceDockKey("remote_process_viewer");

    public RemoteProcessViewer() {
        this.DOCK_KEY.setDockGroup(MainFrame.DOCK_GROUP_ROOT);
        this.setLayout(new BorderLayout());
        this.treeModel = new RemoteProcessesTreeModel();
        this.treeModel.setSince(this.sessionStartDate);
        this.tree = new JTree(this.treeModel);
        this.tree.setCellRenderer(new RemoteProcessTreeCellRenderer());
        this.tree.setShowsRootHandles(true);
        this.tree.setRootVisible(false);
        ExtendedJScrollPane scrollPane = new ExtendedJScrollPane(this.tree);
        scrollPane.setBorder(null);
        this.add((Component)scrollPane, "Center");
        ViewToolBar toolBar = new ViewToolBar();
        this.add((Component)toolBar, "North");
        ((JToolBar)toolBar).add(new RunRemoteAction());
        ((JToolBar)toolBar).add(this.OPEN_ACTION);
        ((JToolBar)toolBar).add(this.BROWSE_ACTION);
        ((JToolBar)toolBar).add(this.STOP_ACTION);
        ((JToolBar)toolBar).add(this.SHOW_LOG_ACTION);
        toolBar.addSeparator();
        ResourceLabel label = new ResourceLabel("remoteprocessviewer.filter", new Object[0]);
        label.setLabelFor(this.sinceWhenCombo);
        ((Container)toolBar).add(label);
        ((Container)toolBar).add(this.sinceWhenCombo);
        new ToolTipWindow(new ToolTipWindow.TipProvider(){

            @Override
            public Component getCustomComponent(Object id) {
                if (id instanceof TreePath) {
                    RepositoryLocation loc = RemoteProcessViewer.this.getSelectedRepositoryLocation((TreePath)id);
                    if (loc != null) {
                        try {
                            return ToolTipProviderHelper.getCustomComponent(loc.locateEntry());
                        }
                        catch (RepositoryException e) {
                            LogService.getRoot().log(Level.WARNING, "Error locating entry for " + loc + ": " + e, e);
                            return null;
                        }
                    }
                    return null;
                }
                return null;
            }

            @Override
            public Object getIdUnder(Point point) {
                TreePath path = RemoteProcessViewer.this.tree.getPathForLocation((int)point.getX(), (int)point.getY());
                if (path != null) {
                    return path;
                }
                return null;
            }

            @Override
            public String getTip(Object o) {
                if (o instanceof TreePath) {
                    Object last = ((TreePath)o).getLastPathComponent();
                    if (last instanceof ProcessResponse) {
                        ProcessResponse pr = (ProcessResponse)last;
                        StringBuilder b = new StringBuilder();
                        b.append("<html><body>");
                        b.append("<strong>").append(pr.getProcessLocation()).append("</strong> ");
                        if (RemoteProcessState.valueOf(pr.getState()) == RemoteProcessState.FAILED) {
                            b.append("<span style=\"color:red\">(").append(pr.getState().toLowerCase()).append(")</span><br/>");
                        } else {
                            b.append("(").append(pr.getState().toLowerCase()).append(")<br/>");
                        }
                        if (pr.getStartTime() != null) {
                            b.append("<em>Started: </em>").append(DateFormat.getDateTimeInstance().format(pr.getStartTime().toGregorianCalendar().getTime())).append("<br/>");
                        }
                        if (pr.getCompletionTime() != null) {
                            b.append("<em>Completed: </em>").append(DateFormat.getDateTimeInstance().format(pr.getCompletionTime().toGregorianCalendar().getTime())).append("<br/>");
                        }
                        if (pr.getException() != null) {
                            b.append("<span style=\"color:red\">").append(pr.getException()).append("</span><br/>");
                        }
                        RemoteRepository repos = (RemoteRepository)((TreePath)o).getPath()[1];
                        b.append("<a href=\"" + repos.getProcessLogURI(pr.getId()).toString() + "\">View Log</a>");
                        b.append("</body></html>");
                        return b.toString();
                    }
                    RepositoryLocation loc = RemoteProcessViewer.this.getSelectedRepositoryLocation((TreePath)o);
                    if (loc != null) {
                        try {
                            return ToolTipProviderHelper.getTip(loc.locateEntry());
                        }
                        catch (RepositoryException e) {
                            LogService.getRoot().log(Level.WARNING, "Error locating entry for " + loc + ": " + e, e);
                            return null;
                        }
                    }
                    return null;
                }
                return null;
            }
        }, this.tree);
        this.sinceWhenCombo.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                switch (RemoteProcessViewer.this.sinceWhenCombo.getSelectedIndex()) {
                    case 0: {
                        RemoteProcessViewer.this.treeModel.setSince(RemoteProcessViewer.this.sessionStartDate);
                        break;
                    }
                    case 1: {
                        GregorianCalendar today = new GregorianCalendar();
                        today.set(11, 0);
                        today.set(12, 0);
                        today.set(13, 0);
                        today.set(14, 0);
                        RemoteProcessViewer.this.treeModel.setSince(today.getTime());
                        break;
                    }
                    case 2: {
                        RemoteProcessViewer.this.treeModel.setSince(null);
                    }
                }
            }
        });
        this.tree.addTreeExpansionListener(new TreeExpansionListener(){

            @Override
            public void treeExpanded(TreeExpansionEvent event) {
                Object leaf = event.getPath().getLastPathComponent();
                if (leaf instanceof RemoteRepository) {
                    RemoteProcessViewer.this.treeModel.observe((RemoteRepository)leaf);
                }
            }

            @Override
            public void treeCollapsed(TreeExpansionEvent event) {
                Object leaf = event.getPath().getLastPathComponent();
                if (leaf instanceof RemoteRepository) {
                    RemoteProcessViewer.this.treeModel.ignore((RemoteRepository)leaf);
                }
            }
        });
    }

    private RepositoryLocation getSelectedRepositoryLocation(TreePath selectionPath) {
        try {
            if (selectionPath != null) {
                Object selection = selectionPath.getLastPathComponent();
                if (selection instanceof ProcessResponse) {
                    Repository repository = (Repository)selectionPath.getPath()[1];
                    return new RepositoryLocation("//" + repository.getName() + ((ProcessResponse)selection).getProcessLocation());
                }
                if (selection instanceof OutputLocation) {
                    Repository repository = (Repository)selectionPath.getPath()[1];
                    ProcessResponse proResponse = (ProcessResponse)selectionPath.getPath()[2];
                    RepositoryLocation procLoc = new RepositoryLocation("//" + repository.getName() + proResponse.getProcessLocation());
                    return new RepositoryLocation(procLoc.parent(), ((OutputLocation)selection).getLocation());
                }
            }
        }
        catch (MalformedRepositoryLocationException e) {
            return null;
        }
        return null;
    }

    public Component getComponent() {
        return this;
    }

    public DockKey getDockKey() {
        return this.DOCK_KEY;
    }
}

