/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.repository.gui;

import com.michaelbaranov.microba.calendar.DatePicker;
import com.rapid_i.repository.wsimport.ExecutionResponse;
import com.rapid_i.repository.wsimport.MacroDefinition;
import com.rapid_i.repository.wsimport.ProcessContextWrapper;
import com.rapidminer.Process;
import com.rapidminer.ProcessContext;
import com.rapidminer.ProcessLocation;
import com.rapidminer.RepositoryProcessLocation;
import com.rapidminer.gui.processeditor.ProcessContextEditor;
import com.rapidminer.gui.tools.ResourceAction;
import com.rapidminer.gui.tools.ResourceLabel;
import com.rapidminer.gui.tools.ResourceTabbedPane;
import com.rapidminer.gui.tools.SwingTools;
import com.rapidminer.gui.tools.dialogs.ButtonDialog;
import com.rapidminer.io.process.XMLTools;
import com.rapidminer.repository.Repository;
import com.rapidminer.repository.RepositoryException;
import com.rapidminer.repository.RepositoryLocation;
import com.rapidminer.repository.RepositoryManager;
import com.rapidminer.repository.gui.RepositoryBrowser;
import com.rapidminer.repository.gui.RepositoryLocationChooser;
import com.rapidminer.repository.remote.RemoteRepository;
import com.rapidminer.tools.Observable;
import com.rapidminer.tools.Observer;
import com.rapidminer.tools.container.Pair;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.DateFormat;
import java.util.Date;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.xml.datatype.XMLGregorianCalendar;

public class RunRemoteDialog
extends ButtonDialog {
    private static final long serialVersionUID = 1L;
    private static final DateFormat DATE_FORMAT = DateFormat.getDateTimeInstance();
    private final DatePicker dateField = new DatePicker(new Date(), DATE_FORMAT);
    private final JTextField cronField = new JTextField(30);
    private final JComboBox repositoryBox = new JComboBox();
    private static int lastRepositoryIndexSelected = 0;
    private final JLabel dateLabel = new ResourceLabel("runremotedialog.date", new Object[0]);
    private final JLabel cronLabel = new ResourceLabel("runremotedialog.cronexpression", new Object[0]);
    private final JCheckBox startBox = new JCheckBox(new ResourceAction("runremotedialog.cronstart", new Object[0]){
        private static final long serialVersionUID = 1L;

        @Override
        public void actionPerformed(ActionEvent e) {
            RunRemoteDialog.this.enableComponents();
        }
    });
    private final DatePicker startField = new DatePicker(new Date(), DATE_FORMAT);
    private final DatePicker endField = new DatePicker(new Date(), DATE_FORMAT);
    private final JCheckBox endBox = new JCheckBox(new ResourceAction("runremotedialog.cronend", new Object[0]){
        private static final long serialVersionUID = 1L;

        @Override
        public void actionPerformed(ActionEvent e) {
            RunRemoteDialog.this.enableComponents();
        }
    });
    private final JTextField processField = new JTextField(30);
    private JRadioButton nowButton;
    private JRadioButton onceButton;
    private JRadioButton cronButton;
    private final ResourceTabbedPane tabs = new ResourceTabbedPane("runremotedialog");
    private ProcessContext context = new ProcessContext();

    public RunRemoteDialog(Process process) {
        super("runremotedialog", true, new Object[0]);
        this.setModal(true);
        this.dateField.setStripTime(false);
        this.dateField.setKeepTime(true);
        this.startField.setStripTime(false);
        this.startField.setKeepTime(true);
        this.endField.setStripTime(false);
        this.endField.setKeepTime(true);
        this.startBox.setSelected(false);
        this.endBox.setSelected(false);
        ProcessLocation processLocation = process.getProcessLocation();
        if (processLocation != null && processLocation instanceof RepositoryProcessLocation) {
            this.processField.setText(((RepositoryProcessLocation)processLocation).getRepositoryLocation().getPath());
        } else {
            this.processField.setText("");
        }
        this.processField.selectAll();
        final JButton okButton = this.makeOkButton();
        JButton cancelButton = this.makeCancelButton();
        this.repositoryBox.setModel(new DefaultComboBoxModel<Object>(RepositoryManager.getInstance(null).getRemoteRepositories().toArray()));
        if (this.repositoryBox.getItemCount() < lastRepositoryIndexSelected) {
            lastRepositoryIndexSelected = 0;
        }
        this.repositoryBox.setSelectedIndex(lastRepositoryIndexSelected);
        this.repositoryBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                okButton.setEnabled(RunRemoteDialog.this.repositoryBox.getSelectedItem() != null);
                lastRepositoryIndexSelected = RunRemoteDialog.this.repositoryBox.getSelectedIndex();
            }
        });
        RepositoryManager.getInstance(null).addObserver(new Observer<Repository>(){

            @Override
            public void update(Observable<Repository> observable, Repository arg) {
                RunRemoteDialog.this.repositoryBox.setModel(new DefaultComboBoxModel<Object>(RepositoryManager.getInstance(null).getRemoteRepositories().toArray()));
                if (arg != null && arg instanceof RemoteRepository) {
                    RunRemoteDialog.this.repositoryBox.setSelectedItem(arg);
                }
                RunRemoteDialog.this.pack();
            }
        }, true);
        JPanel schedulePanel = this.makeSchedulePanel();
        ProcessContextEditor contextPanel = new ProcessContextEditor(process, this.context);
        this.tabs.addTabI18N("schedule", schedulePanel, new String[0]);
        this.tabs.addTabI18N("context", contextPanel, new String[0]);
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(this.nowButton);
        buttonGroup.add(this.onceButton);
        buttonGroup.add(this.cronButton);
        this.nowButton.setSelected(true);
        this.layoutDefault((JComponent)this.tabs, 1, okButton, cancelButton);
        this.enableComponents();
        okButton.setEnabled(this.repositoryBox.getSelectedItem() != null);
    }

    private JPanel makeSchedulePanel() {
        GridBagConstraints c = new GridBagConstraints();
        c.anchor = 23;
        c.fill = 1;
        c.gridwidth = 0;
        c.weightx = 1.0;
        c.weighty = 0.0;
        JPanel repositoryPanel = new JPanel(new GridBagLayout());
        c.insets = new Insets(0, 6, 0, 6);
        ResourceLabel label = new ResourceLabel("runremotedialog.repository", new Object[0]);
        label.setLabelFor(this.repositoryBox);
        c.insets = new Insets(6, 6, 6, 6);
        repositoryPanel.add((Component)label, c);
        c.gridwidth = -1;
        c.insets = new Insets(0, 6, 6, 0);
        repositoryPanel.add((Component)this.repositoryBox, c);
        JButton addRepositoryButton = new JButton(RepositoryBrowser.ADD_REPOSITORY_ACTION);
        addRepositoryButton.setText("");
        c.weightx = 0.0;
        c.gridwidth = 0;
        c.insets = new Insets(0, 0, 6, 6);
        repositoryPanel.add((Component)addRepositoryButton, c);
        label = new ResourceLabel("runremotedialog.process_location", new Object[0]);
        label.setLabelFor(this.processField);
        c.weightx = 1.0;
        c.insets = new Insets(6, 6, 0, 6);
        repositoryPanel.add((Component)label, c);
        c.gridwidth = -1;
        c.insets = new Insets(0, 6, 6, 0);
        repositoryPanel.add((Component)this.processField, c);
        JButton selectButton = new JButton(new ResourceAction(true, "repository_select_location", new Object[0]){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent e) {
                String selected = RepositoryLocationChooser.selectLocation(null, RunRemoteDialog.this);
                if (selected != null) {
                    try {
                        RepositoryLocation location = new RepositoryLocation(selected);
                        Repository repository = location.getRepository();
                        String relative = location.getPath();
                        RunRemoteDialog.this.repositoryBox.setSelectedItem(repository);
                        RunRemoteDialog.this.processField.setText(relative);
                    }
                    catch (Exception ex) {
                        RunRemoteDialog.this.processField.setText(selected);
                    }
                    RunRemoteDialog.this.processField.selectAll();
                }
            }
        });
        selectButton.setText("");
        c.weightx = 0.0;
        c.gridwidth = 0;
        c.insets = new Insets(0, 0, 6, 6);
        repositoryPanel.add((Component)selectButton, c);
        c.gridwidth = 0;
        c.fill = 1;
        c.weighty = 1.0;
        JPanel dummy = new JPanel();
        repositoryPanel.add((Component)dummy, c);
        JPanel schedPanel = new JPanel(new GridBagLayout());
        this.nowButton = new JRadioButton(new ResourceAction("runremotedialog.now", new Object[0]){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent e) {
                RunRemoteDialog.this.enableComponents();
            }
        });
        c.weightx = 1.0;
        c.insets = new Insets(6, 6, 6, 6);
        c.gridwidth = 0;
        schedPanel.add((Component)this.nowButton, c);
        this.onceButton = new JRadioButton(new ResourceAction("runremotedialog.once", new Object[0]){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent e) {
                RunRemoteDialog.this.enableComponents();
            }
        });
        c.insets = new Insets(18, 6, 6, 6);
        c.gridwidth = 0;
        schedPanel.add((Component)this.onceButton, c);
        this.dateLabel.setLabelFor((Component)this.dateField);
        c.insets = new Insets(0, 48, 0, 6);
        c.gridwidth = 0;
        schedPanel.add((Component)this.dateLabel, c);
        c.insets = new Insets(0, 48, 6, 6);
        schedPanel.add((Component)this.dateField, c);
        this.cronButton = new JRadioButton(new ResourceAction("runremotedialog.cron", new Object[0]){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent e) {
                RunRemoteDialog.this.enableComponents();
            }
        });
        c.insets = new Insets(18, 6, 6, 6);
        c.gridwidth = 0;
        schedPanel.add((Component)this.cronButton, c);
        c.insets = new Insets(0, 48, 0, 6);
        this.cronLabel.setLabelFor(this.cronField);
        schedPanel.add((Component)this.cronLabel, c);
        c.insets = new Insets(0, 48, 6, 0);
        c.gridwidth = -1;
        schedPanel.add((Component)this.cronField, c);
        c.insets = new Insets(0, 0, 6, 6);
        JButton cronHelpButton = new JButton(new ResourceAction(true, "cron_help", new Object[0]){
            private static final long serialVersionUID = 1L;
            {
                this.putValue("Name", "");
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                SwingTools.showMessageDialog("cron_long_help", new Object[0]);
            }
        });
        c.weightx = 0.0;
        c.gridwidth = 0;
        schedPanel.add((Component)cronHelpButton, c);
        c.weightx = 1.0;
        c.insets = new Insets(6, 48, 0, 6);
        schedPanel.add((Component)this.startBox, c);
        c.insets = new Insets(0, 48, 6, 6);
        schedPanel.add((Component)this.startField, c);
        c.insets = new Insets(6, 48, 0, 6);
        schedPanel.add((Component)this.endBox, c);
        c.insets = new Insets(0, 48, 6, 6);
        schedPanel.add((Component)this.endField, c);
        JPanel panel = new JPanel(RunRemoteDialog.createGridLayout(1, 2));
        panel.add(repositoryPanel);
        panel.add(schedPanel);
        return panel;
    }

    private void enableComponents() {
        this.dateLabel.setEnabled(this.onceButton.isSelected());
        this.dateField.setEnabled(this.onceButton.isSelected());
        this.cronLabel.setEnabled(this.cronButton.isSelected());
        this.cronField.setEnabled(this.cronButton.isSelected());
        this.startBox.setEnabled(this.cronButton.isSelected());
        this.endBox.setEnabled(this.cronButton.isSelected());
        this.startField.setEnabled(this.cronButton.isSelected() && this.startBox.isSelected());
        this.endField.setEnabled(this.cronButton.isSelected() && this.endBox.isSelected());
    }

    public static void showDialog(Process process) {
        RunRemoteDialog d = new RunRemoteDialog(process);
        d.setVisible(true);
    }

    @Override
    public void ok() {
        RemoteRepository repos = (RemoteRepository)this.repositoryBox.getSelectedItem();
        if (repos != null) {
            ExecutionResponse response;
            String location = this.processField.getText();
            ProcessContextWrapper pcWrapper = new ProcessContextWrapper();
            for (String string : this.context.getInputRepositoryLocations()) {
                pcWrapper.getInputRepositoryLocations().add(string);
            }
            for (String string : this.context.getOutputRepositoryLocations()) {
                pcWrapper.getOutputRepositoryLocations().add(string);
            }
            for (Pair pair : this.context.getMacros()) {
                MacroDefinition macroDef = new MacroDefinition();
                macroDef.setKey((String)pair.getFirst());
                macroDef.setKey((String)pair.getSecond());
                pcWrapper.getMacros().add(macroDef);
            }
            if (this.nowButton.isSelected()) {
                try {
                    response = repos.getProcessService().executeProcessSimple(location, null, pcWrapper);
                }
                catch (RepositoryException repositoryException) {
                    SwingTools.showSimpleErrorMessage("error_connecting_to_server", (Throwable)repositoryException, new Object[0]);
                    return;
                }
            } else if (this.onceButton.isSelected()) {
                try {
                    Date date = this.dateField.getDate();
                    response = repos.getProcessService().executeProcessSimple(location, XMLTools.getXMLGregorianCalendar(date), pcWrapper);
                }
                catch (RepositoryException repositoryException) {
                    SwingTools.showSimpleErrorMessage("error_connecting_to_server", (Throwable)repositoryException, new Object[0]);
                    return;
                }
            } else if (this.cronButton.isSelected()) {
                try {
                    XMLGregorianCalendar xMLGregorianCalendar = this.startBox.isSelected() ? XMLTools.getXMLGregorianCalendar(this.startField.getDate()) : null;
                    XMLGregorianCalendar end = this.endBox.isSelected() ? XMLTools.getXMLGregorianCalendar(this.endField.getDate()) : null;
                    response = repos.getProcessService().executeProcessCron(location, this.cronField.getText(), xMLGregorianCalendar, end, pcWrapper);
                }
                catch (RepositoryException repositoryException) {
                    SwingTools.showSimpleErrorMessage("error_connecting_to_server ", (Throwable)repositoryException, new Object[0]);
                    return;
                }
            } else {
                throw new RuntimeException("No radio button selected. (This cannot happen)");
            }
            if (response.getStatus() != 0) {
                SwingTools.showSimpleErrorMessage("run_proc_remote", response.getErrorMessage(), new Object[0]);
            } else {
                this.dispose();
                Date date = response.getFirstExecution().toGregorianCalendar().getTime();
                JOptionPane.showMessageDialog(this, "Process will first run on: " + date, "Process scheduled", 1);
            }
        }
    }
}

