/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.repository.gui;

import com.rapidminer.gui.tools.SwingTools;
import com.rapidminer.repository.Entry;
import com.rapidminer.repository.Folder;
import com.rapidminer.repository.Repository;
import com.rapidminer.repository.RepositoryException;
import com.rapidminer.repository.RepositoryListener;
import com.rapidminer.repository.RepositoryManager;
import com.rapidminer.tools.LogService;
import com.rapidminer.tools.Observable;
import com.rapidminer.tools.Observer;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import javax.swing.SwingUtilities;
import javax.swing.event.EventListenerList;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;

public class RepositoryTreeModel
implements TreeModel {
    private final RepositoryManager root;
    private final EventListenerList listeners = new EventListenerList();
    private final RepositoryListener repositoryListener = new RepositoryListener(){

        private TreeModelEvent makeChangeEvent(Entry entry) {
            TreePath path = RepositoryTreeModel.this.getPathTo(entry.getContainingFolder());
            int index = entry instanceof Repository ? RepositoryManager.getInstance(null).getRepositories().indexOf(entry) : RepositoryTreeModel.this.getIndexOfChild(entry.getContainingFolder(), entry);
            return new TreeModelEvent((Object)RepositoryTreeModel.this, path, new int[]{index}, new Object[]{entry});
        }

        @Override
        public void entryAdded(Entry newEntry, Folder parent) {
            TreeModelEvent e = this.makeChangeEvent(newEntry);
            for (TreeModelListener l : (TreeModelListener[])RepositoryTreeModel.this.listeners.getListeners(TreeModelListener.class)) {
                l.treeNodesInserted(e);
            }
        }

        @Override
        public void entryRemoved(Entry removedEntry, Folder parent, int index) {
            TreePath path = RepositoryTreeModel.this.getPathTo(parent);
            TreeModelEvent e = new TreeModelEvent((Object)RepositoryTreeModel.this, path, new int[]{index}, new Object[]{removedEntry});
            for (TreeModelListener l : (TreeModelListener[])RepositoryTreeModel.this.listeners.getListeners(TreeModelListener.class)) {
                l.treeNodesRemoved(e);
            }
        }

        @Override
        public void entryRenamed(Entry entry) {
            TreeModelEvent e = this.makeChangeEvent(entry);
            for (TreeModelListener l : (TreeModelListener[])RepositoryTreeModel.this.listeners.getListeners(TreeModelListener.class)) {
                l.treeNodesChanged(e);
            }
        }

        @Override
        public void folderRefreshed(Folder folder) {
            TreeModelEvent e = this.makeChangeEvent(folder);
            for (TreeModelListener l : (TreeModelListener[])RepositoryTreeModel.this.listeners.getListeners(TreeModelListener.class)) {
                l.treeStructureChanged(e);
            }
        }
    };
    private final Set<Folder> pendingFolders = new HashSet<Folder>();

    public RepositoryTreeModel(final RepositoryManager root) {
        this.root = root;
        for (Repository repository : root.getRepositories()) {
            repository.addRepositoryListener(this.repositoryListener);
        }
        root.addObserver(new Observer<Repository>(){

            @Override
            public void update(Observable<Repository> observable, Repository arg) {
                for (Repository repository : root.getRepositories()) {
                    repository.removeRepositoryListener(RepositoryTreeModel.this.repositoryListener);
                    repository.addRepositoryListener(RepositoryTreeModel.this.repositoryListener);
                }
                TreeModelEvent e = new TreeModelEvent((Object)this, new TreePath(root));
                for (TreeModelListener l : (TreeModelListener[])RepositoryTreeModel.this.listeners.getListeners(TreeModelListener.class)) {
                    l.treeStructureChanged(e);
                }
            }
        }, true);
    }

    TreePath getPathTo(Entry entry) {
        if (entry == null) {
            return new TreePath(this.root);
        }
        if (entry.getContainingFolder() == null) {
            return new TreePath(this.root).pathByAddingChild(entry);
        }
        return this.getPathTo(entry.getContainingFolder()).pathByAddingChild(entry);
    }

    @Override
    public void addTreeModelListener(TreeModelListener l) {
        this.listeners.add(TreeModelListener.class, l);
    }

    @Override
    public void removeTreeModelListener(TreeModelListener l) {
        this.listeners.remove(TreeModelListener.class, l);
    }

    @Override
    public Object getChild(Object parent, int index) {
        if (parent instanceof RepositoryManager) {
            return ((RepositoryManager)parent).getRepositories().get(index);
        }
        if (parent instanceof Folder) {
            Folder folder = (Folder)parent;
            if (folder.willBlock()) {
                this.unblock(folder);
                return "Pending...";
            }
            try {
                int numFolders = folder.getSubfolders().size();
                if (index < numFolders) {
                    return folder.getSubfolders().get(index);
                }
                return folder.getDataEntries().get(index - numFolders);
            }
            catch (RepositoryException e) {
                LogService.getRoot().log(Level.WARNING, "Cannot get children of " + folder.getName() + ": " + e, e);
                return null;
            }
        }
        return null;
    }

    private void unblock(final Folder folder) {
        if (this.pendingFolders.contains(folder)) {
            return;
        }
        this.pendingFolders.add(folder);
        new Thread("wait-for-" + folder.getName()){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                LinkedList<Entry> children = new LinkedList<Entry>();
                try {
                    children.addAll(folder.getSubfolders());
                    children.addAll(folder.getDataEntries());
                }
                catch (Exception e) {
                    try {
                        SwingTools.showSimpleErrorMessage("error_fetching_folder_contents_from_server", (Throwable)e, new Object[0]);
                    }
                    catch (Throwable throwable) {
                        SwingUtilities.invokeLater(new Runnable(children){
                            final /* synthetic */ List val$children;
                            {
                                this.val$children = list;
                            }

                            @Override
                            public void run() {
                                TreeModelEvent removeEvent = new TreeModelEvent((Object)RepositoryTreeModel.this, RepositoryTreeModel.this.getPathTo(folder), new int[]{0}, new Object[]{"Pending..."});
                                for (TreeModelListener l : (TreeModelListener[])RepositoryTreeModel.this.listeners.getListeners(TreeModelListener.class)) {
                                    l.treeNodesRemoved(removeEvent);
                                }
                                int[] index = new int[this.val$children.size()];
                                for (int i = 0; i < index.length; ++i) {
                                    index[i] = i;
                                }
                                Object[] childArray = this.val$children.toArray();
                                TreeModelEvent insertEvent = new TreeModelEvent((Object)RepositoryTreeModel.this, RepositoryTreeModel.this.getPathTo(folder), index, childArray);
                                for (TreeModelListener l : (TreeModelListener[])RepositoryTreeModel.this.listeners.getListeners(TreeModelListener.class)) {
                                    l.treeNodesInserted(insertEvent);
                                }
                            }
                        });
                        throw throwable;
                    }
                    SwingUtilities.invokeLater(new /* invalid duplicate definition of identical inner class */);
                }
                SwingUtilities.invokeLater(new /* invalid duplicate definition of identical inner class */);
            }
        }.start();
    }

    @Override
    public int getChildCount(Object parent) {
        if (parent instanceof RepositoryManager) {
            return ((RepositoryManager)parent).getRepositories().size();
        }
        if (parent instanceof Folder) {
            Folder folder = (Folder)parent;
            if (folder.willBlock()) {
                this.unblock(folder);
                return 1;
            }
            try {
                return folder.getSubfolders().size() + folder.getDataEntries().size();
            }
            catch (RepositoryException e) {
                LogService.getRoot().log(Level.WARNING, "Cannot get child count for " + folder.getName() + ": " + e, e);
                return 0;
            }
        }
        return 0;
    }

    @Override
    public int getIndexOfChild(Object parent, Object child) {
        if (parent instanceof RepositoryManager) {
            return ((RepositoryManager)parent).getRepositories().indexOf(child);
        }
        if (parent instanceof Folder) {
            Folder folder = (Folder)parent;
            try {
                if (child instanceof Folder) {
                    return folder.getSubfolders().indexOf(child);
                }
                if (child instanceof Entry) {
                    return folder.getDataEntries().indexOf(child) + folder.getSubfolders().size();
                }
                return -1;
            }
            catch (RepositoryException e) {
                LogService.getRoot().log(Level.WARNING, "Cannot get child index for " + folder.getName() + ": " + e, e);
                return -1;
            }
        }
        return -1;
    }

    @Override
    public Object getRoot() {
        return this.root;
    }

    @Override
    public boolean isLeaf(Object node) {
        return !(node instanceof Folder) && !(node instanceof RepositoryManager);
    }

    @Override
    public void valueForPathChanged(TreePath path, Object newValue) {
        try {
            ((Entry)path.getLastPathComponent()).rename(newValue.toString());
        }
        catch (Exception e) {
            SwingTools.showSimpleErrorMessage("error_rename", (Throwable)e, e.toString());
        }
    }
}

