/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.repository.gui;

import com.rapidminer.gui.renderer.RendererService;
import com.rapidminer.gui.tools.SwingTools;
import com.rapidminer.repository.BlobEntry;
import com.rapidminer.repository.DataEntry;
import com.rapidminer.repository.Entry;
import com.rapidminer.repository.IOObjectEntry;
import com.rapidminer.repository.Repository;
import com.rapidminer.tools.Tools;
import java.awt.Component;
import java.text.DateFormat;
import java.util.Date;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JTree;
import javax.swing.tree.DefaultTreeCellRenderer;

public class RepositoryTreeCellRenderer
extends DefaultTreeCellRenderer {
    private static final long serialVersionUID = 1L;
    private static final Icon ICON_SERVER = SwingTools.createIcon("16/server.png");
    private static final Icon ICON_FOLDER_OPEN = SwingTools.createIcon("16/folder.png");
    private static final Icon ICON_FOLDER_CLOSED = SwingTools.createIcon("16/folder_closed.png");
    private static final Icon ICON_FOLDER_LOCKED = SwingTools.createIcon("16/folder_lock.png");
    private static final Icon ICON_PROCESS = SwingTools.createIcon("16/gear.png");
    private static final Icon ICON_DATA = SwingTools.createIcon("16/data.png");
    private static final Icon ICON_BLOB = SwingTools.createIcon("16/data.png");
    private static final Icon ICON_TEXT = SwingTools.createIcon("16/text.png");
    private static final Icon ICON_TABLE = SwingTools.createIcon("16/table2.png");
    private static final Icon ICON_IMAGE = SwingTools.createIcon("16/photo_landscape2.png");
    private static final DateFormat DATE_FORMAT = DateFormat.getDateTimeInstance(3, 3);

    @Override
    public Component getTreeCellRendererComponent(JTree tree, Object value, boolean sel, boolean expanded, boolean leaf, int row, boolean hasFocus) {
        JLabel label = (JLabel)super.getTreeCellRendererComponent(tree, value, sel, expanded, leaf, row, hasFocus);
        if (value instanceof Entry) {
            String reposState;
            Entry entry = (Entry)value;
            String state = "";
            if (entry instanceof Repository && (reposState = ((Repository)entry).getState()) != null) {
                state = state + reposState + " &ndash; ";
            }
            state = state + entry.getOwner();
            if (entry instanceof DataEntry) {
                long size;
                state = state + "  &ndash; v" + ((DataEntry)entry).getRevision();
                long date = ((DataEntry)entry).getDate();
                if (date >= 0L) {
                    state = state + ", " + DATE_FORMAT.format(new Date(date));
                }
                if ((size = ((DataEntry)entry).getSize()) >= 0L) {
                    state = state + " &ndash; " + Tools.formatBytes(size);
                }
            }
            label.setText("<html>" + entry.getName() + " <small style=\"color:gray\">(" + state + ")</small></html>");
            if (entry instanceof Repository) {
                label.setIcon(ICON_SERVER);
            } else if (entry.getType().equals("folder")) {
                if (entry.isReadOnly()) {
                    label.setIcon(ICON_FOLDER_LOCKED);
                } else if (expanded) {
                    label.setIcon(ICON_FOLDER_OPEN);
                } else {
                    label.setIcon(ICON_FOLDER_CLOSED);
                }
            } else if (entry.getType().equals("data")) {
                if (entry instanceof IOObjectEntry) {
                    IOObjectEntry dataEntry = (IOObjectEntry)entry;
                    label.setIcon(RendererService.getIcon(dataEntry.getObjectClass()));
                } else {
                    label.setIcon(ICON_DATA);
                }
            } else if (entry.getType().equals("process")) {
                label.setIcon(ICON_PROCESS);
            } else if (entry.getType().equals("blob")) {
                String mimeType = ((BlobEntry)entry).getMimeType();
                if (mimeType != null) {
                    if (mimeType.startsWith("text/") || "application/pdf".equals(mimeType) || "application/rtf".equals(mimeType)) {
                        label.setIcon(ICON_TEXT);
                    } else if (mimeType.equals("application/msexcel")) {
                        label.setIcon(ICON_TABLE);
                    } else if (mimeType.startsWith("image/")) {
                        label.setIcon(ICON_IMAGE);
                    } else {
                        label.setIcon(ICON_BLOB);
                    }
                } else {
                    label.setIcon(ICON_BLOB);
                }
            } else {
                label.setIcon(null);
            }
        }
        return label;
    }
}

