/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.repository.gui;

import com.rapidminer.Process;
import com.rapidminer.RepositoryProcessLocation;
import com.rapidminer.gui.RapidMinerGUI;
import com.rapidminer.gui.actions.OpenAction;
import com.rapidminer.gui.dnd.TransferableOperator;
import com.rapidminer.gui.operatortree.actions.CutCopyPasteAction;
import com.rapidminer.gui.tools.ProgressThread;
import com.rapidminer.gui.tools.ResourceAction;
import com.rapidminer.gui.tools.SwingTools;
import com.rapidminer.gui.tools.components.ToolTipWindow;
import com.rapidminer.gui.tools.dialogs.wizards.dataimport.DataImportWizard;
import com.rapidminer.operator.ResultObject;
import com.rapidminer.repository.DataEntry;
import com.rapidminer.repository.Entry;
import com.rapidminer.repository.Folder;
import com.rapidminer.repository.IOObjectEntry;
import com.rapidminer.repository.ProcessEntry;
import com.rapidminer.repository.Repository;
import com.rapidminer.repository.RepositoryException;
import com.rapidminer.repository.RepositoryLocation;
import com.rapidminer.repository.RepositoryManager;
import com.rapidminer.repository.gui.RepositoryConfigurationDialog;
import com.rapidminer.repository.gui.RepositorySelectionEvent;
import com.rapidminer.repository.gui.RepositorySelectionListener;
import com.rapidminer.repository.gui.RepositoryTreeCellRenderer;
import com.rapidminer.repository.gui.RepositoryTreeModel;
import com.rapidminer.repository.gui.ToolTipProviderHelper;
import com.rapidminer.tools.LogService;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.ClipboardOwner;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.logging.Level;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.JPopupMenu;
import javax.swing.JTree;
import javax.swing.TransferHandler;
import javax.swing.event.EventListenerList;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeExpansionListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.TreePath;

public class RepositoryTree
extends JTree {
    private static final long serialVersionUID = -6613576606220873341L;
    public final AbstractRepositoryAction<Repository> CONFIGURE_ACTION = new AbstractRepositoryAction<Repository>(Repository.class, false, "configure_repository"){
        private static final long serialVersionUID = 1L;

        @Override
        public void actionPerformed(Repository repository) {
            new RepositoryConfigurationDialog(repository).setVisible(true);
        }
    };
    public final AbstractRepositoryAction<Entry> COPY_LOCATION_ACTION = new AbstractRepositoryAction<Entry>(Entry.class, false, "repository_copy_location"){
        private static final long serialVersionUID = 1L;

        @Override
        public void actionPerformed(Entry e) {
            String value = e.getLocation().toString();
            Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
            clipboard.setContents(new StringSelection(value), new ClipboardOwner(){

                @Override
                public void lostOwnership(Clipboard clipboard, Transferable contents) {
                }
            });
        }
    };
    public final AbstractRepositoryAction<DataEntry> OPEN_ACTION = new AbstractRepositoryAction<DataEntry>(DataEntry.class, false, "open_repository_entry"){
        private static final long serialVersionUID = 1L;

        @Override
        public void actionPerformed(DataEntry data) {
            if (data instanceof IOObjectEntry) {
                RepositoryTree.showAsResult((IOObjectEntry)data);
            } else if (data instanceof ProcessEntry) {
                RepositoryTree.openProcess((ProcessEntry)data);
            }
        }
    };
    public final AbstractRepositoryAction<Folder> REFRESH_ACTION = new AbstractRepositoryAction<Folder>(Folder.class, false, "repository_refresh_folder"){
        private static final long serialVersionUID = 1L;

        @Override
        public void actionPerformed(final Folder folder) {
            ProgressThread openProgressThread = new ProgressThread("refreshing"){

                @Override
                public void run() {
                    try {
                        folder.refresh();
                    }
                    catch (Exception e) {
                        SwingTools.showSimpleErrorMessage("cannot_refresh_folder", (Throwable)e, new Object[0]);
                    }
                }
            };
            openProgressThread.start();
        }
    };
    public final AbstractRepositoryAction<Folder> CREATE_FOLDER_ACTION = new AbstractRepositoryAction<Folder>(Folder.class, true, "repository_create_folder"){
        private static final long serialVersionUID = 1L;

        @Override
        public void actionPerformed(final Folder folder) {
            ProgressThread openProgressThread = new ProgressThread("create_folder"){

                @Override
                public void run() {
                    String name = SwingTools.showInputDialog("repository.new_folder", "", new Object[0]);
                    if (name != null) {
                        try {
                            folder.createFolder(name);
                        }
                        catch (Exception e) {
                            SwingTools.showSimpleErrorMessage("cannot_create_folder", (Throwable)e, name);
                        }
                    }
                }
            };
            openProgressThread.start();
        }
    };
    public final AbstractRepositoryAction<Entry> STORE_PROCESS_ACTION = new AbstractRepositoryAction<Entry>(Entry.class, true, "repository_store_process"){
        private static final long serialVersionUID = 1252342138665768477L;

        @Override
        public void actionPerformed(Entry entry) {
            if (entry instanceof Folder) {
                this.storeInFolder((Folder)Folder.class.cast(entry));
            }
            if (entry instanceof ProcessEntry) {
                this.overwriteProcess((ProcessEntry)ProcessEntry.class.cast(entry));
            }
        }

        private void storeInFolder(final Folder folder) {
            final String name = SwingTools.showInputDialog("store_process", "", new Object[0]);
            try {
                if (folder.containsEntry(name)) {
                    SwingTools.showVerySimpleErrorMessage("repository_entry_already_exists", name);
                    return;
                }
            }
            catch (RepositoryException e1) {
                SwingTools.showSimpleErrorMessage("cannot_store_process_in_repository", (Throwable)e1, name);
                return;
            }
            if (name != null) {
                ProgressThread storeProgressThread = new ProgressThread("store_process"){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void run() {
                        this.getProgressListener().setTotal(100);
                        try {
                            this.getProgressListener().setCompleted(10);
                            Process process = RapidMinerGUI.getMainFrame().getProcess();
                            process.setProcessLocation(new RepositoryProcessLocation(new RepositoryLocation(folder.getLocation(), name)));
                            folder.createProcessEntry(name, process.getRootOperator().getXML(false));
                            RepositoryTree.this.expandPath(RepositoryTree.this.getSelectionPath());
                        }
                        catch (Exception e) {
                            SwingTools.showSimpleErrorMessage("cannot_store_process_in_repository", (Throwable)e, name);
                        }
                        finally {
                            this.getProgressListener().setCompleted(10);
                            this.getProgressListener().complete();
                        }
                    }
                };
                storeProgressThread.start();
            }
        }

        private void overwriteProcess(final ProcessEntry processEntry) {
            if (SwingTools.showConfirmDialog("overwrite", 0, processEntry.getLocation()) == 0) {
                ProgressThread storeProgressThread = new ProgressThread("store_process"){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void run() {
                        this.getProgressListener().setTotal(100);
                        this.getProgressListener().setCompleted(10);
                        try {
                            Process process = RapidMinerGUI.getMainFrame().getProcess();
                            process.setProcessLocation(new RepositoryProcessLocation(processEntry.getLocation()));
                            processEntry.storeXML(process.getRootOperator().getXML(false));
                        }
                        catch (Exception e) {
                            SwingTools.showSimpleErrorMessage("cannot_store_process_in_repository", (Throwable)e, processEntry.getName());
                        }
                        finally {
                            this.getProgressListener().setCompleted(100);
                            this.getProgressListener().complete();
                        }
                    }
                };
                storeProgressThread.start();
            }
        }

        @Override
        protected void enable() {
            Entry entry = RepositoryTree.this.getSelectedEntry();
            this.setEnabled(Folder.class.isInstance(entry) || ProcessEntry.class.isInstance(entry));
        }
    };
    private final AbstractRepositoryAction<Entry> RENAME_ACTION = new AbstractRepositoryAction<Entry>(Entry.class, true, "repository_rename_entry"){
        private static final long serialVersionUID = 9154545892241244065L;

        @Override
        public void actionPerformed(Entry entry) {
            String name = SwingTools.showInputDialog("file_chooser.rename", entry.getName(), entry.getName());
            if (name != null) {
                boolean success = false;
                try {
                    success = entry.rename(name);
                }
                catch (Exception e) {
                    SwingTools.showSimpleErrorMessage("cannot_rename_entry", (Throwable)e, entry.getName(), name);
                }
                if (!success) {
                    SwingTools.showVerySimpleErrorMessage("cannot_rename_entry", entry.getName(), name);
                }
            }
        }
    };
    public final AbstractRepositoryAction<Entry> DELETE_ACTION = new AbstractRepositoryAction<Entry>(Entry.class, true, "repository_delete_entry"){
        private static final long serialVersionUID = 1L;

        @Override
        public void actionPerformed(Entry entry) {
            if (SwingTools.showConfirmDialog("file_chooser.delete", 0, entry.getName()) == 0) {
                try {
                    entry.delete();
                }
                catch (Exception e1) {
                    SwingTools.showSimpleErrorMessage("cannot_delete_entry", (Throwable)e1, new Object[0]);
                }
            }
        }
    };
    private final Collection<AbstractRepositoryAction<?>> allActions = new LinkedList();
    private EventListenerList listenerList = new EventListenerList();

    public RepositoryTree() {
        this((Dialog)null);
    }

    public RepositoryTree(Dialog owner) {
        super(new RepositoryTreeModel(RepositoryManager.getInstance(null)));
        this.allActions.add(this.OPEN_ACTION);
        this.allActions.add(this.STORE_PROCESS_ACTION);
        this.allActions.add(this.RENAME_ACTION);
        this.allActions.add(this.DELETE_ACTION);
        this.allActions.add(this.CREATE_FOLDER_ACTION);
        this.allActions.add(this.REFRESH_ACTION);
        this.allActions.add(this.COPY_LOCATION_ACTION);
        this.allActions.add(this.CONFIGURE_ACTION);
        this.RENAME_ACTION.addToActionMap(this, 0);
        this.DELETE_ACTION.addToActionMap(this, 0);
        this.REFRESH_ACTION.addToActionMap(this, 0);
        this.setRootVisible(false);
        this.setShowsRootHandles(true);
        this.setCellRenderer(new RepositoryTreeCellRenderer());
        this.getSelectionModel().setSelectionMode(1);
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getButton() == 3) {
                    int row = RepositoryTree.this.getRowForLocation(e.getX(), e.getY());
                    RepositoryTree.this.setSelectionInterval(row, row);
                    if (e.isPopupTrigger()) {
                        RepositoryTree.this.showPopup(e);
                    }
                }
            }

            @Override
            public void mousePressed(MouseEvent e) {
                if (e.getButton() == 3) {
                    int row = RepositoryTree.this.getRowForLocation(e.getX(), e.getY());
                    RepositoryTree.this.setSelectionInterval(row, row);
                    if (e.isPopupTrigger()) {
                        RepositoryTree.this.showPopup(e);
                    }
                }
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                if (e.getButton() == 3) {
                    int row = RepositoryTree.this.getRowForLocation(e.getX(), e.getY());
                    RepositoryTree.this.setSelectionInterval(row, row);
                    if (e.isPopupTrigger()) {
                        RepositoryTree.this.showPopup(e);
                    }
                }
            }
        });
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 2) {
                    TreePath path = RepositoryTree.this.getSelectionPath();
                    if (path == null) {
                        return;
                    }
                    RepositoryTree.this.fireLocationSelected((Entry)path.getLastPathComponent());
                }
            }
        });
        this.setDragEnabled(true);
        this.setTransferHandler(new TransferHandler(){
            private static final long serialVersionUID = 1L;

            @Override
            public boolean canImport(JComponent comp, DataFlavor[] transferFlavors) {
                List<DataFlavor> flavors = Arrays.asList(transferFlavors);
                boolean contains = flavors.contains(DataFlavor.javaFileListFlavor);
                return contains |= flavors.contains(TransferableOperator.LOCAL_TRANSFERRED_REPOSITORY_LOCATION_FLAVOR);
            }

            @Override
            public boolean importData(final TransferHandler.TransferSupport ts) {
                Entry droppedOn;
                if (ts.isDrop()) {
                    Point dropPoint = ts.getDropLocation().getDropPoint();
                    TreePath path = RepositoryTree.this.getPathForLocation((int)dropPoint.getX(), (int)dropPoint.getY());
                    if (path == null) {
                        return false;
                    }
                    droppedOn = (Entry)path.getLastPathComponent();
                } else {
                    droppedOn = RepositoryTree.this.getSelectedEntry();
                }
                if (droppedOn == null) {
                    return false;
                }
                try {
                    List<DataFlavor> flavors = Arrays.asList(ts.getDataFlavors());
                    if (flavors.contains(TransferableOperator.LOCAL_TRANSFERRED_REPOSITORY_LOCATION_FLAVOR)) {
                        final RepositoryLocation loc = (RepositoryLocation)ts.getTransferable().getTransferData(TransferableOperator.LOCAL_TRANSFERRED_REPOSITORY_LOCATION_FLAVOR);
                        if (droppedOn instanceof Folder) {
                            new ProgressThread("copy_repository_entry", true){

                                @Override
                                public void run() {
                                    try {
                                        if (ts.isDrop() && ts.getDropAction() == 2) {
                                            RepositoryManager.getInstance(null).move(loc, (Folder)droppedOn, this.getProgressListener());
                                        } else {
                                            RepositoryManager.getInstance(null).copy(loc, (Folder)droppedOn, this.getProgressListener());
                                        }
                                    }
                                    catch (RepositoryException e) {
                                        SwingTools.showSimpleErrorMessage("error_in_copy_repository_entry", (Throwable)e, loc.toString(), e.getMessage());
                                    }
                                }
                            }.start();
                            return true;
                        }
                        return false;
                    }
                    if (flavors.contains(DataFlavor.javaFileListFlavor)) {
                        List files = (List)ts.getTransferable().getTransferData(DataFlavor.javaFileListFlavor);
                        File file = (File)files.get(0);
                        DataImportWizard.importData(file, droppedOn.getLocation());
                        return true;
                    }
                    return false;
                }
                catch (UnsupportedFlavorException e) {
                    LogService.getRoot().log(Level.WARNING, "Cannot accept drop flavor: " + e, e);
                    return false;
                }
                catch (IOException e) {
                    LogService.getRoot().log(Level.WARNING, "Error during drop: " + e, e);
                    return false;
                }
            }

            @Override
            public int getSourceActions(JComponent c) {
                return 3;
            }

            @Override
            protected Transferable createTransferable(JComponent c) {
                TreePath path = RepositoryTree.this.getSelectionPath();
                if (path != null) {
                    Entry e = (Entry)path.getLastPathComponent();
                    final RepositoryLocation location = e.getLocation();
                    return new Transferable(){

                        @Override
                        public Object getTransferData(DataFlavor flavor) throws UnsupportedFlavorException, IOException {
                            if (flavor.equals(DataFlavor.stringFlavor)) {
                                return location.getAbsoluteLocation();
                            }
                            if (TransferableOperator.LOCAL_TRANSFERRED_REPOSITORY_LOCATION_FLAVOR.equals(flavor)) {
                                return location;
                            }
                            throw new IllegalArgumentException("Flavor not supported: " + flavor);
                        }

                        @Override
                        public DataFlavor[] getTransferDataFlavors() {
                            return new DataFlavor[]{TransferableOperator.LOCAL_TRANSFERRED_REPOSITORY_LOCATION_FLAVOR, DataFlavor.stringFlavor};
                        }

                        @Override
                        public boolean isDataFlavorSupported(DataFlavor flavor) {
                            return TransferableOperator.LOCAL_TRANSFERRED_REPOSITORY_LOCATION_FLAVOR.equals(flavor) || DataFlavor.stringFlavor.equals(flavor);
                        }
                    };
                }
                return null;
            }
        });
        this.getSelectionModel().addTreeSelectionListener(new TreeSelectionListener(){

            @Override
            public void valueChanged(TreeSelectionEvent e) {
                RepositoryTree.this.enableActions();
            }
        });
        this.addTreeExpansionListener(new TreeExpansionListener(){

            @Override
            public void treeExpanded(TreeExpansionEvent event) {
                RepositoryTree.this.selectionModel.setSelectionPath(event.getPath());
            }

            @Override
            public void treeCollapsed(TreeExpansionEvent event) {
                this.treeExpanded(event);
            }
        });
        this.enableActions();
        new ToolTipWindow(owner, new ToolTipWindow.TipProvider(){

            @Override
            public String getTip(Object o) {
                if (o instanceof Entry) {
                    return ToolTipProviderHelper.getTip((Entry)o);
                }
                return null;
            }

            @Override
            public Object getIdUnder(Point point) {
                TreePath path = RepositoryTree.this.getPathForLocation((int)point.getX(), (int)point.getY());
                if (path != null) {
                    return path.getLastPathComponent();
                }
                return null;
            }

            @Override
            public Component getCustomComponent(Object o) {
                if (o instanceof Entry) {
                    return ToolTipProviderHelper.getCustomComponent((Entry)o);
                }
                return null;
            }
        }, this);
    }

    public void addRepositorySelectionListener(RepositorySelectionListener listener) {
        this.listenerList.add(RepositorySelectionListener.class, listener);
    }

    public void removeRepositorySelectionListener(RepositorySelectionListener listener) {
        this.listenerList.remove(RepositorySelectionListener.class, listener);
    }

    private void fireLocationSelected(Entry entry) {
        RepositorySelectionEvent event = null;
        for (RepositorySelectionListener l : (RepositorySelectionListener[])this.listenerList.getListeners(RepositorySelectionListener.class)) {
            if (event == null) {
                event = new RepositorySelectionEvent(entry);
            }
            l.repositoryLocationSelected(event);
        }
    }

    boolean expandIfExists(RepositoryLocation relativeTo, String location) {
        RepositoryLocation loc;
        boolean full = true;
        try {
            loc = new RepositoryLocation(relativeTo, location);
        }
        catch (Exception e) {
            return false;
        }
        Entry entry = null;
        while (true) {
            try {
                entry = loc.locateEntry();
                if (entry != null) {
                    break;
                }
            }
            catch (RepositoryException e) {
                return false;
            }
            if ((loc = loc.parent()) == null) {
                return false;
            }
            full = false;
        }
        if (entry != null) {
            RepositoryTreeModel model = (RepositoryTreeModel)this.getModel();
            TreePath pathTo = model.getPathTo(entry);
            this.expandPath(pathTo);
            this.setSelectionPath(pathTo);
            if (entry instanceof Folder) {
                return full;
            }
        }
        return false;
    }

    public void enableActions() {
        for (AbstractRepositoryAction<?> action : this.allActions) {
            action.enable();
        }
    }

    private void showPopup(MouseEvent e) {
        Collection<Action> customActions;
        TreePath path = this.getSelectionPath();
        if (path == null) {
            return;
        }
        Object selected = path.getLastPathComponent();
        JPopupMenu menu = new JPopupMenu();
        if (selected instanceof Repository && ((Repository)selected).isConfigurable()) {
            menu.add(this.CONFIGURE_ACTION);
        }
        if (selected instanceof DataEntry) {
            menu.add(this.OPEN_ACTION);
        }
        if (selected instanceof ProcessEntry || selected instanceof Folder) {
            menu.add(this.STORE_PROCESS_ACTION);
        }
        if (selected instanceof Entry) {
            menu.add(this.RENAME_ACTION);
        }
        if (selected instanceof Folder) {
            menu.add(this.CREATE_FOLDER_ACTION);
        }
        menu.addSeparator();
        menu.add(CutCopyPasteAction.COPY_ACTION);
        menu.add(CutCopyPasteAction.PASTE_ACTION);
        menu.add(this.COPY_LOCATION_ACTION);
        if (selected instanceof Entry) {
            menu.add(this.DELETE_ACTION);
        }
        if (selected instanceof Folder) {
            menu.addSeparator();
            menu.add(this.REFRESH_ACTION);
        }
        if (selected instanceof Entry && (customActions = ((Entry)selected).getCustomActions()) != null && !customActions.isEmpty()) {
            menu.addSeparator();
            for (Action a : customActions) {
                menu.add(a);
            }
        }
        menu.show(this, e.getX(), e.getY());
    }

    public static void openProcess(final ProcessEntry processEntry) {
        ProgressThread openProgressThread = new ProgressThread("open_process"){

            @Override
            public void run() {
                RepositoryProcessLocation processLocation = new RepositoryProcessLocation(processEntry.getLocation());
                if (RapidMinerGUI.getMainFrame().close()) {
                    OpenAction.open(processLocation, false);
                }
            }
        };
        openProgressThread.start();
    }

    public static void showAsResult(final IOObjectEntry data) {
        ProgressThread downloadProgressThread = new ProgressThread("download_from_repository"){

            @Override
            public void run() {
                try {
                    ResultObject result = (ResultObject)data.retrieveData(this.getProgressListener());
                    result.setSource(data.getLocation().toString());
                    RapidMinerGUI.getMainFrame().getResultDisplay().showResult(result);
                }
                catch (Exception e1) {
                    SwingTools.showSimpleErrorMessage("cannot_fetch_data_from_repository", (Throwable)e1, new Object[0]);
                }
            }
        };
        downloadProgressThread.start();
    }

    private Entry getSelectedEntry() {
        TreePath path = this.getSelectionPath();
        if (path == null) {
            return null;
        }
        Object selected = path.getLastPathComponent();
        if (selected instanceof Entry) {
            return (Entry)selected;
        }
        return null;
    }

    public Collection<AbstractRepositoryAction<?>> getAllActions() {
        return this.allActions;
    }

    private abstract class AbstractRepositoryAction<T extends Entry>
    extends ResourceAction {
        private static final long serialVersionUID = 7980472544436850356L;
        private final Class<T> requiredSelectionType;
        private final boolean needsWriteAccess;

        private AbstractRepositoryAction(Class<T> requiredSelectionType, boolean needsWriteAccess, String i18nKey) {
            super(true, i18nKey, new Object[0]);
            this.requiredSelectionType = requiredSelectionType;
            this.needsWriteAccess = needsWriteAccess;
            this.setEnabled(false);
        }

        @Override
        protected void update(boolean[] conditions) {
        }

        protected void enable() {
            Entry entry = RepositoryTree.this.getSelectedEntry();
            this.setEnabled(entry != null && this.requiredSelectionType.isInstance(entry) && (!this.needsWriteAccess || !entry.isReadOnly()));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            this.actionPerformed((Entry)this.requiredSelectionType.cast(RepositoryTree.this.getSelectedEntry()));
        }

        public abstract void actionPerformed(T var1);
    }
}

