/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.repository.gui;

import com.rapidminer.gui.tools.ExtendedJScrollPane;
import com.rapidminer.gui.tools.ResourceActionAdapter;
import com.rapidminer.gui.tools.ResourceLabel;
import com.rapidminer.gui.tools.SwingTools;
import com.rapidminer.gui.tools.dialogs.ButtonDialog;
import com.rapidminer.repository.DataEntry;
import com.rapidminer.repository.Entry;
import com.rapidminer.repository.Folder;
import com.rapidminer.repository.MalformedRepositoryLocationException;
import com.rapidminer.repository.RepositoryLocation;
import com.rapidminer.repository.gui.RepositorySelectionEvent;
import com.rapidminer.repository.gui.RepositorySelectionListener;
import com.rapidminer.repository.gui.RepositoryTree;
import com.rapidminer.tools.LogService;
import com.rapidminer.tools.ParameterService;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.util.LinkedList;
import java.util.logging.Level;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.TreePath;

public class RepositoryLocationChooser
extends JPanel {
    private static final long serialVersionUID = 1L;
    private final RepositoryTree tree;
    private final JTextField locationField = new JTextField(30);
    private final RepositoryLocation resolveRelativeTo;
    private JCheckBox resolveBox;
    private final LinkedList<ChangeListener> listeners = new LinkedList();
    private final JLabel resultLabel = new JLabel();

    public RepositoryLocationChooser(RepositoryLocation resolveRelativeTo, String initialValue) {
        this(null, resolveRelativeTo, initialValue);
    }

    public RepositoryLocationChooser(Dialog owner, RepositoryLocation resolveRelativeTo, String initialValue) {
        if (initialValue != null) {
            try {
                RepositoryLocation repositoryLocation = new RepositoryLocation(resolveRelativeTo, initialValue);
                this.locationField.setText(repositoryLocation.getName());
                this.resultLabel.setText(repositoryLocation.toString());
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        this.resolveRelativeTo = resolveRelativeTo;
        this.tree = new RepositoryTree(owner);
        if (initialValue != null && this.tree.expandIfExists(resolveRelativeTo, initialValue)) {
            this.locationField.setText("");
        }
        this.tree.getSelectionModel().addTreeSelectionListener(new TreeSelectionListener(){

            @Override
            public void valueChanged(TreeSelectionEvent e) {
                if (e.getPath() != null) {
                    Entry entry = (Entry)e.getPath().getLastPathComponent();
                    if (!(entry instanceof Folder)) {
                        RepositoryLocationChooser.this.locationField.setText(entry.getLocation().getName());
                    }
                    RepositoryLocationChooser.this.updateResult();
                }
                for (ChangeListener l : RepositoryLocationChooser.this.listeners) {
                    l.stateChanged(new ChangeEvent(this));
                }
            }
        });
        this.locationField.addKeyListener(new KeyListener(){

            @Override
            public void keyPressed(KeyEvent e) {
            }

            @Override
            public void keyReleased(KeyEvent e) {
                for (ChangeListener l : RepositoryLocationChooser.this.listeners) {
                    l.stateChanged(new ChangeEvent(this));
                }
                RepositoryLocationChooser.this.updateResult();
            }

            @Override
            public void keyTyped(KeyEvent e) {
                Entry selectedEntry;
                TreePath selectionPath = RepositoryLocationChooser.this.tree.getSelectionPath();
                if (selectionPath != null && !((selectedEntry = (Entry)selectionPath.getLastPathComponent()) instanceof Folder)) {
                    RepositoryLocationChooser.this.tree.setSelectionPath(selectionPath.getParentPath());
                }
            }
        });
        this.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.insets = new Insets(0, 0, 0, 0);
        c.fill = 1;
        c.weightx = 1.0;
        c.weighty = 1.0;
        c.anchor = 23;
        c.gridwidth = 0;
        ExtendedJScrollPane treePane = new ExtendedJScrollPane(this.tree);
        treePane.setBorder(ButtonDialog.createBorder());
        this.add((Component)treePane, c);
        c.insets = new Insets(6, 0, 0, 6);
        c.fill = 2;
        c.weightx = 0.0;
        c.weighty = 0.0;
        c.gridwidth = -1;
        c.weightx = 0.0;
        ResourceLabel label = new ResourceLabel("repository_chooser.entry_name", new Object[0]);
        label.setLabelFor(this.locationField);
        this.add((Component)label, c);
        c.weightx = 1.0;
        c.insets = new Insets(6, 0, 0, 0);
        c.weightx = 1.0;
        c.gridwidth = 0;
        this.add((Component)this.locationField, c);
        c.gridwidth = -1;
        c.weightx = 0.0;
        c.insets = new Insets(6, 0, 0, 6);
        this.add((Component)new ResourceLabel("repository_chooser.location", new Object[0]), c);
        c.weightx = 1.0;
        c.insets = new Insets(6, 0, 0, 0);
        c.gridwidth = 0;
        this.add((Component)this.resultLabel, c);
        if (resolveRelativeTo != null) {
            this.resolveBox = new JCheckBox(new ResourceActionAdapter("repository_chooser.resolve", resolveRelativeTo.getAbsoluteLocation()));
            this.resolveBox.setSelected(System.getProperty("rapidminer.gui.resolve_relative_repository_locations", "true").equals("true"));
            this.add((Component)this.resolveBox, c);
            this.resolveBox.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    RepositoryLocationChooser.this.updateResult();
                }
            });
        }
    }

    public String getRepositoryLocation() throws MalformedRepositoryLocationException {
        if (this.tree.getSelectionPath() != null) {
            Entry selectedEntry = (Entry)this.tree.getSelectionPath().getLastPathComponent();
            RepositoryLocation selectedLocation = selectedEntry.getLocation();
            if (selectedEntry instanceof Folder) {
                selectedLocation = new RepositoryLocation(selectedLocation, this.locationField.getText());
            }
            if (this.resolveRelativeTo != null && this.resolveBox.isSelected()) {
                return selectedLocation.makeRelative(this.resolveRelativeTo);
            }
            return selectedLocation.getAbsoluteLocation();
        }
        return this.locationField.getText();
    }

    public boolean hasSelection() {
        if (this.locationField.getText().isEmpty()) {
            return false;
        }
        try {
            this.getRepositoryLocation();
            return true;
        }
        catch (MalformedRepositoryLocationException e) {
            LogService.getRoot().warning("Malformed repository location: " + e);
            return false;
        }
    }

    public boolean resolveRelative() {
        return this.resolveBox.isSelected();
    }

    public void addChangeListener(ChangeListener l) {
        this.listeners.add(l);
    }

    public void removeChangeListener(ChangeListener l) {
        this.listeners.remove(l);
    }

    public static String selectEntry(RepositoryLocation resolveRelativeTo, Component c) {
        return RepositoryLocationChooser.selectLocation(resolveRelativeTo, null, c, true, false);
    }

    public static String selectFolder(RepositoryLocation resolveRelativeTo, Component c) {
        return RepositoryLocationChooser.selectLocation(resolveRelativeTo, null, c, false, true);
    }

    public static String selectLocation(RepositoryLocation resolveRelativeTo, Component c) {
        return RepositoryLocationChooser.selectLocation(resolveRelativeTo, null, c, true, true);
    }

    public static String selectLocation(RepositoryLocation resolveRelativeTo, String initialValue, Component c, final boolean selectEntries, final boolean selectFolder) {
        final String[] result = new String[1];
        class RepositoryLocationChooserDialog
        extends ButtonDialog {
            private static final long serialVersionUID = -726540444296013310L;
            private RepositoryLocationChooser chooser;

            public RepositoryLocationChooserDialog(RepositoryLocation resolveRelativeTo, String initialValue) {
                super("repository_chooser", true, new Object[0]);
                this.chooser = null;
                this.chooser = new RepositoryLocationChooser(this, resolveRelativeTo, initialValue);
                this.chooser.tree.addRepositorySelectionListener(new RepositorySelectionListener(){

                    @Override
                    public void repositoryLocationSelected(RepositorySelectionEvent e) {
                        Entry entry = e.getEntry();
                        if (selectFolder && entry instanceof Folder || selectEntries && entry instanceof DataEntry) {
                            result[0] = entry.getLocation().toString();
                            this.dispose();
                        }
                    }
                });
                this.layoutDefault((JComponent)this.chooser, 1, this.makeOkButton(), this.makeCancelButton());
            }

            @Override
            protected void ok() {
                try {
                    this.chooser.getRepositoryLocation();
                    super.ok();
                }
                catch (MalformedRepositoryLocationException e) {
                    SwingTools.showSimpleErrorMessage("malformed_repository_location", (Throwable)e, e.getMessage());
                }
            }
        }
        RepositoryLocationChooserDialog dialog = new RepositoryLocationChooserDialog(resolveRelativeTo, initialValue);
        dialog.setVisible(true);
        if (result[0] != null) {
            return result[0];
        }
        if (dialog.wasConfirmed()) {
            String text;
            if (resolveRelativeTo != null) {
                System.setProperty("rapidminer.gui.resolve_relative_repository_locations", dialog.chooser.resolveRelative() ? "true" : "false");
                ParameterService.writePropertyIntoMainUserConfigFile("rapidminer.gui.resolve_relative_repository_locations", dialog.chooser.resolveRelative() ? "true" : "false");
            }
            try {
                text = dialog.chooser.getRepositoryLocation();
            }
            catch (MalformedRepositoryLocationException e) {
                throw new RuntimeException(e);
            }
            if (text.length() > 0) {
                return text;
            }
            return null;
        }
        return null;
    }

    private void updateResult() {
        try {
            String repositoryLocation = this.getRepositoryLocation();
            this.resultLabel.setText(repositoryLocation);
        }
        catch (MalformedRepositoryLocationException e) {
            LogService.getRoot().log(Level.WARNING, "Malformed location: " + e, e);
        }
    }
}

