/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.repository.gui;

import com.rapidminer.gui.MainFrame;
import com.rapidminer.gui.RapidMinerGUI;
import com.rapidminer.gui.tools.ExtendedJScrollPane;
import com.rapidminer.gui.tools.ExtendedJToolBar;
import com.rapidminer.gui.tools.ResourceAction;
import com.rapidminer.gui.tools.ResourceActionAdapter;
import com.rapidminer.gui.tools.ResourceDockKey;
import com.rapidminer.gui.tools.components.DropDownButton;
import com.rapidminer.gui.tools.dialogs.wizards.dataimport.BlobImportWizard;
import com.rapidminer.repository.Entry;
import com.rapidminer.repository.IOObjectEntry;
import com.rapidminer.repository.ProcessEntry;
import com.rapidminer.repository.gui.NewRepositoryDialog;
import com.rapidminer.repository.gui.RepositorySelectionEvent;
import com.rapidminer.repository.gui.RepositorySelectionListener;
import com.rapidminer.repository.gui.RepositoryTree;
import com.vlsolutions.swing.docking.DockKey;
import com.vlsolutions.swing.docking.Dockable;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;

public class RepositoryBrowser
extends JPanel
implements Dockable {
    private static final long serialVersionUID = 1L;
    public static final Action ADD_REPOSITORY_ACTION = new ResourceAction(true, "add_repository", new Object[0]){
        private static final long serialVersionUID = 1L;

        @Override
        public void actionPerformed(ActionEvent e) {
            RepositoryBrowser.addRepository();
        }
    };
    private final RepositoryTree tree;
    public static final String REPOSITORY_BROWSER_DOCK_KEY = "repository_browser";
    private final DockKey DOCK_KEY = new ResourceDockKey("repository_browser");

    public RepositoryBrowser() {
        this.DOCK_KEY.setDockGroup(MainFrame.DOCK_GROUP_ROOT);
        this.tree = new RepositoryTree();
        this.tree.addRepositorySelectionListener(new RepositorySelectionListener(){

            @Override
            public void repositoryLocationSelected(RepositorySelectionEvent e) {
                Entry entry = e.getEntry();
                if (entry instanceof ProcessEntry) {
                    RepositoryTree.openProcess((ProcessEntry)entry);
                } else if (entry instanceof IOObjectEntry) {
                    RepositoryTree.showAsResult((IOObjectEntry)entry);
                }
            }
        });
        this.setLayout(new BorderLayout());
        ExtendedJToolBar toolBar = new ExtendedJToolBar();
        toolBar.setBorder(BorderFactory.createMatteBorder(0, 0, 1, 0, Color.LIGHT_GRAY));
        toolBar.add(ADD_REPOSITORY_ACTION);
        new DropDownButton(new ResourceActionAdapter(true, "import")){
            private static final long serialVersionUID = -5482452738124971463L;

            @Override
            protected JPopupMenu getPopupMenu() {
                JPopupMenu menu = new JPopupMenu();
                menu.add(RapidMinerGUI.getMainFrame().IMPORT_CSV_FILE_ACTION);
                menu.add(RapidMinerGUI.getMainFrame().IMPORT_EXCEL_FILE_ACTION);
                menu.add(RapidMinerGUI.getMainFrame().IMPORT_ACCESS_FILE_ACTION);
                menu.add(RapidMinerGUI.getMainFrame().IMPORT_DATABASE_TABLE_ACTION);
                menu.add(BlobImportWizard.IMPORT_BLOB_ACTION);
                return menu;
            }
        }.addToToolBar(toolBar);
        toolBar.add(this.tree.OPEN_ACTION);
        toolBar.add(this.tree.REFRESH_ACTION);
        toolBar.add(this.tree.CREATE_FOLDER_ACTION);
        this.add((Component)toolBar, "North");
        ExtendedJScrollPane scrollPane = new ExtendedJScrollPane(this.tree);
        scrollPane.setBorder(null);
        this.add((Component)scrollPane, "Center");
    }

    private static void addRepository() {
        NewRepositoryDialog.createNew();
    }

    public Component getComponent() {
        return this;
    }

    public DockKey getDockKey() {
        return this.DOCK_KEY;
    }
}

