/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.repository.gui;

import com.rapidminer.gui.tools.ProgressThread;
import com.rapidminer.gui.tools.ResourceLabel;
import com.rapidminer.gui.tools.SwingTools;
import com.rapidminer.repository.Repository;
import com.rapidminer.repository.RepositoryManager;
import com.rapidminer.repository.gui.RepositoryConfigurationPanel;
import com.rapidminer.repository.remote.RemoteRepository;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.net.MalformedURLException;
import java.net.URL;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JTextField;

public class RemoteRepositoryPanel
extends JPanel
implements RepositoryConfigurationPanel {
    private static final long serialVersionUID = 1L;
    private final JTextField urlField = new JTextField("http://localhost:8080/", 30);
    private final JTextField aliasField = new JTextField("NewRepository", 30);
    private final JTextField userField = new JTextField(System.getProperty("user.name"), 20);
    private final JPasswordField passwordField = new JPasswordField(20);

    public RemoteRepositoryPanel() {
        GridBagLayout gbl = new GridBagLayout();
        this.setLayout(gbl);
        GridBagConstraints c = new GridBagConstraints();
        c.anchor = 23;
        c.weighty = 1.0;
        c.weightx = 0.5;
        c.insets = new Insets(4, 4, 4, 4);
        c.gridwidth = -1;
        ResourceLabel label = new ResourceLabel("repositorydialog.alias", new Object[0]);
        label.setLabelFor(this.aliasField);
        gbl.setConstraints(label, c);
        this.add(label);
        c.gridwidth = 0;
        gbl.setConstraints(this.aliasField, c);
        this.add(this.aliasField);
        c.gridwidth = -1;
        label = new ResourceLabel("repositorydialog.url", new Object[0]);
        label.setLabelFor(this.urlField);
        gbl.setConstraints(label, c);
        this.add(label);
        c.gridwidth = 0;
        gbl.setConstraints(this.urlField, c);
        this.add(this.urlField);
        c.gridwidth = -1;
        c.insets = new Insets(10, 4, 4, 4);
        label = new ResourceLabel("repositorydialog.user", new Object[0]);
        label.setLabelFor(this.userField);
        gbl.setConstraints(label, c);
        this.add(label);
        c.gridwidth = 0;
        gbl.setConstraints(this.userField, c);
        this.add(this.userField);
        c.insets = new Insets(4, 4, 4, 4);
        c.gridwidth = -1;
        label = new ResourceLabel("repositorydialog.password", new Object[0]);
        label.setLabelFor(this.passwordField);
        gbl.setConstraints(label, c);
        this.add(label);
        c.gridwidth = 0;
        gbl.setConstraints(this.passwordField, c);
        this.add(this.passwordField);
        this.aliasField.selectAll();
        this.urlField.selectAll();
        this.userField.selectAll();
    }

    @Override
    public void makeRepository() {
        URL url;
        try {
            url = new URL(this.urlField.getText());
        }
        catch (MalformedURLException e) {
            SwingTools.showSimpleErrorMessage("illegal_url", (Throwable)e, new Object[0]);
            return;
        }
        String alias = this.aliasField.getText().trim();
        if (alias.length() == 0) {
            alias = url.toString();
        }
        final String finalAlias = alias;
        ProgressThread pt = new ProgressThread("add_repository"){

            @Override
            public void run() {
                this.getProgressListener().setTotal(100);
                this.getProgressListener().setCompleted(10);
                RemoteRepository repository = new RemoteRepository(url, finalAlias, RemoteRepositoryPanel.this.userField.getText(), RemoteRepositoryPanel.this.passwordField.getPassword(), false);
                this.getProgressListener().setCompleted(90);
                if (repository != null) {
                    RepositoryManager.getInstance(null).addRepository(repository);
                }
                this.getProgressListener().setCompleted(100);
                this.getProgressListener().complete();
            }
        };
        pt.start();
    }

    @Override
    public void configureUIElementsFrom(Repository remote) {
        this.aliasField.setText(((RemoteRepository)remote).getAlias());
        this.urlField.setText(((RemoteRepository)remote).getBaseUrl().toString());
        this.userField.setText(((RemoteRepository)remote).getUsername());
    }

    @Override
    public boolean configure(Repository repository) {
        URL url;
        try {
            url = new URL(this.urlField.getText());
        }
        catch (MalformedURLException e) {
            SwingTools.showSimpleErrorMessage("illegal_url", (Throwable)e, new Object[0]);
            return false;
        }
        ((RemoteRepository)repository).setBaseUrl(url);
        if (this.passwordField.getPassword() != null && this.passwordField.getPassword().length > 0) {
            ((RemoteRepository)repository).setPassword(this.passwordField.getPassword());
        }
        ((RemoteRepository)repository).setUsername(this.userField.getText());
        ((RemoteRepository)repository).rename(this.aliasField.getText());
        return true;
    }

    @Override
    public JComponent getComponent() {
        return this;
    }
}

