/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.repository.gui;

import com.rapidminer.gui.tools.ResourceAction;
import com.rapidminer.gui.tools.ResourceLabel;
import com.rapidminer.gui.tools.SwingTools;
import com.rapidminer.repository.Repository;
import com.rapidminer.repository.RepositoryException;
import com.rapidminer.repository.RepositoryManager;
import com.rapidminer.repository.gui.RepositoryConfigurationPanel;
import com.rapidminer.repository.local.LocalRepository;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.io.File;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class LocalRepositoryPanel
extends JPanel
implements RepositoryConfigurationPanel {
    private static final long serialVersionUID = 1L;
    private final JTextField fileField = new JTextField(30);
    private final JTextField aliasField = new JTextField("NewLocalRepository", 30);

    public LocalRepositoryPanel() {
        GridBagLayout gbl = new GridBagLayout();
        this.setLayout(gbl);
        GridBagConstraints c = new GridBagConstraints();
        c.anchor = 21;
        c.weighty = 0.0;
        c.weightx = 0.5;
        c.insets = new Insets(4, 4, 4, 4);
        c.fill = 2;
        c.gridwidth = 1;
        ResourceLabel label = new ResourceLabel("repositorydialog.alias", new Object[0]);
        label.setLabelFor(this.aliasField);
        gbl.setConstraints(label, c);
        this.add(label);
        c.gridwidth = 0;
        gbl.setConstraints(this.aliasField, c);
        this.add(this.aliasField);
        c.gridwidth = 1;
        label = new ResourceLabel("repositorydialog.root_directory", new Object[0]);
        label.setLabelFor(this.fileField);
        gbl.setConstraints(label, c);
        this.add(label);
        c.gridwidth = -1;
        gbl.setConstraints(this.fileField, c);
        this.add(this.fileField);
        c.gridwidth = 0;
        JButton chooseFileButton = new JButton(new ResourceAction(true, "choose_file", new Object[0]){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent e) {
                File file = SwingTools.chooseFile((Component)LocalRepositoryPanel.this, null, true, true, (String)null, null);
                if (file != null) {
                    LocalRepositoryPanel.this.fileField.setText(file.toString());
                }
            }
        });
        this.add((Component)chooseFileButton, c);
        JPanel dummy = new JPanel();
        c.fill = 1;
        c.weighty = 1.0;
        gbl.setConstraints(dummy, c);
        this.add(dummy);
        this.aliasField.selectAll();
        this.fileField.selectAll();
    }

    @Override
    public void makeRepository() {
        File file = new File(this.fileField.getText());
        file.mkdir();
        String alias = this.aliasField.getText().trim();
        if (alias.length() == 0) {
            alias = file.getName();
        }
        try {
            RepositoryManager.getInstance(null).addRepository(new LocalRepository(alias, file));
        }
        catch (RepositoryException e) {
            SwingTools.showSimpleErrorMessage("cannot_create_repository", (Throwable)e, new Object[0]);
        }
    }

    @Override
    public void configureUIElementsFrom(Repository repository) {
        this.aliasField.setText(((LocalRepository)repository).getName());
        this.fileField.setText(((LocalRepository)repository).getRoot().getAbsolutePath());
    }

    @Override
    public boolean configure(Repository repository) {
        ((LocalRepository)repository).setRoot(new File(this.fileField.getText()));
        ((LocalRepository)repository).rename(this.aliasField.getText());
        return true;
    }

    @Override
    public JComponent getComponent() {
        return this;
    }
}

