/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.repository.db;

import com.rapidminer.operator.IOObject;
import com.rapidminer.operator.OperatorCreationException;
import com.rapidminer.operator.OperatorException;
import com.rapidminer.operator.io.DatabaseDataReader;
import com.rapidminer.operator.ports.metadata.AttributeMetaData;
import com.rapidminer.operator.ports.metadata.ExampleSetMetaData;
import com.rapidminer.operator.ports.metadata.MetaData;
import com.rapidminer.repository.db.DBConnectionToIOObjectConverter;
import com.rapidminer.tools.OperatorService;
import com.rapidminer.tools.jdbc.ColumnIdentifier;
import com.rapidminer.tools.jdbc.DatabaseHandler;
import com.rapidminer.tools.jdbc.connection.ConnectionEntry;
import java.util.List;

public class StandardDBConnectionToIOObjectConverter
implements DBConnectionToIOObjectConverter {
    @Override
    public IOObject convert(ConnectionEntry connection, String tableName) throws OperatorException {
        DatabaseDataReader reader;
        try {
            reader = OperatorService.createOperator(DatabaseDataReader.class);
        }
        catch (OperatorCreationException e) {
            throw new OperatorException("Failed to create database reader: " + e, e);
        }
        reader.setParameter("connection", connection.getName());
        reader.setParameter("define_connection", DatabaseHandler.CONNECTION_MODES[0]);
        reader.setParameter("table_name", tableName);
        reader.setParameter("define_query", DatabaseHandler.QUERY_MODES[2]);
        return reader.read();
    }

    @Override
    public MetaData convertMetaData(ConnectionEntry connection, String tableName, List<ColumnIdentifier> columns) {
        ExampleSetMetaData metaData = new ExampleSetMetaData();
        for (ColumnIdentifier column : columns) {
            metaData.addAttribute(new AttributeMetaData(column.getColumnName(), DatabaseHandler.getRapidMinerTypeIndex(column.getSqlType())));
        }
        return metaData;
    }

    @Override
    public String getSuffix() {
        return "Example Sets";
    }
}

