/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.repository.db;

import com.rapidminer.operator.IOObject;
import com.rapidminer.operator.Operator;
import com.rapidminer.operator.ports.metadata.ExampleSetMetaData;
import com.rapidminer.operator.ports.metadata.MetaData;
import com.rapidminer.repository.Folder;
import com.rapidminer.repository.IOObjectEntry;
import com.rapidminer.repository.MalformedRepositoryLocationException;
import com.rapidminer.repository.RepositoryException;
import com.rapidminer.repository.RepositoryLocation;
import com.rapidminer.repository.db.DBConnectionConverterFolder;
import com.rapidminer.repository.db.DBConnectionToIOObjectConverter;
import com.rapidminer.tools.ProgressListener;
import com.rapidminer.tools.jdbc.ColumnIdentifier;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.swing.Action;

public class DBConnectionEntry
implements IOObjectEntry {
    private String tableName;
    private DBConnectionConverterFolder folder;
    private MetaData metaData;
    private DBConnectionToIOObjectConverter converter;

    public DBConnectionEntry(DBConnectionConverterFolder parent, DBConnectionToIOObjectConverter converter, String name, List<ColumnIdentifier> columns) {
        this.folder = parent;
        this.converter = converter;
        this.tableName = name;
        this.metaData = converter.convertMetaData(this.folder.getConnectionEntry(), name, columns);
    }

    @Override
    public int getRevision() {
        return 1;
    }

    @Override
    public long getSize() {
        return -1L;
    }

    @Override
    public long getDate() {
        return -1L;
    }

    @Override
    public String getName() {
        return this.tableName;
    }

    @Override
    public String getType() {
        return "data";
    }

    @Override
    public String getOwner() {
        return this.folder.getConnectionEntry().getUser();
    }

    @Override
    public String getDescription() {
        return "Table " + this.getName() + " in " + this.folder.getConnectionEntry().getURL();
    }

    @Override
    public boolean isReadOnly() {
        return true;
    }

    @Override
    public boolean rename(String newName) throws RepositoryException {
        throw new RepositoryException("Cannot rename items in connection entry.");
    }

    @Override
    public boolean move(Folder newParent) throws RepositoryException {
        throw new RepositoryException("Cannot move items in connection entry.");
    }

    @Override
    public Folder getContainingFolder() {
        return this.folder;
    }

    @Override
    public boolean willBlock() {
        return this.metaData == null;
    }

    @Override
    public RepositoryLocation getLocation() {
        try {
            return new RepositoryLocation(this.folder.getLocation(), this.getName());
        }
        catch (MalformedRepositoryLocationException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void delete() throws RepositoryException {
        throw new RepositoryException("Cannot delete items in connection entry.");
    }

    @Override
    public Collection<Action> getCustomActions() {
        return Collections.emptyList();
    }

    @Override
    public IOObject retrieveData(ProgressListener l) throws RepositoryException {
        try {
            return this.converter.convert(this.folder.getConnectionEntry(), this.tableName);
        }
        catch (Exception e) {
            throw new RepositoryException("Failed to read data: " + e, e);
        }
    }

    @Override
    public MetaData retrieveMetaData() throws RepositoryException {
        if (this.metaData == null) {
            this.metaData = new ExampleSetMetaData();
        }
        return this.metaData;
    }

    @Override
    public void storeData(IOObject data, Operator callingOperator, ProgressListener l) throws RepositoryException {
        throw new RepositoryException("Cannot store items in connection entry.");
    }

    @Override
    public Class<? extends IOObject> getObjectClass() {
        return this.metaData.getObjectClass();
    }
}

