/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.repository.db;

import com.rapidminer.operator.IOObject;
import com.rapidminer.operator.Operator;
import com.rapidminer.repository.BlobEntry;
import com.rapidminer.repository.DataEntry;
import com.rapidminer.repository.Folder;
import com.rapidminer.repository.IOObjectEntry;
import com.rapidminer.repository.MalformedRepositoryLocationException;
import com.rapidminer.repository.ProcessEntry;
import com.rapidminer.repository.RepositoryException;
import com.rapidminer.repository.RepositoryLocation;
import com.rapidminer.repository.db.DBConnectionEntry;
import com.rapidminer.repository.db.DBConnectionFolder;
import com.rapidminer.repository.db.DBConnectionToIOObjectConverter;
import com.rapidminer.repository.db.DBRepository;
import com.rapidminer.tools.ProgressListener;
import com.rapidminer.tools.jdbc.ColumnIdentifier;
import com.rapidminer.tools.jdbc.connection.ConnectionEntry;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.swing.Action;

public class DBConnectionConverterFolder
implements Folder {
    private final ConnectionEntry entry;
    private final DBConnectionToIOObjectConverter converter;
    private final DBRepository repository;
    private final DBConnectionFolder parent;
    private final Map<String, List<ColumnIdentifier>> allTableMetaData;
    private List<DataEntry> entries;

    public DBConnectionConverterFolder(DBRepository dbRepository, DBConnectionFolder parent, ConnectionEntry dbConEntry, DBConnectionToIOObjectConverter converter, Map<String, List<ColumnIdentifier>> allTableMetaData) throws RepositoryException {
        this.repository = dbRepository;
        this.parent = parent;
        this.entry = dbConEntry;
        this.converter = converter;
        this.allTableMetaData = allTableMetaData;
        this.ensureLoaded();
    }

    @Override
    public String getName() {
        return this.converter.getSuffix();
    }

    @Override
    public String getType() {
        return "folder";
    }

    @Override
    public String getOwner() {
        return null;
    }

    @Override
    public String getDescription() {
        return this.getName() + " (" + this.entry.getURL() + ")";
    }

    @Override
    public boolean isReadOnly() {
        return true;
    }

    @Override
    public boolean rename(String newName) throws RepositoryException {
        throw new RepositoryException("Cannot rename connection entry.");
    }

    @Override
    public boolean move(Folder newParent) throws RepositoryException {
        throw new RepositoryException("Cannot move connection entry.");
    }

    @Override
    public Folder getContainingFolder() {
        return this.repository;
    }

    @Override
    public boolean willBlock() {
        return false;
    }

    @Override
    public RepositoryLocation getLocation() {
        try {
            return new RepositoryLocation(this.parent.getLocation(), this.getName());
        }
        catch (MalformedRepositoryLocationException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void delete() throws RepositoryException {
        throw new RepositoryException("Cannot delete connection entry.");
    }

    @Override
    public Collection<Action> getCustomActions() {
        return Collections.emptyList();
    }

    @Override
    public List<DataEntry> getDataEntries() throws RepositoryException {
        return this.entries;
    }

    @Override
    public List<Folder> getSubfolders() throws RepositoryException {
        return Collections.emptyList();
    }

    @Override
    public void refresh() throws RepositoryException {
        this.entries = null;
        this.ensureLoaded();
        this.repository.fireRefreshed(this);
    }

    @Override
    public boolean containsEntry(String name) throws RepositoryException {
        for (DataEntry entry : this.entries) {
            if (!entry.getName().equals(name)) continue;
            return true;
        }
        return false;
    }

    @Override
    public Folder createFolder(String name) throws RepositoryException {
        throw new RepositoryException("Cannot create folder in connection entry.");
    }

    @Override
    public IOObjectEntry createIOObjectEntry(String name, IOObject ioobject, Operator callingOperator, ProgressListener progressListener) throws RepositoryException {
        throw new RepositoryException("Cannot create items in connection entry.");
    }

    @Override
    public ProcessEntry createProcessEntry(String name, String processXML) throws RepositoryException {
        throw new RepositoryException("Cannot create items in connection entry.");
    }

    @Override
    public BlobEntry createBlobEntry(String name) throws RepositoryException {
        throw new RepositoryException("Cannot create items in connection entry.");
    }

    protected ConnectionEntry getConnectionEntry() {
        return this.entry;
    }

    private void ensureLoaded() throws RepositoryException {
        if (this.entries == null) {
            this.entries = new LinkedList<DataEntry>();
            for (Map.Entry<String, List<ColumnIdentifier>> tableEntry : this.allTableMetaData.entrySet()) {
                this.entries.add(new DBConnectionEntry(this, this.converter, tableEntry.getKey(), tableEntry.getValue()));
            }
        }
    }
}

