/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.repository;

import com.rapidminer.RapidMiner;
import com.rapidminer.gui.tools.SwingTools;
import com.rapidminer.io.process.XMLTools;
import com.rapidminer.operator.IOObject;
import com.rapidminer.operator.Operator;
import com.rapidminer.repository.BlobEntry;
import com.rapidminer.repository.DataEntry;
import com.rapidminer.repository.Entry;
import com.rapidminer.repository.Folder;
import com.rapidminer.repository.IOObjectEntry;
import com.rapidminer.repository.ProcessEntry;
import com.rapidminer.repository.Repository;
import com.rapidminer.repository.RepositoryAccessor;
import com.rapidminer.repository.RepositoryException;
import com.rapidminer.repository.RepositoryFactory;
import com.rapidminer.repository.RepositoryLocation;
import com.rapidminer.repository.RepositoryVisitor;
import com.rapidminer.repository.db.DBRepository;
import com.rapidminer.repository.gui.NewRepositoryDialog;
import com.rapidminer.repository.local.LocalRepository;
import com.rapidminer.repository.remote.RemoteRepository;
import com.rapidminer.repository.resource.ResourceRepository;
import com.rapidminer.tools.AbstractObservable;
import com.rapidminer.tools.LogService;
import com.rapidminer.tools.ParameterService;
import com.rapidminer.tools.ProgressListener;
import com.rapidminer.tools.Tools;
import com.rapidminer.tools.XMLException;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class RepositoryManager
extends AbstractObservable<Repository> {
    public static final String SAMPLE_REPOSITORY_NAME = "Samples";
    private static final Logger LOGGER = Logger.getLogger(RepositoryManager.class.getName());
    private static RepositoryManager instance;
    private static final Object INSTANCE_LOCK;
    private static Repository sampleRepository;
    private static final Map<RepositoryAccessor, RepositoryManager> CACHED_MANAGERS;
    private static final List<RepositoryFactory> FACTORIES;
    private final List<Repository> repositories = new LinkedList<Repository>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static RepositoryManager getInstance(RepositoryAccessor repositoryAccessor) {
        Object object = INSTANCE_LOCK;
        synchronized (object) {
            if (instance == null) {
                RepositoryManager.init();
            }
            if (repositoryAccessor != null) {
                RepositoryManager manager = CACHED_MANAGERS.get(repositoryAccessor);
                if (manager == null) {
                    manager = new RepositoryManager(instance);
                    for (RepositoryFactory factory : FACTORIES) {
                        for (Repository repository : factory.createRepositoriesFor(repositoryAccessor)) {
                            manager.repositories.add(repository);
                        }
                    }
                    CACHED_MANAGERS.put(repositoryAccessor, manager);
                }
                return manager;
            }
        }
        return instance;
    }

    private RepositoryManager(RepositoryManager cloned) {
        this.repositories.addAll(cloned.repositories);
    }

    private RepositoryManager() {
        if (sampleRepository == null) {
            sampleRepository = new ResourceRepository(SAMPLE_REPOSITORY_NAME, "/com/rapidminer/resources/samples");
        }
        this.repositories.add(sampleRepository);
        this.repositories.add(new DBRepository());
        String homeUrl = System.getProperty("rapidminer.homerepository.url");
        if (homeUrl != null) {
            try {
                RemoteRepository homeRepository = new RemoteRepository(new URL(homeUrl), "Home", System.getProperty("rapidminer.homerepository.user"), null, true);
                this.repositories.add(homeRepository);
                LogService.getRoot().config("Adding home repository " + homeUrl + ".");
            }
            catch (MalformedURLException e) {
                LogService.getRoot().log(Level.WARNING, "Illegal repository URL " + homeUrl + ": " + e, e);
            }
        }
        this.load();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void init() {
        Object object = INSTANCE_LOCK;
        synchronized (object) {
            instance = new RepositoryManager();
            instance.postInstall();
        }
    }

    private void postInstall() {
        for (Repository repository : this.getRepositories()) {
            repository.postInstall();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void registerFactory(RepositoryFactory factory) {
        Object object = INSTANCE_LOCK;
        synchronized (object) {
            FACTORIES.add(factory);
        }
    }

    public void addRepository(Repository repository) {
        LOGGER.config("Adding repository " + repository.getName());
        this.repositories.add(repository);
        if (instance != null) {
            repository.postInstall();
            this.save();
        }
        this.fireUpdate(repository);
    }

    public void removeRepository(Repository repository) {
        repository.preRemove();
        this.repositories.remove(repository);
        this.fireUpdate(null);
    }

    public List<Repository> getRepositories() {
        return Collections.unmodifiableList(this.repositories);
    }

    public Repository getRepository(String name) throws RepositoryException {
        for (Repository repos : this.repositories) {
            if (!repos.getName().equals(name)) continue;
            return repos;
        }
        throw new RepositoryException("Requested repository " + name + " does not exist.");
    }

    public List<RemoteRepository> getRemoteRepositories() {
        LinkedList<RemoteRepository> result = new LinkedList<RemoteRepository>();
        for (Repository repos : this.getRepositories()) {
            if (!(repos instanceof RemoteRepository)) continue;
            result.add((RemoteRepository)repos);
        }
        return result;
    }

    private File getConfigFile() {
        return ParameterService.getUserConfigFile("repositories.xml");
    }

    public void load() {
        if (!RapidMiner.getExecutionMode().canAccessFilesystem()) {
            LOGGER.info("Cannot access file system in execution mode " + (Object)((Object)RapidMiner.getExecutionMode()) + ". Not loading repositories.");
            return;
        }
        File file = this.getConfigFile();
        if (file.exists()) {
            LOGGER.config("Loading repositories from " + file);
            try {
                Document doc = DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(file);
                if (!doc.getDocumentElement().getTagName().equals("repositories")) {
                    LOGGER.warning("Broken repositories file. Root element must be <reposities>.");
                    return;
                }
                NodeList list = doc.getDocumentElement().getChildNodes();
                for (int i = 0; i < list.getLength(); ++i) {
                    if (!(list.item(i) instanceof Element)) continue;
                    Element element = (Element)list.item(i);
                    if ("localRepository".equals(element.getTagName())) {
                        this.addRepository(LocalRepository.fromXML(element));
                        continue;
                    }
                    if ("remoteRepository".equals(element.getTagName())) {
                        this.addRepository(RemoteRepository.fromXML(element));
                        continue;
                    }
                    LOGGER.warning("Unknown tag: " + element.getTagName());
                }
            }
            catch (Exception e) {
                LOGGER.log(Level.WARNING, "Cannot read repository configuration file '" + file + "': " + e, e);
            }
        }
    }

    public void createRepositoryIfNoneIsDefined() {
        boolean empty = true;
        for (Repository repository : this.repositories) {
            if (repository instanceof ResourceRepository || repository instanceof DBRepository) continue;
            empty = false;
            break;
        }
        if (empty) {
            SwingTools.showMessageDialog("please_create_repository", new Object[0]);
            NewRepositoryDialog.createNew();
        }
    }

    public void save() {
        Document doc;
        if (!RapidMiner.getExecutionMode().canAccessFilesystem()) {
            LOGGER.config("Cannot access file system in execution mode " + (Object)((Object)RapidMiner.getExecutionMode()) + ". Not saving repositories.");
            return;
        }
        try {
            doc = DocumentBuilderFactory.newInstance().newDocumentBuilder().newDocument();
        }
        catch (ParserConfigurationException e) {
            LOGGER.log(Level.WARNING, "Cannot save repositories: " + e, e);
            return;
        }
        Element root = doc.createElement("repositories");
        doc.appendChild(root);
        for (Repository repository : this.getRepositories()) {
            Element repositoryElement;
            if (!repository.shouldSave() || (repositoryElement = repository.createXML(doc)) == null) continue;
            root.appendChild(repositoryElement);
        }
        try {
            XMLTools.stream(doc, this.getConfigFile(), null);
        }
        catch (XMLException e) {
            LOGGER.log(Level.WARNING, "Cannot save repositories: " + e, e);
        }
    }

    public IOObject store(IOObject ioobject, RepositoryLocation location, Operator callingOperator) throws RepositoryException {
        return this.store(ioobject, location, callingOperator, null);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public IOObject store(IOObject ioobject, RepositoryLocation location, Operator callingOperator, ProgressListener progressListener) throws RepositoryException {
        Entry entry = location.locateEntry();
        if (entry == null) {
            Folder parentFolder;
            RepositoryLocation parentLocation = location.parent();
            if (parentLocation == null) throw new RepositoryException("Entry '" + location + "' does not exist.");
            String childName = location.getName();
            Entry parentEntry = parentLocation.locateEntry();
            if (parentEntry != null) {
                if (!(parentEntry instanceof Folder)) throw new RepositoryException("Parent '" + parentLocation + "' of '" + location + "' is not a folder.");
                parentFolder = (Folder)parentEntry;
            } else {
                parentFolder = parentLocation.createFoldersRecursively();
            }
            parentFolder.createIOObjectEntry(childName, ioobject, callingOperator, progressListener);
            return ioobject;
        }
        if (!(entry instanceof IOObjectEntry)) throw new RepositoryException("Entry '" + location + "' is not a data entry, but " + entry.getType());
        ((IOObjectEntry)entry).storeData(ioobject, callingOperator, null);
        return ioobject;
    }

    public static void shutdown() {
        if (instance != null) {
            instance.save();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void copy(RepositoryLocation source, Folder destination, ProgressListener listener) throws RepositoryException {
        listener.setTotal(100000);
        listener.setCompleted(0);
        try {
            this.copy(source, destination, listener, 0, 100000);
        }
        finally {
            listener.complete();
        }
    }

    private void copy(RepositoryLocation source, Folder destination, ProgressListener listener, int minProgress, int maxProgress) throws RepositoryException {
        Entry entry = source.locateEntry();
        if (entry == null) {
            throw new RepositoryException("No such entry: " + source);
        }
        this.copy(entry, destination, listener, minProgress, maxProgress);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void copy(Entry entry, Folder destination, ProgressListener listener, int minProgress, int maxProgress) throws RepositoryException {
        String newName;
        if (listener != null) {
            listener.setMessage(entry.getName());
        }
        if (destination.containsEntry(newName = entry.getName())) {
            newName = "Copy of " + newName;
            int i = 1;
            while (destination.containsEntry(newName)) {
                newName = "Copy " + i++ + " of " + newName;
            }
        }
        if (entry instanceof ProcessEntry) {
            ProcessEntry pe = (ProcessEntry)entry;
            String xml = pe.retrieveXML();
            if (listener != null) {
                listener.setCompleted((minProgress + maxProgress) / 2);
            }
            destination.createProcessEntry(newName, xml);
            if (listener == null) return;
            listener.setCompleted(maxProgress);
            return;
        } else if (entry instanceof IOObjectEntry) {
            IOObjectEntry iooe = (IOObjectEntry)entry;
            IOObject original = iooe.retrieveData(null);
            if (listener != null) {
                listener.setCompleted((minProgress + maxProgress) / 2);
            }
            destination.createIOObjectEntry(newName, original, null, null);
            if (listener == null) return;
            listener.setCompleted(maxProgress);
            return;
        } else if (entry instanceof BlobEntry) {
            BlobEntry blob = (BlobEntry)entry;
            BlobEntry target = destination.createBlobEntry(newName);
            try {
                Tools.copyStreamSynchronously(blob.openInputStream(), target.openOutputStream(blob.getMimeType()), true);
                if (listener == null) return;
                listener.setCompleted(maxProgress);
                return;
            }
            catch (IOException e) {
                throw new RepositoryException(e);
            }
        } else {
            if (!(entry instanceof Folder)) throw new RepositoryException("Cannot copy entry of type " + entry.getType());
            Folder destinationFolder = destination.createFolder(entry.getName());
            LinkedList<Entry> allChildren = new LinkedList<Entry>();
            allChildren.addAll(((Folder)entry).getSubfolders());
            allChildren.addAll(((Folder)entry).getDataEntries());
            int count = allChildren.size();
            int progressStart = minProgress;
            int progressDiff = maxProgress - minProgress;
            int i = 0;
            for (Entry child : allChildren) {
                this.copy(child, destinationFolder, listener, progressStart + i * progressDiff / count, progressStart + (i + 1) * progressDiff / count);
                ++i;
            }
        }
    }

    public void move(RepositoryLocation source, Folder destination, ProgressListener l) throws RepositoryException {
        Entry entry = source.locateEntry();
        if (entry == null) {
            throw new RepositoryException("No such entry: " + source);
        }
        if (destination.getLocation().getRepository() != source.getRepository()) {
            this.copy(source, destination, l);
            entry.delete();
        } else {
            String newName = source.getName();
            if (destination.containsEntry(newName)) {
                throw new RepositoryException("Destination contains element with name: " + newName);
            }
            l.setTotal(100);
            l.setCompleted(10);
            entry.move(destination);
            l.setCompleted(100);
            l.complete();
        }
    }

    public Entry locate(Repository repository, String path, boolean failIfBlocks) throws RepositoryException {
        if (path.startsWith("/")) {
            path = path.substring(1);
        }
        if (path.equals("")) {
            return repository;
        }
        String[] splitted = path.split("/");
        Folder folder = repository;
        int index = 0;
        while (!failIfBlocks || !folder.willBlock()) {
            if (index == splitted.length - 1) {
                LinkedList<Entry> all = new LinkedList<Entry>();
                all.addAll(folder.getSubfolders());
                all.addAll(folder.getDataEntries());
                for (Entry child : all) {
                    if (!child.getName().equals(splitted[index])) continue;
                    return child;
                }
                return null;
            }
            boolean found = false;
            for (Folder subfolder : folder.getSubfolders()) {
                if (!subfolder.getName().equals(splitted[index])) continue;
                folder = subfolder;
                found = true;
                break;
            }
            if (!found) {
                return null;
            }
            ++index;
        }
        return null;
    }

    public Repository getSampleRepository() {
        return sampleRepository;
    }

    public <T extends Entry> void walk(Entry start, RepositoryVisitor<T> visitor, Class<T> visitedType) throws RepositoryException {
        boolean continueChildren = true;
        if (visitedType == null || visitedType.isInstance(start)) {
            continueChildren &= visitor.visit((Entry)visitedType.cast(start));
        }
        if (continueChildren && start instanceof Folder) {
            Folder folder = (Folder)start;
            for (DataEntry child : folder.getDataEntries()) {
                this.walk(child, visitor, visitedType);
            }
            for (Folder childFolder : folder.getSubfolders()) {
                this.walk(childFolder, visitor, visitedType);
            }
        }
    }

    static {
        INSTANCE_LOCK = new Object();
        CACHED_MANAGERS = new HashMap<RepositoryAccessor, RepositoryManager>();
        FACTORIES = new LinkedList<RepositoryFactory>();
    }
}

