/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.repository;

import com.rapidminer.repository.Entry;
import com.rapidminer.repository.Folder;
import com.rapidminer.repository.MalformedRepositoryLocationException;
import com.rapidminer.repository.Repository;
import com.rapidminer.repository.RepositoryAccessor;
import com.rapidminer.repository.RepositoryException;
import com.rapidminer.repository.RepositoryManager;
import java.util.Arrays;
import java.util.LinkedList;

public class RepositoryLocation {
    public static final char SEPARATOR = '/';
    public static final String REPOSITORY_PREFIX = "//";
    private String repositoryName;
    private String[] path;
    private RepositoryAccessor accessor;

    public RepositoryLocation(String absoluteLocation) throws MalformedRepositoryLocationException {
        if (RepositoryLocation.isAbsolute(absoluteLocation)) {
            this.initializeFromAbsoluteLocation(absoluteLocation);
        } else {
            this.repositoryName = null;
            this.initializeAbsolutePath(absoluteLocation);
        }
    }

    public RepositoryLocation(String repositoryName, String[] pathComponents) throws MalformedRepositoryLocationException {
        this.repositoryName = repositoryName;
        this.path = pathComponents;
    }

    public RepositoryLocation(RepositoryLocation parent, String childName) throws MalformedRepositoryLocationException {
        if (RepositoryLocation.isAbsolute(childName)) {
            this.initializeFromAbsoluteLocation(childName);
        } else if (childName.startsWith("/")) {
            this.repositoryName = parent.repositoryName;
            this.initializeAbsolutePath(childName);
        } else {
            this.repositoryName = parent.repositoryName;
            String[] components = childName.split("/");
            LinkedList<String> newComponents = new LinkedList<String>();
            newComponents.addAll(Arrays.asList(parent.path));
            for (String component : components) {
                if (".".equals(component)) continue;
                if ("..".equals(component)) {
                    if (!newComponents.isEmpty()) {
                        newComponents.removeLast();
                        continue;
                    }
                    throw new IllegalArgumentException("Cannot resolve relative location '" + childName + "' with respect to '" + parent + "': Too many '..'");
                }
                newComponents.add(component);
            }
            this.path = newComponents.toArray(new String[newComponents.size()]);
        }
    }

    private void initializeFromAbsoluteLocation(String absoluteLocation) throws MalformedRepositoryLocationException {
        if (!RepositoryLocation.isAbsolute(absoluteLocation)) {
            throw new MalformedRepositoryLocationException("Location is not absolute: '" + absoluteLocation + "'!");
        }
        String tmp = absoluteLocation.substring(2);
        int nextSlash = tmp.indexOf(47);
        if (nextSlash == -1) {
            throw new MalformedRepositoryLocationException("Malformed repositoy location: " + absoluteLocation + ": path component missing.");
        }
        this.repositoryName = tmp.substring(0, nextSlash);
        this.initializeAbsolutePath(tmp.substring(nextSlash));
    }

    private void initializeAbsolutePath(String path) throws MalformedRepositoryLocationException {
        if (!path.startsWith("/")) {
            throw new MalformedRepositoryLocationException("No absolute path: " + path);
        }
        path = path.substring(1);
        this.path = path.split("/");
    }

    private static void checkName(String name) throws MalformedRepositoryLocationException {
        if (name.contains("/")) {
            throw new MalformedRepositoryLocationException("Names must not contain '/'.");
        }
    }

    public String getAbsoluteLocation() {
        StringBuilder b = new StringBuilder();
        b.append(REPOSITORY_PREFIX);
        b.append(this.repositoryName);
        for (String component : this.path) {
            b.append('/');
            b.append(component);
        }
        return b.toString();
    }

    public Repository getRepository() throws RepositoryException {
        return RepositoryManager.getInstance(this.getAccessor()).getRepository(this.repositoryName);
    }

    public String getRepositoryName() {
        return this.repositoryName;
    }

    public String getPath() {
        StringBuilder b = new StringBuilder();
        for (String component : this.path) {
            b.append('/');
            b.append(component);
        }
        return b.toString();
    }

    public Entry locateEntry() throws RepositoryException {
        Repository repos = this.getRepository();
        if (repos != null) {
            Entry entry = repos.locate(this.getPath());
            return entry;
        }
        return null;
    }

    public String getName() {
        return this.path[this.path.length - 1];
    }

    public RepositoryLocation parent() {
        RepositoryLocation parent;
        if (this.path.length == 0) {
            return null;
        }
        String[] pathCopy = new String[this.path.length - 1];
        System.arraycopy(this.path, 0, pathCopy, 0, this.path.length - 1);
        try {
            parent = new RepositoryLocation(this.repositoryName, pathCopy);
        }
        catch (MalformedRepositoryLocationException e) {
            throw new RuntimeException(e);
        }
        parent.setAccessor(this.accessor);
        return parent;
    }

    public String toString() {
        return this.getAbsoluteLocation();
    }

    public String makeRelative(RepositoryLocation relativeToFolder) {
        int j;
        if (!this.repositoryName.equals(relativeToFolder.repositoryName)) {
            return this.getAbsoluteLocation();
        }
        int min = Math.min(this.path.length, relativeToFolder.path.length);
        for (int i = 0; i < min && this.path[i].equals(relativeToFolder.path[i]); ++i) {
        }
        StringBuilder result = new StringBuilder();
        for (j = i; j < relativeToFolder.path.length; ++j) {
            result.append("..");
            result.append('/');
        }
        for (j = i; j < this.path.length; ++j) {
            result.append(this.path[j]);
            if (j >= this.path.length - 1) continue;
            result.append('/');
        }
        return result.toString();
    }

    public static boolean isAbsolute(String loc) {
        return loc.startsWith(REPOSITORY_PREFIX);
    }

    public Folder createFoldersRecursively() throws RepositoryException {
        Entry entry = this.locateEntry();
        if (entry == null) {
            Folder folder = this.parent().createFoldersRecursively();
            Folder child = folder.createFolder(this.getName());
            return child;
        }
        if (entry instanceof Folder) {
            return (Folder)entry;
        }
        throw new RepositoryException(this.toString() + " is not a folder.");
    }

    public boolean equals(Object obj) {
        return obj != null && this.toString().equals(obj.toString());
    }

    public int hashCode() {
        return this.toString().hashCode();
    }

    public void setAccessor(RepositoryAccessor accessor) {
        this.accessor = accessor;
    }

    public RepositoryAccessor getAccessor() {
        return this.accessor;
    }
}

