/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.parameter.value;

import com.rapidminer.operator.Operator;
import com.rapidminer.parameter.ParameterType;
import com.rapidminer.parameter.ParameterTypeTupel;

public abstract class ParameterValues {
    protected transient Operator operator;
    protected transient ParameterType type;
    protected String key;

    public ParameterValues(Operator operator, ParameterType type) {
        this.operator = operator;
        this.type = type;
    }

    public Operator getOperator() {
        return this.operator;
    }

    public ParameterType getParameterType() {
        return this.type;
    }

    public String getKey() {
        return ParameterTypeTupel.transformTupel2String(this.operator.getName(), this.type.getKey());
    }

    public abstract int getNumberOfValues();

    public abstract String getValuesString();

    public abstract void move(int var1, int var2);

    public String[] getValuesArray() {
        return null;
    }

    public static boolean isValidNumericalParameter(String value) {
        if (value.startsWith("%{") && value.endsWith("}")) {
            return true;
        }
        try {
            Double.valueOf(value);
            return true;
        }
        catch (NumberFormatException e) {
            return false;
        }
    }
}

