/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.parameter.value;

import com.rapidminer.operator.Operator;
import com.rapidminer.parameter.ParameterType;
import com.rapidminer.parameter.value.ParameterValues;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

public class ParameterValueList
extends ParameterValues
implements Iterable {
    List<String> values;

    public ParameterValueList(Operator operator, ParameterType type) {
        this(operator, type, new LinkedList<String>());
    }

    public ParameterValueList(Operator operator, ParameterType type, String[] valuesArray) {
        super(operator, type);
        this.values = new LinkedList<String>();
        for (int i = 0; i < valuesArray.length; ++i) {
            this.values.add(valuesArray[i]);
        }
    }

    public ParameterValueList(Operator operator, ParameterType type, List<String> values) {
        super(operator, type);
        this.values = values;
    }

    @Override
    public void move(int index, int direction) {
        int newPosition = index + direction;
        if (newPosition >= 0 && newPosition < this.values.size()) {
            String object = this.values.remove(index);
            this.values.add(newPosition, object);
        }
    }

    public List<String> getValues() {
        return this.values;
    }

    @Override
    public String[] getValuesArray() {
        String[] valuesArray = new String[this.values.size()];
        this.values.toArray(valuesArray);
        return valuesArray;
    }

    public void add(String value) {
        this.values.add(value);
    }

    public boolean contains(String value) {
        return this.values.contains(value);
    }

    public void remove(String value) {
        this.values.remove(value);
    }

    public Iterator iterator() {
        return this.values.iterator();
    }

    @Override
    public int getNumberOfValues() {
        return this.values.size();
    }

    @Override
    public String getValuesString() {
        StringBuffer valuesStringBuffer = new StringBuffer();
        boolean first = true;
        for (String value : this.values) {
            if (!first) {
                valuesStringBuffer.append(",");
            }
            first = false;
            valuesStringBuffer.append(value);
        }
        return valuesStringBuffer.toString();
    }

    public String toString() {
        return "list: " + this.getValuesString();
    }
}

